/*
 * Decompiled with CFR 0.152.
 */
package com.rcx.aobdorechunks;

import com.google.common.collect.Lists;
import com.rcx.aobdorechunks.item.ItemOrechunk;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.oredict.OreDictionary;
import thelm.jaopca.api.EnumEntryType;
import thelm.jaopca.api.IOreEntry;
import thelm.jaopca.api.IProperties;
import thelm.jaopca.api.ItemEntry;
import thelm.jaopca.api.JAOPCAApi;
import thelm.jaopca.api.ModuleBase;
import thelm.jaopca.api.item.ItemProperties;
import thelm.jaopca.api.utils.Utils;

public class ModuleOreChunks
extends ModuleBase {
    public static final ItemProperties ORECHUNK_PROPERTIES = new ItemProperties().setItemClass(ItemOrechunk.class);
    public static final ItemEntry ORECHUNK_ENTRY = new ItemEntry(EnumEntryType.ITEM, "oreChunk", new ModelResourceLocation("jaopcaoc:orechunk_stone#inventory")).setProperties((IProperties)ORECHUNK_PROPERTIES);
    public static HashMap<String, OreInfos> dropMap = new HashMap();
    public static List<FirstOreInfos> oreInformation = new ArrayList<FirstOreInfos>();
    String processingUnit;

    public String getName() {
        return "orechunks";
    }

    public List<ItemEntry> getItemRequests() {
        return Lists.newArrayList((Object[])new ItemEntry[]{ORECHUNK_ENTRY});
    }

    public void registerConfigs(Configuration config) {
        for (IOreEntry entry : JAOPCAApi.ENTRY_NAME_TO_ORES_MAP.get((Object)"oreChunk")) {
            String stoneComment = "The stone type for this ore, only has a visual effect";
            String stoneType = entry.getOreName().equals("Eximite") || entry.getOreName().equals("Meutoite") ? config.getString("stoneType", Utils.to_under_score((String)entry.getOreName()), "end", stoneComment) : (entry.getOreName().equals("Cobalt") || entry.getOreName().equals("Ardite") || entry.getOreName().equals("Ignatius") || entry.getOreName().equals("ShadowIron") || entry.getOreName().equals("Lemurite") || entry.getOreName().equals("Midasium") || entry.getOreName().equals("Vyroxeres") || entry.getOreName().equals("Ceruclase") || entry.getOreName().equals("Alduorite") || entry.getOreName().equals("Kalendrite") || entry.getOreName().equals("Vulcanite") || entry.getOreName().equals("Sanguinite") ? config.getString("stoneType", Utils.to_under_score((String)entry.getOreName()), "nether", stoneComment) : config.getString("stoneType", Utils.to_under_score((String)entry.getOreName()), "stone", stoneComment));
            oreInformation.add(new FirstOreInfos(entry, stoneType, config.getInt("dropCount", Utils.to_under_score((String)entry.getOreName()), 1, 1, 100, "The amount of ore chunks dropped by this ore"), config.getInt("minXPDrop", Utils.to_under_score((String)entry.getOreName()), 1, 0, 1000, "The minimum amount of XP dropped by this ore"), config.getInt("maxXPDrop", Utils.to_under_score((String)entry.getOreName()), 4, 0, 1000, "The maximum amount of XP dropped by this ore")));
        }
        this.processingUnit = config.getString("processingUnit", "ore_chunks", "ore", "The ore dictionary prefix for ore chunks, set this to \"dust\" to prevent ore multiplication of ore chunks");
    }

    public void preInit() {
        for (FirstOreInfos info : oreInformation) {
            ItemStack oreStack = Utils.getOreStack((String)"oreChunk", (IOreEntry)info.entry, (int)1);
            OreDictionary.registerOre((String)(this.processingUnit + info.entry.getOreName()), (ItemStack)oreStack);
            if (info.entry.getOreName().equals("Aluminum")) {
                OreDictionary.registerOre((String)(this.processingUnit + "Aluminium"), (ItemStack)oreStack);
                OreDictionary.registerOre((String)"oreChunkAluminium", (ItemStack)oreStack);
            }
            if (!info.entry.getOreName().equals("Aluminium")) continue;
            OreDictionary.registerOre((String)(this.processingUnit + "Aluminum"), (ItemStack)oreStack);
            OreDictionary.registerOre((String)"oreChunkAluminum", (ItemStack)oreStack);
        }
    }

    public void init() {
        for (FirstOreInfos info : oreInformation) {
            ItemStack oreStack = Utils.getOreStack((String)"oreChunk", (IOreEntry)info.entry, (int)1);
            GameRegistry.addSmelting((ItemStack)oreStack, (ItemStack)Utils.getOreStack((String)"ingot", (IOreEntry)info.entry, (int)1), (float)1.0f);
            OreInfos infos = new OreInfos(oreStack.func_77973_b(), info.count, info.minXP, info.maxXP);
            dropMap.put("ore" + info.entry.getOreName(), infos);
            if (info.entry.getOreName().equals("Aluminum")) {
                dropMap.put("oreAluminium", infos);
            }
            if (!info.entry.getOreName().equals("Aluminium")) continue;
            dropMap.put("oreAluminum", infos);
        }
    }

    public class OreInfos {
        public Item chunkItem;
        public int count;
        public int minXP;
        public int maxXP;

        public OreInfos(Item oreChunkItem, int baseCount, int dropXPMin, int dropXPMax) {
            this.chunkItem = oreChunkItem;
            this.count = baseCount;
            this.minXP = dropXPMin;
            this.maxXP = dropXPMax;
        }
    }

    public class FirstOreInfos {
        public IOreEntry entry;
        public String stoneType;
        public int count;
        public int minXP;
        public int maxXP;

        public FirstOreInfos(IOreEntry oreEntry, String stone, int baseCount, int dropXPMin, int dropXPMax) {
            this.entry = oreEntry;
            this.stoneType = stone;
            this.count = baseCount;
            this.minXP = dropXPMin;
            this.maxXP = dropXPMax;
        }
    }
}

