/*
 * Decompiled with CFR 0.152.
 */
package com.gendeathrow.hatchery.storage;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.EnumFacing;

public class SidedInterface {
    protected ArrayList<InterfaceType> allinterfaceTypes = new ArrayList();
    protected ArrayList<InterfaceOption> allinterfaceOptions = new ArrayList();
    public HashMap<EnumFacing, InterfaceOption> powerInterface = new HashMap<EnumFacing, InterfaceOption>(){
        private static final long serialVersionUID = 1L;
        {
            for (EnumFacing facing : EnumFacing.field_82609_l) {
                this.put(facing, InterfaceOption.None);
            }
        }
    };
    public HashMap<EnumFacing, InterfaceOption> itemInterface = new HashMap<EnumFacing, InterfaceOption>(){
        private static final long serialVersionUID = 1L;
        {
            for (EnumFacing facing : EnumFacing.field_82609_l) {
                this.put(facing, InterfaceOption.None);
            }
        }
    };
    public HashMap<EnumFacing, InterfaceOption> fluidInterface = new HashMap<EnumFacing, InterfaceOption>(){
        private static final long serialVersionUID = 1L;
        {
            for (EnumFacing facing : EnumFacing.field_82609_l) {
                this.put(facing, InterfaceOption.None);
            }
        }
    };

    public SidedInterface(InterfaceOption ... iotypes) {
        this.allinterfaceOptions.addAll(Arrays.asList(iotypes));
        for (InterfaceOption option : iotypes) {
            InterfaceType type = this.getTypeFromOption(option);
            if (this.allinterfaceTypes.contains((Object)type)) continue;
            this.allinterfaceTypes.add(type);
        }
    }

    public boolean hasInterface(InterfaceType interfacetype) {
        return this.allinterfaceTypes.contains((Object)interfacetype);
    }

    public boolean hasInterfaceType(InterfaceType type) {
        return this.allinterfaceTypes.contains((Object)type);
    }

    public HashMap<EnumFacing, InterfaceOption> getListforType(InterfaceType type) {
        switch (type) {
            case Power: {
                return this.powerInterface;
            }
            case Fluid: {
                return this.fluidInterface;
            }
            case Item: {
                return this.itemInterface;
            }
        }
        return null;
    }

    public HashMap<EnumFacing, InterfaceOption> getListFromOption(InterfaceOption option) {
        switch (option) {
            case PowerInput: 
            case PowerOutput: {
                return this.powerInterface;
            }
            case FluidInput: 
            case FluidOutput: {
                return this.fluidInterface;
            }
            case ItemInput: 
            case ItemOutput: {
                return this.itemInterface;
            }
        }
        return null;
    }

    public InterfaceType getTypeFromOption(InterfaceOption option) {
        switch (option) {
            case PowerInput: 
            case PowerOutput: {
                return InterfaceType.Power;
            }
            case FluidInput: 
            case FluidOutput: {
                return InterfaceType.Fluid;
            }
            case ItemInput: 
            case ItemOutput: {
                return InterfaceType.Item;
            }
        }
        return null;
    }

    public InterfaceOption getInterfaceOnFacing(EnumFacing facing, InterfaceType type) {
        return this.getListforType(type).get(facing);
    }

    public boolean setInterfaceOnFacing(InterfaceOption option, EnumFacing ... facings) {
        if (!this.allinterfaceOptions.contains((Object)option)) {
            System.out.println("failed");
            return false;
        }
        for (EnumFacing face : facings) {
            this.getListFromOption(option).put(face, option);
        }
        return true;
    }

    public boolean tryToggleInterface(EnumFacing facing, InterfaceType type) {
        if (!this.allinterfaceTypes.contains((Object)type)) {
            return false;
        }
        if (type == InterfaceType.Power) {
            if (this.getInterfaceOnFacing(facing, type) == InterfaceOption.PowerInput) {
                this.setInterfaceOnFacing(InterfaceOption.PowerOutput, facing);
            } else {
                this.setInterfaceOnFacing(InterfaceOption.PowerInput, facing);
            }
        } else if (type == InterfaceType.Fluid) {
            if (this.getInterfaceOnFacing(facing, type) == InterfaceOption.FluidInput) {
                this.setInterfaceOnFacing(InterfaceOption.FluidOutput, facing);
            } else {
                this.setInterfaceOnFacing(InterfaceOption.FluidInput, facing);
            }
        } else if (type == InterfaceType.Item) {
            if (this.getInterfaceOnFacing(facing, type) == InterfaceOption.ItemInput) {
                this.setInterfaceOnFacing(InterfaceOption.ItemOutput, facing);
            } else {
                this.setInterfaceOnFacing(InterfaceOption.ItemInput, facing);
            }
        }
        return true;
    }

    public void readFromNBT(NBTTagCompound nbt) {
        for (InterfaceType type : InterfaceType.values()) {
            if (!nbt.func_74764_b(type.name())) continue;
            this.readSideInterfaceList(nbt.func_150295_c(type.name(), 9), type);
        }
    }

    private void readSideInterfaceList(NBTTagList listInterfaces, InterfaceType type) {
        for (NBTBase next : listInterfaces) {
            EnumFacing facing = EnumFacing.func_82600_a((int)((NBTTagCompound)next).func_74762_e("facing"));
            InterfaceOption sideOption = InterfaceOption.valueOf(((NBTTagCompound)next).func_74779_i("interfaceOption"));
            if (facing == null || sideOption == null) continue;
            this.getListforType(type).put(facing, sideOption);
        }
    }

    public NBTTagCompound writeToNBT(NBTTagCompound nbt) {
        for (InterfaceType type : InterfaceType.values()) {
            if (!this.hasInterfaceType(type)) continue;
            nbt.func_74782_a(type.name(), (NBTBase)this.writeListType(type));
        }
        return nbt;
    }

    private NBTTagList writeListType(InterfaceType type) {
        NBTTagList sideOptions = new NBTTagList();
        for (Map.Entry<EnumFacing, InterfaceOption> side : this.getListforType(type).entrySet()) {
            NBTTagCompound data = new NBTTagCompound();
            data.func_74768_a("facing", side.getKey().func_176745_a());
            data.func_74778_a("interfaceOption", side.getValue().name());
            sideOptions.func_74742_a((NBTBase)data);
        }
        return sideOptions;
    }

    public static enum InterfaceOption {
        None,
        PowerInput,
        PowerOutput,
        ItemInput,
        ItemOutput,
        FluidInput,
        FluidOutput;

    }

    public static enum InterfaceType {
        Power,
        Fluid,
        Item;

    }
}

