/*
 * Decompiled with CFR 0.152.
 */
package com.gendeathrow.hatchery.block.nestpen;

import com.gendeathrow.hatchery.Hatchery;
import com.gendeathrow.hatchery.block.nestpen.NestPenTileEntity;
import com.gendeathrow.hatchery.core.init.ModBlocks;
import com.gendeathrow.hatchery.core.theoneprobe.TOPInfoProvider;
import com.gendeathrow.hatchery.modaddons.ChickensHelper;
import com.gendeathrow.hatchery.storage.InventoryStroageModifiable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import mcjty.theoneprobe.api.IProbeHitData;
import mcjty.theoneprobe.api.IProbeInfo;
import mcjty.theoneprobe.api.ProbeMode;
import net.minecraft.block.Block;
import net.minecraft.block.BlockHorizontal;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.entity.passive.EntityChicken;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemMonsterPlacer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.Mirror;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class NestingPenBlock
extends Block
implements ITileEntityProvider,
TOPInfoProvider {
    public static final PropertyDirection FACING = BlockHorizontal.field_185512_D;
    public static final PropertyBool HASCHICKEN = PropertyBool.func_177716_a((String)"haschicken");
    protected static final AxisAlignedBB AABB = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 1.2, 1.0);
    protected static final AxisAlignedBB NORTH_STAIRS_AABB = new AxisAlignedBB(0.25, 0.0, 0.0, 0.6875, 0.125, 0.1875);
    protected static final AxisAlignedBB NORTH_BASE_AABB = new AxisAlignedBB(0.125, 0.0, 0.25, 0.9375, 0.125, 1.0);
    protected static final AxisAlignedBB NORTH_SOUTH_WALL_AABB = new AxisAlignedBB(0.125, 0.1875, 0.9375, 0.9375, 1.6, 1.0);
    protected static final AxisAlignedBB NORTH_WALL_AABB = new AxisAlignedBB(0.0625, 0.1875, 0.25, 0.125, 1.6, 1.0);
    protected static final AxisAlignedBB NORTH_WEST_WALL_AABB = new AxisAlignedBB(0.0625, 0.1875, 0.25, 0.125, 1.6, 1.0);
    protected static final AxisAlignedBB NORTH_EAST_WALL_AABB = new AxisAlignedBB(0.8125, 0.1875, 0.25, 0.9375, 1.6, 1.0);
    protected static final AxisAlignedBB[] NORTH_FACING_AABB = new AxisAlignedBB[]{NORTH_STAIRS_AABB, NORTH_BASE_AABB, NORTH_SOUTH_WALL_AABB, NORTH_WEST_WALL_AABB, NORTH_EAST_WALL_AABB};
    protected static final AxisAlignedBB[] BOUNDING_BOXES = new AxisAlignedBB[]{AABB};
    protected String name = "pen";
    private static boolean keepInventory = false;

    public NestingPenBlock() {
        super(Material.field_151575_d);
        this.func_149663_c("pen");
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.NORTH).func_177226_a((IProperty)HASCHICKEN, (Comparable)Boolean.valueOf(false)));
        this.func_149711_c(2.0f);
        this.setHarvestLevel("axe", 0);
    }

    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (worldIn.field_72995_K) {
            return true;
        }
        TileEntity tile = worldIn.func_175625_s(pos);
        if (tile == null || !(tile instanceof NestPenTileEntity)) {
            return false;
        }
        NestPenTileEntity te = (NestPenTileEntity)tile;
        ItemStack heldItem = playerIn.func_184586_b(hand);
        if (!heldItem.func_190926_b()) {
            if (heldItem.func_77973_b() == Items.field_151063_bx) {
                ResourceLocation entityID = ItemMonsterPlacer.func_190908_h((ItemStack)heldItem);
                Entity entity = EntityList.func_188429_b((ResourceLocation)entityID, (World)worldIn);
                if (entity instanceof EntityChicken) {
                    EntityLiving entityliving = (EntityLiving)entity;
                    entity.func_70012_b((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), MathHelper.func_76142_g((float)(worldIn.field_73012_v.nextFloat() * 360.0f)), 0.0f);
                    entityliving.field_70759_as = entityliving.field_70177_z;
                    entityliving.field_70761_aq = entityliving.field_70177_z;
                    entityliving.func_180482_a(worldIn.func_175649_E(new BlockPos((Entity)entityliving)), (IEntityLivingData)null);
                    if (!playerIn.field_71075_bZ.field_75098_d) {
                        heldItem.func_190918_g(1);
                    }
                    te.trySetEntity((Entity)entityliving);
                    return true;
                }
            } else if (ChickensHelper.isLoaded() && heldItem.func_77973_b() == ChickensHelper.chickenAnalyzer) {
                if (ChickensHelper.checkForAnalyzer(heldItem, (Entity)te.storedEntity())) {
                    return true;
                }
            } else if (ChickensHelper.isLoaded() && heldItem.func_77973_b() == ChickensHelper.spawnEgg) {
                EntityLiving chicken = ChickensHelper.getChickenFromEgg(heldItem, worldIn, pos);
                if (chicken == null) {
                    return false;
                }
                if (!playerIn.field_71075_bZ.field_75098_d) {
                    heldItem.func_190918_g(1);
                }
                te.trySetEntity((Entity)chicken);
                return true;
            }
        }
        if (playerIn.func_70093_af()) {
            te.grabItems(playerIn);
        } else {
            playerIn.openGui((Object)Hatchery.INSTANCE, 4, worldIn, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
        }
        te.func_70296_d();
        return true;
    }

    public void func_180663_b(World worldIn, BlockPos pos, IBlockState state) {
        if (!keepInventory) {
            NestPenTileEntity te = (NestPenTileEntity)worldIn.func_175625_s(pos);
            te.dropContents();
            if (te.storedEntity() != null) {
                te.storedEntity().func_70107_b((double)te.func_174877_v().func_177958_n() + 0.5, (double)te.func_174877_v().func_177956_o(), (double)te.func_174877_v().func_177952_p() + 0.5);
                te.storedEntity().captureDrops = false;
                worldIn.func_72838_d((Entity)te.storedEntity());
                te.storedEntity().func_94061_f(false);
            }
        }
        super.func_180663_b(worldIn, pos, state);
    }

    @Nullable
    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        return Item.func_150898_a((Block)ModBlocks.pen);
    }

    public IBlockState getStateForPlacement(World world, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer, EnumHand hand) {
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)placer.func_174811_aO().func_176734_d()).func_177226_a((IProperty)HASCHICKEN, (Comparable)Boolean.valueOf(false));
    }

    public void func_180633_a(World worldIn, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        worldIn.func_180501_a(pos, state.func_177226_a((IProperty)FACING, (Comparable)placer.func_174811_aO().func_176734_d()).func_177226_a((IProperty)HASCHICKEN, (Comparable)Boolean.valueOf(false)), 2);
    }

    public static void setState(boolean hasChicken, World worldIn, BlockPos pos) {
        IBlockState iblockstate = worldIn.func_180495_p(pos);
        worldIn.func_175656_a(pos, ModBlocks.pen.func_176223_P().func_177226_a((IProperty)FACING, iblockstate.func_177229_b((IProperty)FACING)).func_177226_a((IProperty)HASCHICKEN, (Comparable)Boolean.valueOf(hasChicken)));
        if (!worldIn.field_72995_K) {
            worldIn.markAndNotifyBlock(pos, worldIn.func_175726_f(pos), iblockstate, worldIn.func_180495_p(pos), 2);
        }
    }

    public static EntityAnimal getNearByMate(World world, IBlockState state, BlockPos pos) {
        TileEntity tileentity = world.func_175625_s(pos);
        if (!(tileentity instanceof NestPenTileEntity)) {
            return null;
        }
        NestPenTileEntity pen = (NestPenTileEntity)tileentity;
        for (EnumFacing enumfacing : EnumFacing.Plane.HORIZONTAL) {
            NestPenTileEntity penMate;
            EntityAnimal targetmate;
            TileEntity tileentity1;
            BlockPos blockpos;
            Block block;
            if (enumfacing == EnumFacing.UP || enumfacing == EnumFacing.DOWN || !((block = world.func_180495_p(blockpos = pos.func_177972_a(enumfacing)).func_177230_c()) instanceof NestingPenBlock) || !((tileentity1 = world.func_175625_s(blockpos)) instanceof NestPenTileEntity) || (targetmate = (EntityAnimal)(penMate = (NestPenTileEntity)tileentity1).storedEntity()) == null || pen.storedEntity() == null || pen.storedEntity().getClass() != targetmate.getClass()) continue;
            return (EntityAnimal)((NestPenTileEntity)tileentity1).storedEntity();
        }
        return null;
    }

    public boolean func_149740_M(IBlockState state) {
        return true;
    }

    public int func_180641_l(IBlockState blockState, World worldIn, BlockPos pos) {
        TileEntity tileentity = worldIn.func_175625_s(pos);
        if (!(tileentity instanceof NestPenTileEntity)) {
            return 0;
        }
        NestPenTileEntity pen = (NestPenTileEntity)tileentity;
        return InventoryStroageModifiable.calcRedstoneFromInventory(pen.inventory);
    }

    private boolean isFeederNear() {
        return false;
    }

    private void setDefaultFacing(World worldIn, BlockPos pos, IBlockState state) {
        if (!worldIn.field_72995_K) {
            IBlockState iblockstate = worldIn.func_180495_p(pos.func_177978_c());
            IBlockState iblockstate1 = worldIn.func_180495_p(pos.func_177968_d());
            IBlockState iblockstate2 = worldIn.func_180495_p(pos.func_177976_e());
            IBlockState iblockstate3 = worldIn.func_180495_p(pos.func_177974_f());
            EnumFacing enumfacing = (EnumFacing)state.func_177229_b((IProperty)FACING);
            if (enumfacing == EnumFacing.NORTH && iblockstate.func_185913_b() && !iblockstate1.func_185913_b()) {
                enumfacing = EnumFacing.SOUTH;
            } else if (enumfacing == EnumFacing.SOUTH && iblockstate1.func_185913_b() && !iblockstate.func_185913_b()) {
                enumfacing = EnumFacing.NORTH;
            } else if (enumfacing == EnumFacing.WEST && iblockstate2.func_185913_b() && !iblockstate3.func_185913_b()) {
                enumfacing = EnumFacing.EAST;
            } else if (enumfacing == EnumFacing.EAST && iblockstate3.func_185913_b() && !iblockstate2.func_185913_b()) {
                enumfacing = EnumFacing.WEST;
            }
            worldIn.func_180501_a(pos, state.func_177226_a((IProperty)FACING, (Comparable)enumfacing).func_177226_a((IProperty)HASCHICKEN, state.func_177229_b((IProperty)HASCHICKEN)), 2);
        }
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149730_j(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean isFullyOpaque(IBlockState state) {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer getBlockLayer() {
        return BlockRenderLayer.CUTOUT_MIPPED;
    }

    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.MODEL;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_176225_a(IBlockState blockState, IBlockAccess blockAccess, BlockPos pos, EnumFacing side) {
        return true;
    }

    public TileEntity func_149915_a(World worldIn, int meta) {
        return new NestPenTileEntity();
    }

    public static EnumFacing getFacing(IBlockState blockStateContainer) {
        return (EnumFacing)blockStateContainer.func_177229_b((IProperty)FACING);
    }

    public void func_185477_a(IBlockState state, World worldIn, BlockPos pos, AxisAlignedBB entityBox, List<AxisAlignedBB> collidingBoxes, @Nullable Entity entityIn, boolean something) {
        NestingPenBlock.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)AABB);
    }

    @Nullable
    public AxisAlignedBB func_180646_a(IBlockState blockState, IBlockAccess worldIn, BlockPos pos) {
        return field_185506_k;
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return BOUNDING_BOXES[0];
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.func_176731_b((int)meta)).func_177226_a((IProperty)HASCHICKEN, (Comparable)Boolean.valueOf(meta >> 2 == 1));
    }

    public int func_176201_c(IBlockState state) {
        int i = 0;
        i |= ((EnumFacing)state.func_177229_b((IProperty)FACING)).func_176736_b();
        return i |= ((Boolean)state.func_177229_b((IProperty)HASCHICKEN) != false ? 1 : 0) << 2;
    }

    public IBlockState func_185499_a(IBlockState state, Rotation rot) {
        return state.func_177226_a((IProperty)FACING, (Comparable)rot.func_185831_a((EnumFacing)state.func_177229_b((IProperty)FACING)));
    }

    public IBlockState func_185471_a(IBlockState state, Mirror mirrorIn) {
        return state.func_185907_a(mirrorIn.func_185800_a((EnumFacing)state.func_177229_b((IProperty)FACING)));
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{FACING, HASCHICKEN});
    }

    public boolean canPlaceTorchOnTop(IBlockState state, IBlockAccess world, BlockPos pos) {
        return false;
    }

    @Override
    public void addProbeInfo(ProbeMode mode, IProbeInfo probeInfo, EntityPlayer player, World world, IBlockState blockState, IProbeHitData data) {
        TileEntity te = world.func_175625_s(data.getPos());
        if (te instanceof NestPenTileEntity) {
            NestPenTileEntity tileEntity = (NestPenTileEntity)te;
            if (tileEntity.storedEntity() != null) {
                HashMap<String, Integer> stats;
                long uptime = tileEntity.getTimeToNextDrop() / 20;
                long minutes = TimeUnit.SECONDS.toMinutes(uptime);
                long seconds = TimeUnit.SECONDS.toSeconds(uptime -= TimeUnit.MINUTES.toSeconds(minutes));
                String output = minutes > 0L ? minutes + ":" + (seconds < 10L ? "0" + seconds : Long.valueOf(seconds)) + " mins" : (seconds < 10L ? "0" + seconds : Long.valueOf(seconds)) + " secs";
                probeInfo.text(TextFormatting.YELLOW + "Chicken: " + TextFormatting.GREEN + tileEntity.storedEntity().func_70005_c_());
                if (ChickensHelper.isLoaded() && (stats = ChickensHelper.getChickenStats((Entity)tileEntity.storedEntity())) != null) {
                    String growth = "~";
                    String gain = "~";
                    String str = "~";
                    for (Map.Entry<String, Integer> stat : stats.entrySet()) {
                        if (stat.getKey() == "entity.ChickensChicken.growth") {
                            growth = "Growth: " + stat.getValue();
                        }
                        if (stat.getKey() == "entity.ChickensChicken.gain") {
                            gain = "Gain: " + stat.getValue();
                        }
                        if (stat.getKey() != "entity.ChickensChicken.strength") continue;
                        str = "Strength: " + stat.getValue();
                    }
                    probeInfo.text(growth);
                    probeInfo.text(gain);
                    probeInfo.text(str);
                }
                probeInfo.text(TextFormatting.YELLOW + "Next Drop: " + TextFormatting.GREEN + output);
            } else {
                probeInfo.text(TextFormatting.RED + "Use 'Animal Net' to capture a chicken");
            }
        }
    }
}

