/*
 * Decompiled with CFR 0.152.
 */
package com.gendeathrow.hatchery.block.generator;

import com.gendeathrow.hatchery.block.BasicHatcheryContainer;
import com.gendeathrow.hatchery.block.generator.DigesterGeneratorTileEntity;
import com.gendeathrow.hatchery.core.init.ModFluids;
import com.gendeathrow.hatchery.inventory.SlotFluidContainer;
import com.gendeathrow.hatchery.network.HatcheryWindowPacket;
import com.gendeathrow.hatchery.storage.InventoryStroageModifiable;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IContainerListener;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.SlotItemHandler;

public class ContainerDigesterGenerator
extends BasicHatcheryContainer {
    private final DigesterGeneratorTileEntity tile;
    private final InventoryStroageModifiable inputInventory;
    private final InventoryStroageModifiable outputInventory;
    private final InventoryStroageModifiable upgrades;

    public ContainerDigesterGenerator(InventoryPlayer playerInventory, DigesterGeneratorTileEntity tileEntity) {
        this.inputInventory = tileEntity.inputInventory;
        this.outputInventory = tileEntity.outputInventory;
        this.tile = tileEntity;
        this.upgrades = tileEntity.getUpgradeStorage();
        this.func_75146_a((Slot)new SlotFluidContainer((IItemHandler)this.inputInventory, 0, 72, 16, ModFluids.liquidfertilizer));
        this.func_75146_a((Slot)new SlotItemHandler((IItemHandler)this.upgrades, 0, 107, 59){

            public boolean func_75214_a(@Nullable ItemStack stack) {
                boolean value = super.func_75214_a(stack);
                if (value) {
                    value = ContainerDigesterGenerator.this.tile.canUseUpgrade(stack);
                }
                return value;
            }
        });
        this.func_75146_a((Slot)new SlotItemHandler((IItemHandler)this.upgrades, 1, 134, 59){

            public boolean func_75214_a(@Nullable ItemStack stack) {
                boolean value = super.func_75214_a(stack);
                if (value) {
                    value = ContainerDigesterGenerator.this.tile.canUseUpgrade(stack);
                }
                return value;
            }
        });
        this.addInventories(new IItemHandler[]{this.inputInventory, this.upgrades, this.outputInventory});
        this.func_75146_a((Slot)new SlotItemHandler((IItemHandler)this.outputInventory, 0, 72, 52){

            public boolean func_75214_a(@Nullable ItemStack stack) {
                return false;
            }
        });
        this.bindPlayerInventory(playerInventory);
    }

    @Override
    public boolean func_75145_c(EntityPlayer playerIn) {
        return true;
    }

    public void func_75132_a(IContainerListener listener) {
        if (this.field_75149_d.contains(listener)) {
            throw new IllegalArgumentException("Listener already listening");
        }
        this.field_75149_d.add(listener);
        listener.func_71110_a((Container)this, this.func_75138_a());
        this.func_75142_b();
    }

    public void func_75130_a(IInventory inv) {
        this.func_75142_b();
    }

    @SideOnly(value=Side.CLIENT)
    public void func_75137_b(int id, int value) {
        this.tile.setField(id, value);
    }

    public void func_75142_b() {
        super.func_75142_b();
        for (IContainerListener listener : this.field_75149_d) {
            listener.func_71112_a((Container)this, 4, this.tile.getField(4));
            listener.func_71112_a((Container)this, 1, this.tile.getField(1));
            listener.func_71112_a((Container)this, 2, this.tile.getField(2));
            HatcheryWindowPacket.sendProgressBarUpdate(listener, this, 3, this.tile.getField(3));
            HatcheryWindowPacket.sendProgressBarUpdate(listener, this, 0, this.tile.getField(0));
        }
    }
}

