/*
 * Decompiled with CFR 0.152.
 */
package com.gendeathrow.hatchery.block.energy.cable;

import com.gendeathrow.hatchery.core.init.ModBlocks;
import net.minecraft.block.state.IBlockState;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;

public class ExtensionCableTileEntity
extends TileEntity {
    public ExtensionCableTileEntity linkedCable = null;
    public EnumFacing facing = EnumFacing.NORTH;

    public void addLikedCable(ExtensionCableTileEntity cable) {
        this.linkedCable = cable;
        IBlockState iblockstate = this.field_145850_b.func_180495_p(this.field_174879_c);
        this.field_145850_b.func_175656_a(this.field_174879_c, ModBlocks.extensionCable.func_176223_P());
        if (!this.field_145850_b.field_72995_K) {
            this.field_145850_b.markAndNotifyBlock(this.field_174879_c, this.field_145850_b.func_175726_f(this.field_174879_c), iblockstate, this.field_145850_b.func_180495_p(this.field_174879_c), 2);
        }
        this.func_70296_d();
    }

    public boolean hasLinkedCableOutput(Capability<?> capability) {
        return false;
    }

    public <T> T getLinkedCableOutput(Capability<T> capability) {
        return null;
    }

    public SPacketUpdateTileEntity func_189518_D_() {
        return new SPacketUpdateTileEntity(this.func_174877_v(), this.func_145832_p(), this.func_189517_E_());
    }

    public NBTTagCompound func_189517_E_() {
        return this.func_189515_b(new NBTTagCompound());
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        this.func_145839_a(pkt.func_148857_g());
    }

    public void func_145839_a(NBTTagCompound nbt) {
        if (nbt.func_74764_b("linked")) {
            int[] linkedpos = nbt.func_74759_k("linked");
            this.linkedCable = (ExtensionCableTileEntity)this.field_145850_b.func_175625_s(new BlockPos(linkedpos[0], linkedpos[1], linkedpos[2]));
        }
        super.func_145839_a(nbt);
    }

    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        if (this.linkedCable != null) {
            nbt.func_74783_a("linked", new int[]{this.linkedCable.field_174879_c.func_177958_n(), this.linkedCable.field_174879_c.func_177956_o(), this.linkedCable.field_174879_c.func_177952_p()});
        }
        return super.func_189515_b(nbt);
    }

    public void setFacing(EnumFacing facingIn) {
        this.facing = facingIn;
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        return capability == CapabilityEnergy.ENERGY && this.linkedCable != null || super.hasCapability(capability, facing);
    }

    public int receiveEnergy(EnumFacing from, int maxReceive, boolean simulate) {
        int returnVal = 0;
        TileEntity te = this.field_145850_b.func_175625_s(this.func_174877_v().func_177972_a(this.facing));
        if (te.hasCapability(CapabilityEnergy.ENERGY, this.facing.func_176734_d())) {
            returnVal = ((IEnergyStorage)te.getCapability(CapabilityEnergy.ENERGY, this.facing.func_176734_d())).receiveEnergy(maxReceive, simulate);
        }
        return returnVal;
    }

    public int extractEnergy(EnumFacing from, int maxReceive, boolean simulate) {
        int returnVal = 0;
        TileEntity te = this.field_145850_b.func_175625_s(this.func_174877_v().func_177972_a(this.facing));
        if (te.hasCapability(CapabilityEnergy.ENERGY, this.facing.func_176734_d())) {
            maxReceive -= ((IEnergyStorage)te.getCapability(CapabilityEnergy.ENERGY, this.facing.func_176734_d())).receiveEnergy(maxReceive, simulate);
            returnVal = maxReceive;
        }
        return returnVal;
    }

    public int getEnergyStored(EnumFacing from) {
        TileEntity te = this.field_145850_b.func_175625_s(this.func_174877_v().func_177972_a(this.facing));
        if (te.hasCapability(CapabilityEnergy.ENERGY, this.facing.func_176734_d())) {
            return ((IEnergyStorage)te.getCapability(CapabilityEnergy.ENERGY, this.facing.func_176734_d())).getEnergyStored();
        }
        return 0;
    }

    public int getMaxEnergyStored(EnumFacing from) {
        TileEntity te = this.field_145850_b.func_175625_s(this.func_174877_v().func_177972_a(this.facing));
        if (te.hasCapability(CapabilityEnergy.ENERGY, this.facing.func_176734_d())) {
            return ((IEnergyStorage)te.getCapability(CapabilityEnergy.ENERGY, this.facing.func_176734_d())).getMaxEnergyStored();
        }
        return 0;
    }

    public <T> T getCapability(Capability<T> capability, final EnumFacing from) {
        if (capability == CapabilityEnergy.ENERGY && this.linkedCable != null) {
            return (T)CapabilityEnergy.ENERGY.cast((Object)new IEnergyStorage(){

                public int receiveEnergy(int maxReceive, boolean simulate) {
                    return ExtensionCableTileEntity.this.linkedCable.receiveEnergy(from, maxReceive, simulate);
                }

                public int extractEnergy(int maxExtract, boolean simulate) {
                    return ExtensionCableTileEntity.this.linkedCable.extractEnergy(from, maxExtract, simulate);
                }

                public int getEnergyStored() {
                    return ExtensionCableTileEntity.this.linkedCable.getEnergyStored(from);
                }

                public int getMaxEnergyStored() {
                    return ExtensionCableTileEntity.this.linkedCable.getMaxEnergyStored(from);
                }

                public boolean canExtract() {
                    return true;
                }

                public boolean canReceive() {
                    return true;
                }
            });
        }
        return (T)super.getCapability(capability, from);
    }
}

