/*
 * Decompiled with CFR 0.152.
 */
package com.valkyrieofnight.sg.m_generators.tile;

import com.valkyrieofnight.sg.m_generators.gui.GuiGenBaseFluid;
import com.valkyrieofnight.sg.m_generators.inventory.ContainerGenBase;
import com.valkyrieofnight.sg.m_generators.tile.TileGenBase;
import com.valkyrieofnight.vlib.core.item.util.ItemStackUtil;
import com.valkyrieofnight.vlib.core.util.fluid.FluidUtil;
import com.valkyrieofnight.vliblegacy.lib.inventory.VLContainer;
import com.valkyrieofnight.vliblegacy.lib.inventory.VLItemHandlerLimited;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;

public abstract class TileGenBaseFluid
extends TileGenBase {
    protected FluidTank tank;
    protected VLItemHandlerLimited buffer;
    int tickFill = 0;

    public FluidTank getTank() {
        return this.tank;
    }

    public TileGenBaseFluid(int capacity, int upgradeSlots, int fluidTank) {
        super(capacity, upgradeSlots, true);
        this.tank = new FluidTank(fluidTank){

            public boolean canFillFluidType(FluidStack fluid) {
                return TileGenBaseFluid.this.isValidFluid(fluid);
            }
        };
        this.buffer = new VLItemHandlerLimited(){

            public boolean isValidInput(ItemStack stack) {
                return true;
            }
        };
    }

    @Override
    public NBTTagCompound saveTileData(NBTTagCompound nbt, boolean toItem) {
        super.saveTileData(nbt, toItem);
        this.tank.writeToNBT(nbt);
        nbt.func_74782_a("ibuffer", (NBTBase)this.buffer.serializeNBT());
        return nbt;
    }

    @Override
    public void loadTileData(NBTTagCompound nbt, boolean fromItem) {
        super.loadTileData(nbt, fromItem);
        this.tank.readFromNBT(nbt);
        this.buffer.deserializeNBT(nbt.func_74775_l("ibuffer"));
    }

    @Override
    public void writeClientDataToNBT(NBTTagCompound nbt) {
        super.writeClientDataToNBT(nbt);
        this.tank.writeToNBT(nbt);
    }

    @Override
    public void readClientDataFromNBT(NBTTagCompound nbt) {
        super.readClientDataFromNBT(nbt);
        this.tank.readFromNBT(nbt);
    }

    @Override
    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return true;
        }
        return super.hasCapability(capability, facing);
    }

    @Override
    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return (T)this.tank;
        }
        return super.getCapability(capability, facing);
    }

    protected abstract int getDurationForTocks(int var1, FluidStack var2);

    protected abstract int getRFTotal(int var1, FluidStack var2);

    protected abstract boolean isValidFluid(FluidStack var1);

    @Override
    public void updateTile() {
        super.updateTile();
        if (!this.field_145850_b.field_72995_K) {
            ++this.tickFill;
            if (this.tickFill == 10) {
                this.tickFill = 0;
                if (this.buffer.getStackInSlot(0) == ItemStack.field_190927_a && this.tank.getFluidAmount() < this.tank.getCapacity() - 999) {
                    ItemStack single = this.input.getStackInSlot(0).func_77946_l();
                    single.func_190920_e(1);
                    if (ItemStackUtil.transferStack((IItemHandler)this.buffer, (ItemStack)single, (boolean)false) == ItemStack.field_190927_a) {
                        this.input.extractItem(0, single.func_190916_E(), false);
                    }
                }
                if (this.isValidInputStack(this.buffer.getStackInSlot(0))) {
                    ItemStack stack = FluidUtil.transferFluidFromItem((IFluidHandler)this.tank, (ItemStack)this.buffer.getStackInSlot(0), (FluidUtil.IValidFluid)new FluidUtil.IValidFluid(){

                        public boolean checkValidFluid(FluidStack fluid) {
                            return TileGenBaseFluid.this.isValidFluid(fluid);
                        }
                    });
                    if (FluidUtil.isBucket((ItemStack)stack)) {
                        this.buffer.setStackInSlot(0, stack);
                    }
                    this.buffer.setStackInSlot(0, this.output.iInsert(0, this.buffer.getStackInSlot(0), false));
                } else {
                    this.buffer.setStackInSlot(0, this.output.iInsert(0, this.buffer.getStackInSlot(0), false));
                }
            }
        }
    }

    public boolean emptyFluidContainer(EntityPlayer player, EnumHand hand) {
        if (player == null || hand == null) {
            return false;
        }
        if (player.hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null)) {
            IItemHandler ih = (IItemHandler)player.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null);
            ItemStack is = player.func_184586_b(hand);
            if (is == ItemStack.field_190927_a) {
                return false;
            }
            if (!is.hasCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY, null)) {
                return false;
            }
            ItemStack ns = FluidUtil.transferFluidFromItem((IFluidHandler)this.tank, (ItemStack)is, (FluidUtil.IValidFluid)new FluidUtil.IValidFluid(){

                public boolean checkValidFluid(FluidStack fluid) {
                    return TileGenBaseFluid.this.isValidFluid(fluid);
                }
            });
            if (FluidUtil.isBucket((ItemStack)ns)) {
                player.func_184611_a(hand, ns);
            }
            return true;
        }
        return false;
    }

    public boolean checkValidResource() {
        return this.tank.getFluidAmount() > this.duration;
    }

    public void onInitStart() {
        int tocks = this.getTickTocks();
        this.duration = this.getDurationForTocks(tocks, this.tank.getFluid());
        this.rfTotal = this.getRFTotal(this.duration, this.tank.getFluid());
    }

    public void onStart() {
    }

    public void consumeResource() {
        this.tank.drain(this.duration, true);
    }

    @Override
    protected void processTocks(int tocks) {
    }

    protected boolean canEnergyConnect(EnumFacing side) {
        return true;
    }

    @Override
    public Object getClientGuiElement(EntityPlayer player) {
        return new GuiGenBaseFluid(player, (VLContainer)new ContainerGenBase(player.field_71071_by, this), this);
    }
}

