/*
 * Decompiled with CFR 0.152.
 */
package com.ferreusveritas.dynamictreesphc.blocks;

import com.ferreusveritas.dynamictrees.ModConfigs;
import com.ferreusveritas.dynamictrees.blocks.BlockBranchBasic;
import com.ferreusveritas.dynamictrees.entities.EntityFallingTree;
import com.ferreusveritas.dynamictrees.trees.Species;
import com.ferreusveritas.dynamictrees.util.BranchDestructionData;
import com.pam.harvestcraft.blocks.FruitRegistry;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Enchantments;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import net.minecraftforge.event.ForgeEventFactory;

public class BlockBranchPamSpecial
extends BlockBranchBasic {
    private String logName;
    private float dropYield;

    public BlockBranchPamSpecial(String name, String logName, float yieldPerLog) {
        super(name);
        this.logName = logName;
        this.dropYield = yieldPerLog;
    }

    public void futureBreak(IBlockState state, World world, BlockPos cutPos, EntityLivingBase entity) {
        double reachDistance = entity instanceof EntityPlayerMP ? entity.func_110148_a(EntityPlayer.REACH_DISTANCE).func_111126_e() : 5.0;
        RayTraceResult rtResult = this.playerRayTrace(entity, reachDistance, 1.0f);
        EnumFacing toolDir = rtResult != null ? (entity.func_70093_af() ? rtResult.field_178784_b.func_176734_d() : rtResult.field_178784_b) : EnumFacing.DOWN;
        BranchDestructionData destroyData = this.destroyBranchFromNode(world, cutPos, toolDir, false);
        ItemStack heldItem = entity.func_184614_ca();
        int fortune = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185308_t, (ItemStack)heldItem);
        boolean silkTouch = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185306_r, (ItemStack)heldItem) != 0;
        float fortuneFactor = 1.0f + 0.25f * (float)fortune;
        float woodVolume = destroyData.woodVolume;
        List<ItemStack> woodItems = silkTouch ? this.getLogDrops(world, cutPos, destroyData.species, woodVolume * fortuneFactor, true) : this.getLogDrops(world, cutPos, destroyData.species, woodVolume * fortuneFactor, false);
        float chance = 1.0f;
        if (entity instanceof EntityPlayer) {
            chance = ForgeEventFactory.fireBlockHarvesting(woodItems, (World)world, (BlockPos)cutPos, (IBlockState)state, (int)fortune, (float)chance, (boolean)false, (EntityPlayer)((EntityPlayer)entity));
        }
        float finalChance = chance;
        List woodDropList = woodItems.stream().filter(i -> world.field_73012_v.nextFloat() <= finalChance).collect(Collectors.toList());
        EntityFallingTree.dropTree((World)world, (BranchDestructionData)destroyData, woodDropList, (EntityFallingTree.DestroyType)EntityFallingTree.DestroyType.HARVEST);
        this.damageAxe(entity, heldItem, this.getRadius(state), woodVolume);
    }

    protected void sloppyBreak(World world, BlockPos cutPos, EntityFallingTree.DestroyType destroyType) {
        BranchDestructionData destroyData = this.destroyBranchFromNode(world, cutPos, EnumFacing.DOWN, false);
        List<ItemStack> woodDropList = this.getLogDrops(world, cutPos, destroyData.species, destroyData.woodVolume, false);
        EntityFallingTree.dropTree((World)world, (BranchDestructionData)destroyData, woodDropList, (EntityFallingTree.DestroyType)destroyType);
    }

    public List<ItemStack> getLogDrops(World world, BlockPos pos, Species species, float volume, boolean silkTouch) {
        ArrayList<ItemStack> ret = new ArrayList<ItemStack>();
        volume *= ModConfigs.treeHarvestMultiplier;
        if (silkTouch) {
            ItemStack drop = new ItemStack((Block)FruitRegistry.getLog((String)this.logName));
            drop.func_190920_e((int)volume);
            ret.add(drop);
        } else {
            ItemStack drop = new ItemStack(FruitRegistry.getLog((String)this.logName).getFruitItem());
            drop.func_190920_e((int)(volume * this.dropYield));
            ret.add(drop);
        }
        return species.getLogsDrops(world, pos, ret, volume);
    }
}

