/*
 * Decompiled with CFR 0.152.
 */
package CoroUtil.util;

import CoroUtil.config.ConfigCoroUtil;
import CoroUtil.forge.CULog;
import CoroUtil.util.BlockCoord;
import CoroUtil.util.CoroUtilBlock;
import CoroUtil.util.CoroUtilCompatibility;
import java.util.Random;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.pathfinding.Path;
import net.minecraft.pathfinding.PathPoint;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class CoroUtilPath {
    public static Path getSingleNodePath(BlockCoord coords) {
        PathPoint[] points = new PathPoint[]{new PathPoint(coords.posX, coords.posY, coords.posZ)};
        Path pe = new Path(points);
        return pe;
    }

    public static boolean tryMoveToEntityLivingLongDist(EntityLiving entSource, Entity entityTo, double moveSpeedAmp) {
        return CoroUtilPath.tryMoveToXYZLongDist(entSource, entityTo.field_70165_t, entityTo.func_174813_aQ().field_72338_b, entityTo.field_70161_v, moveSpeedAmp);
    }

    public static boolean tryMoveToXYZLongDist(EntityLiving ent, double x, double y, double z, double moveSpeedAmp) {
        boolean success;
        block12: {
            World world = ent.field_70170_p;
            success = false;
            try {
                int tries;
                int gatherZ;
                int gatherY;
                double followDist;
                if (!ent.func_70661_as().func_75500_f()) break block12;
                double distToPlayer = ent.func_70011_f(x, y, z);
                if (distToPlayer <= (followDist = ent.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111126_e())) {
                    success = CoroUtilCompatibility.tryPathToXYZModCompat(ent, MathHelper.func_76128_c((double)x), MathHelper.func_76128_c((double)y), MathHelper.func_76128_c((double)z), moveSpeedAmp);
                    break block12;
                }
                double d = x + 0.5 - ent.field_70165_t;
                double d2 = z + 0.5 - ent.field_70161_v;
                double d1 = y + 0.5 - (ent.field_70163_u + (double)ent.func_70047_e());
                double d3 = MathHelper.func_76133_a((double)(d * d + d2 * d2));
                float f2 = (float)(Math.atan2(d2, d) * 180.0 / 3.1415927410125732) - 90.0f;
                float f3 = (float)(-(Math.atan2(d1, d3) * 180.0 / 3.1415927410125732));
                float rotationPitch = -f3;
                float rotationYaw = f2;
                EntityLiving center = ent;
                Random rand = world.field_73012_v;
                float randLook = rand.nextInt(90) - 45;
                double dist = followDist * 0.75 + (double)rand.nextInt((int)followDist / 2);
                int gatherX = (int)Math.floor(center.field_70165_t + -Math.sin((rotationYaw + randLook) / 180.0f * (float)Math.PI) * dist);
                BlockPos pos = new BlockPos(gatherX, gatherY = (int)center.field_70163_u, gatherZ = (int)Math.floor(center.field_70161_v + Math.cos((rotationYaw + randLook) / 180.0f * (float)Math.PI) * dist));
                if (!world.func_175667_e(pos)) {
                    return false;
                }
                IBlockState state = world.func_180495_p(pos);
                if (!CoroUtilBlock.isAir(state.func_177230_c())) {
                    int offset = -5;
                    for (tries = 0; tries < 30 && !CoroUtilBlock.isAir(state.func_177230_c()) && state.isSideSolid((IBlockAccess)world, pos, EnumFacing.UP); ++tries) {
                        pos = new BlockPos(gatherX, gatherY += offset++, gatherZ);
                        state = world.func_180495_p(pos);
                    }
                } else {
                    while (tries < 30 && (CoroUtilBlock.isAir(state.func_177230_c()) || !state.isSideSolid((IBlockAccess)world, pos, EnumFacing.UP))) {
                        pos = new BlockPos(gatherX, --gatherY, gatherZ);
                        state = world.func_180495_p(pos);
                        ++tries;
                    }
                }
                if (tries < 30) {
                    success = CoroUtilCompatibility.tryPathToXYZModCompat(ent, gatherX, gatherY, gatherZ, moveSpeedAmp);
                } else {
                    if (!world.func_175667_e(pos = world.func_175645_m(pos).func_177977_b())) {
                        return false;
                    }
                    state = world.func_180495_p(pos);
                    if (state.isSideSolid((IBlockAccess)world, pos, EnumFacing.UP)) {
                        success = CoroUtilCompatibility.tryPathToXYZModCompat(ent, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p(), moveSpeedAmp);
                    }
                }
            }
            catch (Exception ex) {
                CULog.err("Exception trying to pathfind");
                if (!ConfigCoroUtil.useLoggingError) break block12;
                ex.printStackTrace();
            }
        }
        return success;
    }
}

