/*
 * Decompiled with CFR 0.152.
 */
package net.malisis.core.client.gui.component.interaction;

import com.google.common.base.Converter;
import com.google.common.base.Preconditions;
import com.mojang.realmsclient.gui.ChatFormatting;
import net.malisis.core.client.gui.GuiRenderer;
import net.malisis.core.client.gui.MalisisGui;
import net.malisis.core.client.gui.component.IGuiText;
import net.malisis.core.client.gui.component.UIComponent;
import net.malisis.core.client.gui.element.GuiShape;
import net.malisis.core.client.gui.element.XYResizableGuiShape;
import net.malisis.core.client.gui.event.ComponentEvent;
import net.malisis.core.renderer.font.FontOptions;
import net.malisis.core.renderer.font.MalisisFont;
import net.malisis.core.renderer.icon.provider.GuiIconProvider;
import net.malisis.core.util.MouseButton;
import net.malisis.core.util.Silenced;
import net.minecraft.util.math.MathHelper;
import org.apache.commons.lang3.StringUtils;

public class UISlider<T>
extends UIComponent<UISlider<T>>
implements IGuiText<UISlider<T>> {
    public static int SLIDER_WIDTH = 8;
    protected GuiIconProvider sliderIcon;
    protected MalisisFont font = MalisisFont.minecraftFont;
    protected FontOptions fontOptions = FontOptions.builder().color(0xFFFFFF).shadow().build();
    protected FontOptions hoveredFontOptions = FontOptions.builder().color(0xFFFFA0).shadow().build();
    protected String text;
    protected T value;
    protected float offset;
    protected float scrollStep = 0.05f;
    protected Converter<Float, T> converter;
    protected GuiShape sliderShape;

    public UISlider(MalisisGui gui, int width, Converter<Float, T> converter, String text) {
        super(gui);
        this.text = text;
        this.converter = (Converter)Preconditions.checkNotNull(converter);
        this.value = converter.convert((Object)Float.valueOf(0.0f));
        this.setSize(width, 20);
        this.shape = new XYResizableGuiShape();
        this.sliderShape = new XYResizableGuiShape(3);
        this.iconProvider = new GuiIconProvider(gui.getGuiTexture().getXYResizableIcon(0, 0, 200, 20, 5));
        this.sliderIcon = new GuiIconProvider(gui.getGuiTexture().getXYResizableIcon(227, 46, 8, 20, 3));
    }

    @Override
    public MalisisFont getFont() {
        return this.font;
    }

    @Override
    public UISlider<T> setFont(MalisisFont font) {
        this.font = font;
        return this;
    }

    @Override
    public FontOptions getFontOptions() {
        return this.fontOptions;
    }

    @Override
    public UISlider<T> setFontOptions(FontOptions fro) {
        this.fontOptions = fro;
        return this;
    }

    public UISlider<T> setValue(T value) {
        if (this.value == value) {
            return this;
        }
        if (!this.fireEvent(new ComponentEvent.ValueChange<UISlider, T>(this, this.value, value))) {
            return this;
        }
        this.value = value;
        this.offset = MathHelper.func_76131_a((float)((Float)this.converter.reverse().convert(value)).floatValue(), (float)0.0f, (float)1.0f);
        return this;
    }

    public T getValue() {
        return this.value;
    }

    public UISlider<T> setScrollStep(float scrollStep) {
        this.scrollStep = scrollStep;
        return this;
    }

    @Override
    public boolean onClick(int x, int y) {
        this.slideTo(x);
        return true;
    }

    @Override
    public boolean onScrollWheel(int x, int y, int delta) {
        this.slideTo(this.offset + (float)delta * this.scrollStep);
        return true;
    }

    @Override
    public boolean onDrag(int lastX, int lastY, int x, int y, MouseButton button) {
        this.slideTo(x);
        return true;
    }

    public void slideTo(int x) {
        int l = this.getWidth() - SLIDER_WIDTH;
        int pos = this.relativeX(x);
        pos = MathHelper.func_76125_a((int)(pos - SLIDER_WIDTH / 2), (int)0, (int)l);
        this.slideTo((float)pos / (float)l);
    }

    public void slideTo(float offset) {
        if (!this.isEnabled()) {
            return;
        }
        this.setValue(this.converter.convert((Object)Float.valueOf(MathHelper.func_76131_a((float)offset, (float)0.0f, (float)1.0f))));
    }

    @Override
    public void drawBackground(GuiRenderer renderer, int mouseX, int mouseY, float partialTick) {
        renderer.drawShape(this.shape, this.rp);
    }

    @Override
    public void drawForeground(GuiRenderer renderer, int mouseX, int mouseY, float partialTick) {
        this.zIndex = 0;
        float factor = (float)this.getHeight() / 20.0f;
        int ox = (int)(this.offset * ((float)this.getWidth() - (float)SLIDER_WIDTH * factor));
        this.sliderShape.resetState();
        this.sliderShape.setSize((int)(8.0f * factor), this.getHeight());
        this.sliderShape.setPosition(ox, 0);
        this.rp.iconProvider.set(this.sliderIcon);
        renderer.drawShape(this.sliderShape, this.rp);
        renderer.next();
        if (!StringUtils.isEmpty((CharSequence)this.text)) {
            String str = Silenced.get(() -> String.format(this.text, this.value));
            if (str == null) {
                str = ChatFormatting.ITALIC + "Format error";
            }
            int x = (int)(((float)this.getWidth() - this.font.getStringWidth(str, this.fontOptions)) / 2.0f);
            int y = (int)Math.ceil(((float)this.getHeight() - this.font.getStringHeight(this.fontOptions)) / 2.0f);
            renderer.drawText(this.font, str, x, y, 0.0f, this.isHovered() ? this.hoveredFontOptions : this.fontOptions);
        }
    }
}

