/*
 * Decompiled with CFR 0.152.
 */
package com.ocelot.vehicle.jei.plugin.fluidmixer;

import com.mrcrayfish.vehicle.init.ModBlocks;
import com.ocelot.vehicle.jei.VehicleModJei;
import com.ocelot.vehicle.jei.plugin.fluidmixer.FluidMixerRecipeWrapper;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mezz.jei.api.IGuiHelper;
import mezz.jei.api.gui.IDrawable;
import mezz.jei.api.gui.IDrawableAnimated;
import mezz.jei.api.gui.IDrawableStatic;
import mezz.jei.api.gui.IGuiFluidStackGroup;
import mezz.jei.api.gui.IGuiItemStackGroup;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.IRecipeCategory;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;

public class FluidMixerCategory
implements IRecipeCategory<FluidMixerRecipeWrapper> {
    private final IDrawableStatic background;
    private final IDrawable icon;
    private final IDrawableAnimated animatedFlame;
    private final IDrawableStatic inputOverlay;
    private final IDrawableStatic outputOverlay;
    private final String localizedName;

    public FluidMixerCategory(IGuiHelper guiHelper) {
        IDrawableStatic staticFlame = guiHelper.createDrawable(VehicleModJei.RECIPE_GUI_VEHICLE, 160, 0, 14, 14);
        this.background = guiHelper.createDrawable(VehicleModJei.RECIPE_GUI_VEHICLE, 0, 0, 160, 66);
        this.icon = guiHelper.createDrawableIngredient((Object)new ItemStack(ModBlocks.FLUID_MIXER));
        this.animatedFlame = guiHelper.createAnimatedDrawable(staticFlame, 300, IDrawableAnimated.StartDirection.TOP, true);
        this.inputOverlay = guiHelper.createDrawable(VehicleModJei.RECIPE_GUI_VEHICLE, 160, 14, 16, 29);
        this.outputOverlay = guiHelper.createDrawable(VehicleModJei.RECIPE_GUI_VEHICLE, 160, 14, 16, 59);
        this.localizedName = I18n.func_135052_a((String)"jev.category.fluid_mixing.title", (Object[])new Object[0]);
    }

    @Nonnull
    public IDrawable getBackground() {
        return this.background;
    }

    @Nullable
    public IDrawable getIcon() {
        return this.icon;
    }

    @Nonnull
    public String getTitle() {
        return this.localizedName;
    }

    @Nonnull
    public String getModName() {
        return "Just Enough Vehicles";
    }

    @Nonnull
    public String getUid() {
        return "jev:fluid_mixer";
    }

    public void drawExtras(Minecraft minecraft) {
        this.animatedFlame.draw(minecraft, 1, 15);
    }

    public void setRecipe(IRecipeLayout recipeLayout, @Nonnull FluidMixerRecipeWrapper recipeWrapper, @Nonnull IIngredients ingredients) {
        IGuiItemStackGroup stacks = recipeLayout.getItemStacks();
        IGuiFluidStackGroup fluids = recipeLayout.getFluidStacks();
        stacks.init(0, true, 94, 24);
        fluids.init(0, true, 25, 1, 16, 29, 5000, false, (IDrawable)this.inputOverlay);
        fluids.init(1, true, 25, 36, 16, 29, 5000, false, (IDrawable)this.inputOverlay);
        fluids.init(2, false, 143, 4, 16, 59, 10000, false, (IDrawable)this.outputOverlay);
        stacks.set(ingredients);
        fluids.set(ingredients);
    }
}

