/*
 * Decompiled with CFR 0.152.
 */
package com.ocelot.vehicle.jei.plugin.fluidextractor;

import com.mrcrayfish.vehicle.init.ModBlocks;
import com.ocelot.vehicle.jei.VehicleModJei;
import com.ocelot.vehicle.jei.plugin.fluidextractor.FluidExtractorRecipeWrapper;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mezz.jei.api.IGuiHelper;
import mezz.jei.api.gui.IDrawable;
import mezz.jei.api.gui.IDrawableAnimated;
import mezz.jei.api.gui.IDrawableStatic;
import mezz.jei.api.gui.IGuiFluidStackGroup;
import mezz.jei.api.gui.IGuiItemStackGroup;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.IRecipeCategory;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;

public class FluidExtractorCategory
implements IRecipeCategory<FluidExtractorRecipeWrapper> {
    private final IDrawableStatic background;
    private final IDrawable icon;
    private final IDrawableAnimated animatedFlame;
    private final IDrawableStatic outputOverlay;
    private final String localizedName;

    public FluidExtractorCategory(IGuiHelper guiHelper) {
        IDrawableStatic staticFlame = guiHelper.createDrawable(VehicleModJei.RECIPE_GUI_VEHICLE, 160, 0, 14, 14);
        this.background = guiHelper.createDrawable(VehicleModJei.RECIPE_GUI_VEHICLE, 0, 66, 112, 61);
        this.icon = guiHelper.createDrawableIngredient((Object)new ItemStack(ModBlocks.FLUID_EXTRACTOR));
        this.animatedFlame = guiHelper.createAnimatedDrawable(staticFlame, 300, IDrawableAnimated.StartDirection.TOP, true);
        this.outputOverlay = guiHelper.createDrawable(VehicleModJei.RECIPE_GUI_VEHICLE, 160, 14, 16, 59);
        this.localizedName = I18n.func_135052_a((String)"jev.category.fluid_extracting.title", (Object[])new Object[0]);
    }

    @Nonnull
    public IDrawable getBackground() {
        return this.background;
    }

    @Nullable
    public IDrawable getIcon() {
        return this.icon;
    }

    @Nonnull
    public String getTitle() {
        return this.localizedName;
    }

    @Nonnull
    public String getModName() {
        return "Just Enough Vehicles";
    }

    @Nonnull
    public String getUid() {
        return "jev:fluid_extractor";
    }

    public void drawExtras(Minecraft minecraft) {
        this.animatedFlame.draw(minecraft, 32, 40);
    }

    public void setRecipe(IRecipeLayout recipeLayout, @Nonnull FluidExtractorRecipeWrapper recipeWrapper, @Nonnull IIngredients ingredients) {
        IGuiItemStackGroup stacks = recipeLayout.getItemStacks();
        IGuiFluidStackGroup fluids = recipeLayout.getFluidStacks();
        stacks.init(0, true, 31, 19);
        fluids.init(0, false, 95, 1, 16, 59, 5000, false, (IDrawable)this.outputOverlay);
        stacks.set(ingredients);
        fluids.set(ingredients);
    }
}

