/*
 * Decompiled with CFR 0.152.
 */
package burn447.dartcraftReloaded.world;

import burn447.dartcraftReloaded.blocks.ModBlocks;
import java.util.Random;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.WorldType;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.IChunkGenerator;
import net.minecraft.world.gen.feature.WorldGenMinable;
import net.minecraft.world.gen.feature.WorldGenTrees;
import net.minecraft.world.gen.feature.WorldGenerator;
import net.minecraftforge.fml.common.IWorldGenerator;

public class DCRWorldGen
implements IWorldGenerator {
    private WorldGenerator forceTree = new WorldGenTrees(false, 4, ModBlocks.forceLog.func_176203_a(0), ModBlocks.forceLeaves.func_176223_P(), false);
    private WorldGenerator forceOre = new WorldGenMinable(ModBlocks.orePower.func_176223_P(), 6);

    private void runGenerator(WorldGenerator generator, World world, Random rand, int chunk_X, int chunk_Z, int chancesToSpawn, int minHeight, int maxHeight) {
        if (minHeight < 0 || maxHeight > 256 || minHeight > maxHeight) {
            throw new IllegalArgumentException("Illegal Height Arguments for WorldGenerator");
        }
        int heightDiff = maxHeight - minHeight + 1;
        for (int i = 0; i < chancesToSpawn; ++i) {
            int x = chunk_X * 16 + rand.nextInt(8) + 8;
            int y = minHeight + rand.nextInt(heightDiff);
            int z = chunk_Z * 16 + rand.nextInt(8) + 8;
            generator.func_180709_b(world, rand, new BlockPos(x, y, z));
        }
    }

    public void generate(Random random, int chunkX, int chunkZ, World world, IChunkGenerator chunkGenerator, IChunkProvider chunkProvider) {
        switch (world.field_73011_w.getDimension()) {
            case 0: {
                if (world.func_175624_G() == WorldType.field_77138_c) break;
                this.runGenerator(this.forceTree, world, random, chunkX, chunkZ, 10, 4, 256);
                this.runGenerator(this.forceOre, world, random, chunkX, chunkZ, 5, 0, 64);
            }
        }
    }
}

