/*
 * Decompiled with CFR 0.152.
 */
package burn447.dartcraftReloaded.util;

import burn447.dartcraftReloaded.Handlers.DCRPacketHandler;
import burn447.dartcraftReloaded.blocks.BlockForceLog;
import java.util.Locale;
import java.util.Map;
import java.util.Stack;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLog;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.network.NetHandlerPlayClient;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.network.Packet;
import net.minecraft.network.play.client.CPacketPlayerDigging;
import net.minecraft.network.play.server.SPacketBlockChange;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.GameType;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.event.ForgeEventFactory;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DartUtils {
    public static Logger logger;
    public static final String RESOURCE;

    public static Logger getLogger() {
        if (logger == null) {
            logger = LogManager.getFormatterLogger((String)"dartcraftreloaded");
        }
        return logger;
    }

    public static void removeEnchant(Enchantment enchantment, ItemStack stack) {
        Map enchantMap = EnchantmentHelper.func_82781_a((ItemStack)stack);
        if (enchantMap.containsKey(enchantment)) {
            enchantMap.remove(enchantment);
        }
        EnchantmentHelper.func_82782_a((Map)enchantMap, (ItemStack)stack);
    }

    public static boolean isTree(World world, BlockPos origin) {
        BlockPos pos = null;
        Stack<BlockPos> candidates = new Stack<BlockPos>();
        candidates.add(origin);
        while (!candidates.isEmpty()) {
            BlockPos candidate = (BlockPos)candidates.pop();
            if (pos != null && candidate.func_177956_o() <= pos.func_177956_o() || !DartUtils.isLog(world, candidate)) continue;
            pos = candidate.func_177984_a();
            while (DartUtils.isLog(world, pos)) {
                pos = pos.func_177984_a();
            }
            candidates.add(pos.func_177978_c());
            candidates.add(pos.func_177974_f());
            candidates.add(pos.func_177968_d());
            candidates.add(pos.func_177976_e());
        }
        if (pos == null) {
            return false;
        }
        int d = 3;
        int o = -1;
        int leaves = 0;
        for (int x = 0; x < d; ++x) {
            for (int y = 0; y < d; ++y) {
                for (int z = 0; z < d; ++z) {
                    BlockPos leaf = pos.func_177982_a(o + x, o + y, o + z);
                    IBlockState state = world.func_180495_p(leaf);
                    if (!state.func_177230_c().isLeaves(state, (IBlockAccess)world, leaf) || ++leaves < 5) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public static boolean isLog(World world, BlockPos pos) {
        return world.func_180495_p(pos).func_177230_c() instanceof BlockLog || world.func_180495_p(pos).func_177230_c() instanceof BlockForceLog;
    }

    public static void breakExtraBlock(ItemStack stack, World world, EntityPlayer player, BlockPos pos, BlockPos refPos) {
        if (!DartUtils.canBreakExtraBlock(stack, world, player, pos, refPos)) {
            return;
        }
        IBlockState state = world.func_180495_p(pos);
        Block block = state.func_177230_c();
        stack.func_179548_a(world, state, pos, player);
        if (!world.field_72995_K) {
            int xp = ForgeHooks.onBlockBreakEvent((World)world, (GameType)((EntityPlayerMP)player).field_71134_c.func_73081_b(), (EntityPlayerMP)((EntityPlayerMP)player), (BlockPos)pos);
            if (xp == -1) {
                return;
            }
            TileEntity tileEntity = world.func_175625_s(pos);
            if (block.removedByPlayer(state, world, pos, player, true)) {
                block.func_176208_a(world, pos, state, player);
                block.func_180657_a(world, player, pos, state, tileEntity, stack);
                block.func_180637_b(world, pos, xp);
            }
            DCRPacketHandler.sendPacket((Entity)player, new SPacketBlockChange(world, pos));
        } else {
            world.func_175669_a(2001, pos, Block.func_176210_f((IBlockState)state));
            if (block.removedByPlayer(state, world, pos, player, true)) {
                block.func_176208_a(world, pos, state, player);
            }
            stack.func_179548_a(world, state, pos, player);
            if (stack.func_190916_E() == 0 && stack == player.func_184614_ca()) {
                ForgeEventFactory.onPlayerDestroyItem((EntityPlayer)player, (ItemStack)stack, (EnumHand)EnumHand.MAIN_HAND);
                player.func_184611_a(EnumHand.MAIN_HAND, ItemStack.field_190927_a);
            }
            NetHandlerPlayClient netHandlerPlayClient = Minecraft.func_71410_x().func_147114_u();
            assert (netHandlerPlayClient != null);
            netHandlerPlayClient.func_147297_a((Packet)new CPacketPlayerDigging(CPacketPlayerDigging.Action.STOP_DESTROY_BLOCK, pos, Minecraft.func_71410_x().field_71476_x.field_178784_b));
        }
    }

    private static boolean canBreakExtraBlock(ItemStack stack, World world, EntityPlayer player, BlockPos pos, BlockPos refPos) {
        if (world.func_175623_d(pos)) {
            return false;
        }
        IBlockState state = world.func_180495_p(pos);
        Block block = state.func_177230_c();
        IBlockState refState = world.func_180495_p(refPos);
        float refStrength = ForgeHooks.blockStrength((IBlockState)refState, (EntityPlayer)player, (World)world, (BlockPos)refPos);
        float strength = ForgeHooks.blockStrength((IBlockState)state, (EntityPlayer)player, (World)world, (BlockPos)pos);
        if (!ForgeHooks.canHarvestBlock((Block)block, (EntityPlayer)player, (IBlockAccess)world, (BlockPos)pos) || refStrength / strength > 10.0f) {
            return false;
        }
        if (player.field_71075_bZ.field_75098_d) {
            block.func_176208_a(world, pos, state, player);
            if (block.removedByPlayer(state, world, pos, player, false)) {
                block.func_176208_a(world, pos, state, player);
            }
            if (!world.field_72995_K) {
                DCRPacketHandler.sendPacket((Entity)player, new SPacketBlockChange(world, pos));
            }
            return false;
        }
        return true;
    }

    public static boolean isFakePlayer(Entity player) {
        return player instanceof FakePlayer;
    }

    public static String resource(String res) {
        return String.format("%s:%s", RESOURCE, res);
    }

    public static ResourceLocation getResource(String res) {
        return new ResourceLocation(RESOURCE, res);
    }

    static {
        RESOURCE = "dartcraftreloaded".toLowerCase(Locale.US);
    }
}

