/*
 * Decompiled with CFR 0.152.
 */
package burn447.dartcraftReloaded.tileEntity;

import burn447.dartcraftReloaded.Energy.DCREnergyStorage;
import burn447.dartcraftReloaded.Fluids.FluidForce;
import burn447.dartcraftReloaded.Handlers.DCRCapabilityHandler;
import burn447.dartcraftReloaded.Items.ItemArmor;
import burn447.dartcraftReloaded.Items.ModItems;
import burn447.dartcraftReloaded.Items.Tools.ItemForceAxe;
import burn447.dartcraftReloaded.Items.Tools.ItemForcePickaxe;
import burn447.dartcraftReloaded.Items.Tools.ItemForceRod;
import burn447.dartcraftReloaded.Items.Tools.ItemForceShears;
import burn447.dartcraftReloaded.Items.Tools.ItemForceShovel;
import burn447.dartcraftReloaded.Items.Tools.ItemForceSword;
import burn447.dartcraftReloaded.blocks.ModBlocks;
import burn447.dartcraftReloaded.blocks.torch.BlockForceTorch;
import burn447.dartcraftReloaded.capablilities.ForceRod.IForceRodModifier;
import burn447.dartcraftReloaded.capablilities.ToolModifier.IToolModifier;
import burn447.dartcraftReloaded.util.EnchantUtils;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.init.Blocks;
import net.minecraft.init.Enchantments;
import net.minecraft.init.Items;
import net.minecraft.init.MobEffects;
import net.minecraft.inventory.ItemStackHelper;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.potion.PotionEffect;
import net.minecraft.potion.PotionUtils;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidTankProperties;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.ItemStackHandler;

public class TileEntityInfuser
extends TileEntity
implements ITickable,
ICapabilityProvider,
ITileEntityProvider,
IFluidHandler {
    public final ItemStackHandler handler;
    public FluidTank tank;
    private NonNullList<ItemStack> infuserContents = NonNullList.func_191196_a();
    public static List<Item> validToolList = new ArrayList<Item>();
    public static List<Item> validModifierList = new ArrayList<Item>();
    public boolean canWork = false;
    public int processTime = 0;
    public int maxProcessTime = 17;
    public static int MAX_POWER = 1000000;
    public static int RF_PER_TICK = 20;
    public static int PR_PER_TICK_INPUT = 200;
    public int fluidContained;
    public int energyStored;
    public DCREnergyStorage energyStorage = new DCREnergyStorage(MAX_POWER, 1000);
    protected static final AxisAlignedBB AABB = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.75, 1.0);

    public TileEntityInfuser() {
        this.populateToolList();
        this.populateModiferList();
        this.handler = new ItemStackHandler(11){

            protected int getStackLimit(int slot, ItemStack stack) {
                return 1;
            }
        };
        this.tank = new FluidTank(50000);
    }

    public void func_145839_a(NBTTagCompound nbt) {
        this.handler.deserializeNBT(nbt.func_74775_l("ItemStackHandler"));
        ItemStackHelper.func_191283_b((NBTTagCompound)nbt, this.infuserContents);
        this.energyStorage.setEnergy(nbt.func_74762_e("EnergyHandler"));
        this.tank.readFromNBT(nbt);
        super.func_70296_d();
        super.func_145839_a(nbt);
    }

    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        nbt.func_74782_a("ItemStackHandler", (NBTBase)this.handler.serializeNBT());
        nbt.func_74768_a("EnergyHandler", this.energyStorage.getEnergyStored());
        ItemStackHelper.func_191282_a((NBTTagCompound)nbt, this.infuserContents);
        this.tank.writeToNBT(nbt);
        return super.func_189515_b(nbt);
    }

    public AxisAlignedBB getRenderBoundingBox() {
        return AABB;
    }

    public void func_73660_a() {
        this.fluidContained = this.tank.getFluidAmount();
        if (this.field_145850_b != null && !this.field_145850_b.field_72995_K) {
            this.processForceGems();
            if (this.canWork) {
                if (this.processTime == this.maxProcessTime) {
                    this.func_70296_d();
                    this.processTool();
                }
                ++this.processTime;
            }
        }
    }

    private void processForceGems() {
        if (this.handler.getStackInSlot(9).func_77973_b() == ModItems.gemForceGem) {
            FluidStack force = new FluidStack(FluidRegistry.getFluid((String)"force"), 500);
            if (this.tank.getFluidAmount() < this.tank.getCapacity() - 100) {
                this.fill(force, true);
                if (this.handler.getStackInSlot(9).func_190916_E() > 1) {
                    this.handler.getStackInSlot(9).func_190920_e(this.handler.getStackInSlot(9).func_190916_E() - 1);
                } else {
                    this.handler.setStackInSlot(9, ItemStack.field_190927_a);
                }
                this.func_70296_d();
                this.field_145850_b.func_184138_a(this.field_174879_c, this.field_145850_b.func_180495_p(this.field_174879_c), this.field_145850_b.func_180495_p(this.field_174879_c), 2);
            }
        }
    }

    private void processTool() {
        if (this.hasValidTool()) {
            for (int i = 0; i < 8; ++i) {
                if (!this.hasValidModifer(i)) continue;
                ItemStack mod = this.getModifier(i);
                ItemStack stack = this.handler.getStackInSlot(8);
                boolean success = this.applyModifier(stack, mod);
                if (!success) continue;
                this.handler.setStackInSlot(i, ItemStack.field_190927_a);
                this.tank.drain(1000, true);
                this.energyStorage.consumePower(RF_PER_TICK);
                this.field_145850_b.func_184138_a(this.field_174879_c, this.field_145850_b.func_180495_p(this.field_174879_c), this.field_145850_b.func_180495_p(this.field_174879_c), 2);
            }
        }
        this.canWork = false;
        this.processTime = 0;
    }

    public SPacketUpdateTileEntity func_189518_D_() {
        NBTTagCompound nbt = new NBTTagCompound();
        this.func_70296_d();
        this.func_189515_b(nbt);
        int metadata = this.func_145832_p();
        return new SPacketUpdateTileEntity(this.field_174879_c, metadata, nbt);
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        this.func_145839_a(pkt.func_148857_g());
    }

    public NBTTagCompound func_189517_E_() {
        NBTTagCompound nbt = new NBTTagCompound();
        this.func_70296_d();
        this.func_189515_b(nbt);
        return nbt;
    }

    public void handleUpdateTag(NBTTagCompound tag) {
        this.func_145839_a(tag);
    }

    public NBTTagCompound getTileData() {
        NBTTagCompound nbt = new NBTTagCompound();
        this.func_189515_b(nbt);
        return nbt;
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return (T)this.handler;
        }
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return (T)this.tank;
        }
        if (capability == CapabilityEnergy.ENERGY) {
            return (T)CapabilityEnergy.ENERGY.cast((Object)this.energyStorage);
        }
        return (T)super.getCapability(capability, facing);
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY || capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY || capability == CapabilityEnergy.ENERGY) {
            return true;
        }
        return super.hasCapability(capability, facing);
    }

    private boolean hasValidTool() {
        if (!this.handler.getStackInSlot(8).func_190926_b()) {
            for (int i = 0; i < 11; ++i) {
                if (this.handler.getStackInSlot(8).func_77973_b() != validToolList.get(i)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean hasValidModifer(int slot) {
        if (!this.handler.getStackInSlot(8).func_190926_b()) {
            for (int j = 0; j < 24; ++j) {
                if (this.handler.getStackInSlot(slot).func_77973_b() != validModifierList.get(j)) continue;
                return true;
            }
        }
        return false;
    }

    private void populateToolList() {
        validToolList.add((Item)ModItems.forcePickaxe);
        validToolList.add((Item)ModItems.forceAxe);
        validToolList.add((Item)ModItems.forceShovel);
        validToolList.add((Item)ModItems.forceSword);
        validToolList.add(ModItems.forceRod);
        validToolList.add((Item)ModItems.forceShears);
        validToolList.add((Item)ModItems.forceHelmet);
        validToolList.add((Item)ModItems.forceChest);
        validToolList.add((Item)ModItems.forceLegs);
        validToolList.add((Item)ModItems.forceBoots);
        validToolList.add(Item.func_150898_a((Block)ModBlocks.forceTorch));
    }

    private void populateModiferList() {
        validModifierList.add(ModItems.nuggetForce);
        validModifierList.add(ModItems.claw);
        validModifierList.add(ModItems.fortune);
        validModifierList.add(Items.field_151102_aT);
        validModifierList.add(Items.field_151044_h);
        validModifierList.add(ModItems.goldenPowerSource);
        validModifierList.add((Item)ModItems.cookieFortune);
        validModifierList.add(Items.field_151145_ak);
        validModifierList.add(Items.field_151100_aR);
        validModifierList.add(Items.field_151062_by);
        validModifierList.add(Items.field_151070_bp);
        validModifierList.add(Items.field_151032_g);
        validModifierList.add(Items.field_151073_bk);
        validModifierList.add((Item)ModItems.soulWafer);
        validModifierList.add(Items.field_151008_G);
        validModifierList.add(Items.field_151079_bi);
        validModifierList.add(Items.field_151114_aO);
        validModifierList.add((Item)Items.field_151068_bn);
        validModifierList.add(Items.field_151113_aN);
        validModifierList.add(Item.func_150898_a((Block)Blocks.field_150462_ai));
        validModifierList.add(Item.func_150898_a((Block)ModBlocks.forceLog));
        validModifierList.add(Item.func_150898_a((Block)Blocks.field_150321_G));
        validModifierList.add(Item.func_150898_a((Block)Blocks.field_150343_Z));
        validModifierList.add(Item.func_150898_a((Block)Blocks.field_150336_V));
    }

    private ItemStack getModifier(int slot) {
        if (!this.handler.getStackInSlot(8).func_190926_b()) {
            for (int j = 0; j < 24; ++j) {
                if (this.handler.getStackInSlot(slot).func_77973_b() != validModifierList.get(j)) continue;
                return this.handler.getStackInSlot(slot);
            }
        }
        return null;
    }

    @Nullable
    public TileEntity func_149915_a(World worldIn, int meta) {
        return new TileEntityInfuser();
    }

    private boolean applyModifier(ItemStack stack, ItemStack mod) {
        Item modifier = mod.func_77973_b();
        if (modifier == Items.field_151102_aT) {
            return this.addSpeedModifier(stack);
        }
        if (modifier == Items.field_151044_h) {
            return this.addHeatModifier(stack);
        }
        if (modifier == ModItems.nuggetForce) {
            return this.addForceModifier(stack);
        }
        if (modifier == Item.func_150898_a((Block)Blocks.field_150321_G)) {
            return this.addSilkTouchModifier(stack);
        }
        if (modifier == ModItems.claw) {
            return this.addDamageModifier(stack);
        }
        if (modifier == ModItems.fortune) {
            return this.addLuckModifier(stack);
        }
        if (modifier == Items.field_151114_aO) {
            return this.addLightModifier(stack);
        }
        if (modifier == Item.func_150898_a((Block)Blocks.field_150336_V) || modifier == Item.func_150898_a((Block)Blocks.field_150343_Z)) {
            return this.addSturdyModifier(stack);
        }
        if (modifier == Item.func_150898_a((Block)ModBlocks.forceLog)) {
            return this.addLumberjackModifier(stack);
        }
        if (modifier == Items.field_151073_bk) {
            return this.addHealingModifier(stack);
        }
        if (modifier == Items.field_151079_bi) {
            return this.addEnderModifier(stack);
        }
        if (modifier == Items.field_151032_g) {
            return this.addBleedingModifier(stack);
        }
        if (modifier == Items.field_151070_bp) {
            return this.addBaneModifier(stack);
        }
        if (modifier == Items.field_151008_G) {
            return this.addWingModifier(stack);
        }
        if (modifier == Items.field_151068_bn) {
            List effects = PotionUtils.func_185189_a((ItemStack)mod);
            for (PotionEffect e : effects) {
                if (e.func_188419_a() == MobEffects.field_76439_r) {
                    return this.addSightModifier(stack);
                }
                if (e.func_188419_a() != MobEffects.field_76441_p) continue;
                return this.addCamoModifier(stack);
            }
        }
        if (modifier == Items.field_151100_aR && mod.func_77960_j() == 4) {
            return this.addRainbowModifier(stack);
        }
        if (modifier == Items.field_151113_aN) {
            return this.addTimeModifier(stack);
        }
        return false;
    }

    private boolean addLightModifier(ItemStack stack) {
        if (stack.func_77973_b() instanceof ItemForceRod && !((IForceRodModifier)stack.getCapability(DCRCapabilityHandler.CAPABILITY_FORCEROD, null)).hasLight()) {
            ((IForceRodModifier)stack.getCapability(DCRCapabilityHandler.CAPABILITY_FORCEROD, null)).setLight(true);
            return true;
        }
        return false;
    }

    private boolean addCamoModifier(ItemStack stack) {
        if (stack.func_77973_b() instanceof ItemForceRod && !((IForceRodModifier)stack.getCapability(DCRCapabilityHandler.CAPABILITY_FORCEROD, null)).hasCamoModifier()) {
            ((IForceRodModifier)stack.getCapability(DCRCapabilityHandler.CAPABILITY_FORCEROD, null)).setCamoModifier(true);
            return true;
        }
        return false;
    }

    private boolean addSightModifier(ItemStack stack) {
        if (stack.func_77973_b() instanceof ItemForceRod && !((IForceRodModifier)stack.getCapability(DCRCapabilityHandler.CAPABILITY_FORCEROD, null)).hasSightModifier()) {
            ((IForceRodModifier)stack.getCapability(DCRCapabilityHandler.CAPABILITY_FORCEROD, null)).setSightModifier(true);
            return true;
        }
        return false;
    }

    private boolean addWingModifier(ItemStack stack) {
        if (stack.func_77973_b() instanceof ItemForceSword) {
            if (!((IToolModifier)stack.getCapability(DCRCapabilityHandler.CAPABILITY_TOOLMOD, null)).hasWing()) {
                ((IToolModifier)stack.getCapability(DCRCapabilityHandler.CAPABILITY_TOOLMOD, null)).setWing(true);
                return true;
            }
        } else if (stack.func_77973_b() instanceof ItemArmor && ((IToolModifier)stack.getCapability(DCRCapabilityHandler.CAPABILITY_TOOLMOD, null)).hasWing()) {
            ((IToolModifier)stack.getCapability(DCRCapabilityHandler.CAPABILITY_TOOLMOD, null)).setWing(true);
            return true;
        }
        return false;
    }

    private boolean addBaneModifier(ItemStack stack) {
        Item st = stack.func_77973_b();
        if (st instanceof ItemForceSword) {
            if (((IToolModifier)stack.getCapability(DCRCapabilityHandler.CAPABILITY_TOOLMOD, null)).getBaneLevel() < 4) {
                ((IToolModifier)stack.getCapability(DCRCapabilityHandler.CAPABILITY_TOOLMOD, null)).incrementBane();
                return true;
            }
        } else if (st instanceof ItemArmor) {
            if (((IToolModifier)stack.getCapability(DCRCapabilityHandler.CAPABILITY_TOOLMOD, null)).getBaneLevel() == 0) {
                ((IToolModifier)stack.getCapability(DCRCapabilityHandler.CAPABILITY_TOOLMOD, null)).incrementBane();
                return true;
            }
            if (((IToolModifier)stack.getCapability(DCRCapabilityHandler.CAPABILITY_TOOLMOD, null)).getBaneLevel() < 4) {
                ((IToolModifier)stack.getCapability(DCRCapabilityHandler.CAPABILITY_TOOLMOD, null)).incrementBane();
                return true;
            }
        }
        return false;
    }

    private boolean addBleedingModifier(ItemStack stack) {
        Item st = stack.func_77973_b();
        if (st instanceof ItemForceSword) {
            if (((IToolModifier)stack.getCapability(DCRCapabilityHandler.CAPABILITY_TOOLMOD, null)).getBleedLevel() < 2) {
                ((IToolModifier)stack.getCapability(DCRCapabilityHandler.CAPABILITY_TOOLMOD, null)).incrementBleed();
                return true;
            }
        } else if (st instanceof ItemArmor) {
            if (((IToolModifier)stack.getCapability(DCRCapabilityHandler.CAPABILITY_TOOLMOD, null)).getBleedLevel() == 0) {
                ((IToolModifier)stack.getCapability(DCRCapabilityHandler.CAPABILITY_TOOLMOD, null)).incrementBleed();
                return true;
            }
            if (((IToolModifier)stack.getCapability(DCRCapabilityHandler.CAPABILITY_TOOLMOD, null)).getBleedLevel() < 2) {
                ((IToolModifier)stack.getCapability(DCRCapabilityHandler.CAPABILITY_TOOLMOD, null)).incrementBleed();
                return true;
            }
        }
        return false;
    }

    private boolean addEnderModifier(ItemStack stack) {
        if (stack.func_77973_b() instanceof ItemForceRod && !((IForceRodModifier)stack.getCapability(DCRCapabilityHandler.CAPABILITY_FORCEROD, null)).isRodofEnder()) {
            ((IForceRodModifier)stack.getCapability(DCRCapabilityHandler.CAPABILITY_FORCEROD, null)).setEnderModifier(true);
            return true;
        }
        return false;
    }

    private boolean addHealingModifier(ItemStack stack) {
        if (stack.func_77973_b() instanceof ItemForceRod) {
            if (!((IForceRodModifier)stack.getCapability(DCRCapabilityHandler.CAPABILITY_FORCEROD, null)).isRodOfHealing(1)) {
                ((IForceRodModifier)stack.getCapability(DCRCapabilityHandler.CAPABILITY_FORCEROD, null)).setRodOfHealing(true, 1);
                return true;
            }
            if (!((IForceRodModifier)stack.getCapability(DCRCapabilityHandler.CAPABILITY_FORCEROD, null)).isRodOfHealing(2) && ((IForceRodModifier)stack.getCapability(DCRCapabilityHandler.CAPABILITY_FORCEROD, null)).isRodOfHealing(1)) {
                ((IForceRodModifier)stack.getCapability(DCRCapabilityHandler.CAPABILITY_FORCEROD, null)).setRodOfHealing(true, 2);
                return true;
            }
            if (!((IForceRodModifier)stack.getCapability(DCRCapabilityHandler.CAPABILITY_FORCEROD, null)).isRodOfHealing(3) && ((IForceRodModifier)stack.getCapability(DCRCapabilityHandler.CAPABILITY_FORCEROD, null)).isRodOfHealing(2) && ((IForceRodModifier)stack.getCapability(DCRCapabilityHandler.CAPABILITY_FORCEROD, null)).isRodOfHealing(1)) {
                ((IForceRodModifier)stack.getCapability(DCRCapabilityHandler.CAPABILITY_FORCEROD, null)).setRodOfHealing(true, 3);
                return true;
            }
        }
        return false;
    }

    private boolean addLumberjackModifier(ItemStack stack) {
        if (stack.func_77973_b() instanceof ItemForceAxe && !((IToolModifier)stack.getCapability(DCRCapabilityHandler.CAPABILITY_TOOLMOD, null)).hasLumberjack()) {
            ((IToolModifier)stack.getCapability(DCRCapabilityHandler.CAPABILITY_TOOLMOD, null)).setLumberjack(true);
            return true;
        }
        return false;
    }

    private boolean addRainbowModifier(ItemStack stack) {
        if (stack.func_77973_b() instanceof ItemForceShears) {
            ((IToolModifier)stack.getCapability(DCRCapabilityHandler.CAPABILITY_TOOLMOD, null)).setRainbow(true);
            return true;
        }
        return false;
    }

    private boolean addTimeModifier(ItemStack stack) {
        if (Block.func_149634_a((Item)stack.func_77973_b()) instanceof BlockForceTorch) {
            this.handler.setStackInSlot(8, new ItemStack((Block)ModBlocks.timetorch, 1));
            return true;
        }
        return false;
    }

    private boolean addSturdyModifier(ItemStack stack) {
        Item st = stack.func_77973_b();
        if (st instanceof ItemForceSword || st instanceof ItemForceAxe || st instanceof ItemForceShovel || st instanceof ItemForcePickaxe || st instanceof ItemForceRod) {
            if (((IToolModifier)stack.getCapability(DCRCapabilityHandler.CAPABILITY_TOOLMOD, null)).getSturdyLevel() == 0) {
                ((IToolModifier)stack.getCapability(DCRCapabilityHandler.CAPABILITY_TOOLMOD, null)).incrementSturdy();
                stack.func_77966_a(Enchantments.field_185307_s, 1);
                return true;
            }
            if (((IToolModifier)stack.getCapability(DCRCapabilityHandler.CAPABILITY_TOOLMOD, null)).getSturdyLevel() < 10) {
                ((IToolModifier)stack.getCapability(DCRCapabilityHandler.CAPABILITY_TOOLMOD, null)).incrementSturdy();
                EnchantUtils.incrementLevel(stack, Enchantments.field_185307_s);
                return true;
            }
        } else if (stack.func_77973_b() instanceof ItemArmor) {
            if (((IToolModifier)stack.getCapability(DCRCapabilityHandler.CAPABILITY_TOOLMOD, null)).getSturdyLevel() == 0) {
                ((IToolModifier)stack.getCapability(DCRCapabilityHandler.CAPABILITY_TOOLMOD, null)).incrementSturdy();
                return true;
            }
            if (((IToolModifier)stack.getCapability(DCRCapabilityHandler.CAPABILITY_TOOLMOD, null)).getSturdyLevel() < 10) {
                ((IToolModifier)stack.getCapability(DCRCapabilityHandler.CAPABILITY_TOOLMOD, null)).incrementSturdy();
                return true;
            }
        }
        return false;
    }

    private boolean addLuckModifier(ItemStack stack) {
        Item st = stack.func_77973_b();
        if (st instanceof ItemForcePickaxe || st instanceof ItemForceShovel || st instanceof ItemForceAxe) {
            if (((IToolModifier)stack.getCapability(DCRCapabilityHandler.CAPABILITY_TOOLMOD, null)).getLuckLevel() == 0) {
                ((IToolModifier)stack.getCapability(DCRCapabilityHandler.CAPABILITY_TOOLMOD, null)).incrementLuck();
                stack.func_77966_a(Enchantments.field_185308_t, 1);
                return true;
            }
            if (((IToolModifier)stack.getCapability(DCRCapabilityHandler.CAPABILITY_TOOLMOD, null)).getLuckLevel() < 10) {
                ((IToolModifier)stack.getCapability(DCRCapabilityHandler.CAPABILITY_TOOLMOD, null)).incrementLuck();
                EnchantUtils.incrementLevel(stack, Enchantments.field_185308_t);
                return true;
            }
        } else if (st instanceof ItemForceSword) {
            if (((IToolModifier)stack.getCapability(DCRCapabilityHandler.CAPABILITY_TOOLMOD, null)).getLuckLevel() == 0) {
                ((IToolModifier)stack.getCapability(DCRCapabilityHandler.CAPABILITY_TOOLMOD, null)).incrementLuck();
                stack.func_77966_a(Enchantments.field_185304_p, 1);
                return true;
            }
            if (((IToolModifier)stack.getCapability(DCRCapabilityHandler.CAPABILITY_TOOLMOD, null)).getLuckLevel() < 10) {
                ((IToolModifier)stack.getCapability(DCRCapabilityHandler.CAPABILITY_TOOLMOD, null)).incrementLuck();
                EnchantUtils.incrementLevel(stack, Enchantments.field_185304_p);
                return true;
            }
        } else if (st instanceof ItemArmor) {
            if (((IToolModifier)stack.getCapability(DCRCapabilityHandler.CAPABILITY_TOOLMOD, null)).getLuckLevel() == 0) {
                ((IToolModifier)stack.getCapability(DCRCapabilityHandler.CAPABILITY_TOOLMOD, null)).incrementLuck();
                return true;
            }
            if (((IToolModifier)stack.getCapability(DCRCapabilityHandler.CAPABILITY_TOOLMOD, null)).getLuckLevel() < 10) {
                ((IToolModifier)stack.getCapability(DCRCapabilityHandler.CAPABILITY_TOOLMOD, null)).incrementLuck();
                return true;
            }
        }
        return false;
    }

    private boolean addDamageModifier(ItemStack stack) {
        Item st = stack.func_77973_b();
        if (st instanceof ItemForceSword) {
            if (((IToolModifier)stack.getCapability(DCRCapabilityHandler.CAPABILITY_TOOLMOD, null)).getSharpLevel() == 0) {
                ((IToolModifier)stack.getCapability(DCRCapabilityHandler.CAPABILITY_TOOLMOD, null)).incrementSharp();
                stack.func_77966_a(Enchantments.field_185302_k, 1);
                return true;
            }
            if (((IToolModifier)stack.getCapability(DCRCapabilityHandler.CAPABILITY_TOOLMOD, null)).getSharpLevel() < 10) {
                ((IToolModifier)stack.getCapability(DCRCapabilityHandler.CAPABILITY_TOOLMOD, null)).incrementSharp();
                EnchantUtils.incrementLevel(stack, Enchantments.field_185302_k);
                return true;
            }
        } else if (st instanceof ItemArmor) {
            if (((IToolModifier)stack.getCapability(DCRCapabilityHandler.CAPABILITY_TOOLMOD, null)).getSharpLevel() == 0) {
                ((IToolModifier)stack.getCapability(DCRCapabilityHandler.CAPABILITY_TOOLMOD, null)).incrementSharp();
                return true;
            }
            if (((IToolModifier)stack.getCapability(DCRCapabilityHandler.CAPABILITY_TOOLMOD, null)).getSharpLevel() < 10) {
                ((IToolModifier)stack.getCapability(DCRCapabilityHandler.CAPABILITY_TOOLMOD, null)).incrementSharp();
                return true;
            }
        }
        return false;
    }

    private boolean addSilkTouchModifier(ItemStack stack) {
        Item st = stack.func_77973_b();
        if ((st instanceof ItemForceAxe || st instanceof ItemForceShovel || st instanceof ItemForcePickaxe) && !((IToolModifier)stack.getCapability(DCRCapabilityHandler.CAPABILITY_TOOLMOD, null)).hasSilk()) {
            ((IToolModifier)stack.getCapability(DCRCapabilityHandler.CAPABILITY_TOOLMOD, null)).setSilk(true);
            stack.func_77966_a(Enchantments.field_185306_r, 1);
            return true;
        }
        return false;
    }

    private boolean addForceModifier(ItemStack stack) {
        Item st = stack.func_77973_b();
        if (st instanceof ItemForceSword) {
            if (((IToolModifier)stack.getCapability(DCRCapabilityHandler.CAPABILITY_TOOLMOD, null)).getForceLevel() == 0) {
                ((IToolModifier)stack.getCapability(DCRCapabilityHandler.CAPABILITY_TOOLMOD, null)).incrementForce();
                stack.func_77966_a(Enchantments.field_180313_o, 1);
                return true;
            }
            if (((IToolModifier)stack.getCapability(DCRCapabilityHandler.CAPABILITY_TOOLMOD, null)).getForceLevel() < 10) {
                ((IToolModifier)stack.getCapability(DCRCapabilityHandler.CAPABILITY_TOOLMOD, null)).incrementForce();
                EnchantUtils.incrementLevel(stack, Enchantments.field_180313_o);
                return true;
            }
        }
        return false;
    }

    private boolean addHeatModifier(ItemStack stack) {
        Item st = stack.func_77973_b();
        if (st instanceof ItemForceAxe || st instanceof ItemForceShovel || st instanceof ItemForcePickaxe) {
            if (!((IToolModifier)stack.getCapability(DCRCapabilityHandler.CAPABILITY_TOOLMOD, null)).hasHeat()) {
                ((IToolModifier)stack.getCapability(DCRCapabilityHandler.CAPABILITY_TOOLMOD, null)).setHeat(true);
                return true;
            }
        } else if (stack.func_77973_b() instanceof ItemArmor && !((IToolModifier)stack.getCapability(DCRCapabilityHandler.CAPABILITY_TOOLMOD, null)).hasHeat()) {
            ((IToolModifier)stack.getCapability(DCRCapabilityHandler.CAPABILITY_TOOLMOD, null)).setHeat(true);
            return true;
        }
        return false;
    }

    private boolean addSpeedModifier(ItemStack stack) {
        if (stack.func_77973_b() instanceof ItemForceShovel || stack.func_77973_b() instanceof ItemForcePickaxe || stack.func_77973_b() instanceof ItemForceAxe) {
            if (((IToolModifier)stack.getCapability(DCRCapabilityHandler.CAPABILITY_TOOLMOD, null)).getSpeedLevel() == 0) {
                ((IToolModifier)stack.getCapability(DCRCapabilityHandler.CAPABILITY_TOOLMOD, null)).incrementSpeed();
                stack.func_77966_a(Enchantments.field_185305_q, 1);
                return true;
            }
            if (((IToolModifier)stack.getCapability(DCRCapabilityHandler.CAPABILITY_TOOLMOD, null)).getSpeedLevel() < 10) {
                ((IToolModifier)stack.getCapability(DCRCapabilityHandler.CAPABILITY_TOOLMOD, null)).incrementSpeed();
                EnchantUtils.incrementLevel(stack, Enchantments.field_185305_q);
                return true;
            }
        } else if (stack.func_77973_b() instanceof ItemArmor) {
            if (((IToolModifier)stack.getCapability(DCRCapabilityHandler.CAPABILITY_TOOLMOD, null)).getSpeedLevel() == 0) {
                ((IToolModifier)stack.getCapability(DCRCapabilityHandler.CAPABILITY_TOOLMOD, null)).incrementSpeed();
                return true;
            }
            if (((IToolModifier)stack.getCapability(DCRCapabilityHandler.CAPABILITY_TOOLMOD, null)).getSpeedLevel() < 10) {
                ((IToolModifier)stack.getCapability(DCRCapabilityHandler.CAPABILITY_TOOLMOD, null)).incrementSpeed();
                return true;
            }
        }
        return false;
    }

    public IFluidTankProperties[] getTankProperties() {
        return new IFluidTankProperties[0];
    }

    public int fill(FluidStack resource, boolean doFill) {
        FluidStack resourceCopy = resource.copy();
        if (this.tank.getFluid() != null && (this.tank.getFluid().getFluid() instanceof FluidForce || this.tank.getFluidAmount() == 0)) {
            this.tank.fill(resourceCopy, true);
        }
        if (this.tank.getFluid() == null) {
            this.tank.fill(resourceCopy, true);
        }
        return resource.amount;
    }

    @Nullable
    public FluidStack drain(FluidStack resource, boolean doDrain) {
        if (!this.isFluidEqual(resource)) {
            return null;
        }
        if (!doDrain) {
            int amount = this.tank.getFluidAmount() - resource.amount < 0 ? this.tank.getFluidAmount() : resource.amount;
            return new FluidStack(this.tank.getFluid(), amount);
        }
        return this.tank.drain(resource.amount, doDrain);
    }

    @Nullable
    public FluidStack drain(int maxDrain, boolean doDrain) {
        return this.tank.drain(maxDrain, doDrain);
    }

    public float getFluidPercentage() {
        return (float)this.tank.getFluidAmount() / (float)this.tank.getCapacity();
    }

    public int getFluidGuiHeight(int maxHeight) {
        return (int)Math.ceil(this.getFluidPercentage() * (float)maxHeight);
    }

    protected boolean isFluidEqual(FluidStack fluid) {
        return this.isFluidEqual(fluid.getFluid());
    }

    protected boolean isFluidEqual(Fluid fluid) {
        return this.tank.getFluid().equals((Object)fluid);
    }
}

