/*
 * Decompiled with CFR 0.152.
 */
package burn447.dartcraftReloaded.Items.Tools;

import burn447.dartcraftReloaded.Handlers.DCRCapabilityHandler;
import burn447.dartcraftReloaded.capablilities.ToolModifier.IToolModifier;
import burn447.dartcraftReloaded.capablilities.ToolModifier.ToolModProvider;
import burn447.dartcraftReloaded.dartcraftReloaded;
import burn447.dartcraftReloaded.util.DartUtils;
import burn447.dartcraftReloaded.util.References;
import com.google.common.collect.Lists;
import gnu.trove.set.hash.THashSet;
import java.util.ArrayList;
import java.util.List;
import java.util.Queue;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemAxe;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemForceAxe
extends ItemAxe {
    private static String name;
    public List<References.MODIFIERS> applicableModifers = new ArrayList<References.MODIFIERS>();

    public ItemForceAxe(String name) {
        super(dartcraftReloaded.forceToolMaterial, 8.0f, 8.0f);
        this.setRegistryName(name);
        this.func_77655_b(name);
        this.func_77637_a(dartcraftReloaded.creativeTab);
        ItemForceAxe.name = name;
        this.field_185065_c = -2.0f;
        this.field_77865_bY = 8.0f;
    }

    public void registerItemModel() {
        dartcraftReloaded.proxy.registerItemRenderer((Item)this, 0, name);
    }

    @Nullable
    public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable NBTTagCompound nbt) {
        if (!stack.hasCapability(DCRCapabilityHandler.CAPABILITY_TOOLMOD, null)) {
            return new ToolModProvider(DCRCapabilityHandler.CAPABILITY_TOOLMOD, null);
        }
        return null;
    }

    public boolean onBlockStartBreak(ItemStack stack, BlockPos pos, EntityPlayer player) {
        if (((IToolModifier)stack.getCapability(DCRCapabilityHandler.CAPABILITY_TOOLMOD, null)).hasLumberjack() && player != null && DartUtils.isTree(player.func_130014_f_(), pos)) {
            return ItemForceAxe.fellTree(stack, pos, player);
        }
        return false;
    }

    public static boolean fellTree(ItemStack stack, BlockPos pos, EntityPlayer player) {
        if (player.func_130014_f_().field_72995_K) {
            return true;
        }
        MinecraftForge.EVENT_BUS.register((Object)new TreeChopTask(stack, pos, player, 10));
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List lores, ITooltipFlag flagIn) {
        ItemForceAxe.attatchInformation(stack, lores);
        super.func_77624_a(stack, worldIn, lores, flagIn);
    }

    static void attatchInformation(ItemStack stack, List toolTip) {
        if (stack.getCapability(DCRCapabilityHandler.CAPABILITY_TOOLMOD, null) != null && ((IToolModifier)stack.getCapability(DCRCapabilityHandler.CAPABILITY_TOOLMOD, null)).getSpeedLevel() > 0) {
            toolTip.add("Speed " + ((IToolModifier)stack.getCapability(DCRCapabilityHandler.CAPABILITY_TOOLMOD, null)).getSpeedLevel());
        }
    }

    public static class TreeChopTask {
        public final World world;
        public final EntityPlayer player;
        public final ItemStack tool;
        public final int blocksPerTick;
        public Queue<BlockPos> blocks = Lists.newLinkedList();
        public Set<BlockPos> visited = new THashSet();

        public TreeChopTask(ItemStack tool, BlockPos start, EntityPlayer player, int blocksPerTick) {
            this.world = player.func_130014_f_();
            this.player = player;
            this.tool = tool;
            this.blocksPerTick = blocksPerTick;
            this.blocks.add(start);
        }

        @SubscribeEvent
        public void chop(TickEvent.WorldTickEvent event) {
            if (event.side.isClient()) {
                this.finish();
                return;
            }
            if (event.world.field_73011_w.getDimension() != this.world.field_73011_w.getDimension()) {
                return;
            }
            int left = this.blocksPerTick;
            while (left > 0) {
                if (this.blocks.isEmpty()) {
                    this.finish();
                    return;
                }
                BlockPos pos = this.blocks.remove();
                if (!this.visited.add(pos) || !DartUtils.isLog(this.world, pos)) continue;
                for (EnumFacing facing : new EnumFacing[]{EnumFacing.NORTH, EnumFacing.EAST, EnumFacing.SOUTH, EnumFacing.WEST}) {
                    BlockPos pos2 = pos.func_177972_a(facing);
                    if (this.visited.contains(pos2)) continue;
                    this.blocks.add(pos2);
                }
                for (int x = 0; x < 3; ++x) {
                    for (int z = 0; z < 3; ++z) {
                        BlockPos pos2 = pos.func_177982_a(-1 + x, 1, -1 + z);
                        if (this.visited.contains(pos2)) continue;
                        this.blocks.add(pos2);
                    }
                }
                DartUtils.breakExtraBlock(this.tool, this.world, this.player, pos, pos);
                --left;
            }
        }

        private void finish() {
            MinecraftForge.EVENT_BUS.unregister((Object)this);
        }
    }
}

