/*
 * Decompiled with CFR 0.152.
 */
package burn447.dartcraftReloaded.Items;

import burn447.dartcraftReloaded.Handlers.DCRCapabilityHandler;
import burn447.dartcraftReloaded.capablilities.ExperienceTome.ExperienceTomeProvider;
import burn447.dartcraftReloaded.dartcraftReloaded;
import burn447.dartcraftReloaded.util.DartUtils;
import burn447.dartcraftReloaded.util.ServerHelper;
import burn447.dartcraftReloaded.util.StringHelper;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import scala.Int;

public class ItemExperienceTome
extends Item {
    private String name;
    public static final int CAPACITY = Int.MaxValue();

    public ItemExperienceTome(String name) {
        this.func_77637_a(dartcraftReloaded.creativeTab);
        this.func_77655_b(name);
        this.setRegistryName(name);
        this.name = name;
    }

    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        if (StringHelper.displayShiftForDetail && !StringHelper.isShiftKeyDown()) {
            tooltip.add("Press Shift for Details");
        }
        if (!StringHelper.isShiftKeyDown()) {
            return;
        }
        tooltip.add(Float.toString(ItemExperienceTome.getExperience(stack)) + " / " + Float.toString(ItemExperienceTome.getMaxExperience(stack)));
    }

    public void registerItemModel() {
        dartcraftReloaded.proxy.registerItemRenderer(this, 0, this.name);
    }

    @Nullable
    public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable NBTTagCompound nbt) {
        if (!stack.hasCapability(DCRCapabilityHandler.CAPABILITY_EXPTOME, null)) {
            return new ExperienceTomeProvider(DCRCapabilityHandler.CAPABILITY_EXPTOME, null);
        }
        return null;
    }

    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand hand) {
        ItemStack stack = player.func_184586_b(hand);
        if (DartUtils.isFakePlayer((Entity)player) || hand != EnumHand.MAIN_HAND || ServerHelper.isClientWorld(world)) {
            return new ActionResult(EnumActionResult.FAIL, (Object)stack);
        }
        int curLevel = player.field_71068_ca;
        if (player.func_70093_af()) {
            if (ItemExperienceTome.getExtraPlayerExperience(player) > 0) {
                int exp = Math.min(ItemExperienceTome.getTotalExpForLevel(player.field_71068_ca + 1) - ItemExperienceTome.getTotalExpForLevel(player.field_71068_ca) - ItemExperienceTome.getExtraPlayerExperience(player), ItemExperienceTome.getExperience(stack));
                ItemExperienceTome.setPlayerExperience(player, ItemExperienceTome.getPlayerExperience(player) + exp);
                if (player.field_71068_ca < curLevel + 1 && ItemExperienceTome.getPlayerExperience(player) >= ItemExperienceTome.getTotalExpForLevel(curLevel + 1)) {
                    ItemExperienceTome.setPlayerLevel(player, curLevel + 1);
                }
                ItemExperienceTome.modifyExperience(stack, -exp);
            } else {
                int exp = Math.min(ItemExperienceTome.getTotalExpForLevel(player.field_71068_ca + 1) - ItemExperienceTome.getTotalExpForLevel(player.field_71068_ca), ItemExperienceTome.getExperience(stack));
                ItemExperienceTome.setPlayerExperience(player, ItemExperienceTome.getPlayerExperience(player) + exp);
                if (player.field_71068_ca < curLevel + 1 && ItemExperienceTome.getPlayerExperience(player) >= ItemExperienceTome.getTotalExpForLevel(curLevel + 1)) {
                    ItemExperienceTome.setPlayerLevel(player, curLevel + 1);
                }
                ItemExperienceTome.modifyExperience(stack, -exp);
            }
        } else if (ItemExperienceTome.getExtraPlayerExperience(player) > 0) {
            int exp = Math.min(ItemExperienceTome.getExtraPlayerExperience(player), ItemExperienceTome.getSpace(stack));
            ItemExperienceTome.setPlayerExperience(player, ItemExperienceTome.getPlayerExperience(player) - exp);
            if (player.field_71068_ca < curLevel) {
                ItemExperienceTome.setPlayerLevel(player, curLevel);
            }
            ItemExperienceTome.modifyExperience(stack, exp);
        } else if (player.field_71068_ca > 0) {
            int exp = Math.min(ItemExperienceTome.getTotalExpForLevel(player.field_71068_ca) - ItemExperienceTome.getTotalExpForLevel(player.field_71068_ca - 1), ItemExperienceTome.getSpace(stack));
            ItemExperienceTome.setPlayerExperience(player, ItemExperienceTome.getPlayerExperience(player) - exp);
            if (player.field_71068_ca < curLevel - 1) {
                ItemExperienceTome.setPlayerLevel(player, curLevel - 1);
            }
            ItemExperienceTome.modifyExperience(stack, exp);
        }
        return new ActionResult(EnumActionResult.FAIL, (Object)stack);
    }

    public static int getPlayerExperience(EntityPlayer player) {
        return ItemExperienceTome.getTotalExpForLevel(player.field_71068_ca) + ItemExperienceTome.getExtraPlayerExperience(player);
    }

    public static int getLevelPlayerExperience(EntityPlayer player) {
        return ItemExperienceTome.getTotalExpForLevel(player.field_71068_ca);
    }

    public static int getExtraPlayerExperience(EntityPlayer player) {
        return Math.round(player.field_71106_cc * (float)player.func_71050_bK());
    }

    public static void setPlayerExperience(EntityPlayer player, int exp) {
        player.field_71068_ca = 0;
        player.field_71106_cc = 0.0f;
        player.field_71067_cb = 0;
        ItemExperienceTome.addExperienceToPlayer(player, exp);
    }

    public static void setPlayerLevel(EntityPlayer player, int level) {
        player.field_71068_ca = level;
        player.field_71106_cc = 0.0f;
    }

    public static void addExperienceToPlayer(EntityPlayer player, int exp) {
        int i = Integer.MAX_VALUE - player.field_71067_cb;
        if (exp > i) {
            exp = i;
        }
        player.field_71106_cc += (float)exp / (float)player.func_71050_bK();
        player.field_71067_cb += exp;
        while (player.field_71106_cc >= 1.0f) {
            player.field_71106_cc = (player.field_71106_cc - 1.0f) * (float)player.func_71050_bK();
            ItemExperienceTome.addExperienceLevelToPlayer(player, 1);
            player.field_71106_cc /= (float)player.func_71050_bK();
        }
    }

    public static void addExperienceLevelToPlayer(EntityPlayer player, int levels) {
        player.field_71068_ca += levels;
        if (player.field_71068_ca < 0) {
            player.field_71068_ca = 0;
            player.field_71106_cc = 0.0f;
            player.field_71067_cb = 0;
        }
    }

    public static int getTotalExpForLevel(int level) {
        return level >= 32 ? (9 * level * level - 325 * level + 4440) / 2 : (level >= 17 ? (5 * level * level - 81 * level + 720) / 2 : level * level + 6 * level);
    }

    public static int modifyExperience(ItemStack stack, int exp) {
        int storedExp = ItemExperienceTome.getExperience(stack) + exp;
        if (storedExp > ItemExperienceTome.getMaxExperience(stack)) {
            storedExp = ItemExperienceTome.getMaxExperience(stack);
        } else if (storedExp < 0) {
            storedExp = 0;
        }
        stack.func_77978_p().func_74768_a("Experience", storedExp);
        return storedExp;
    }

    public static int getExperience(ItemStack stack) {
        if (!stack.func_77942_o()) {
            stack.func_77982_d(new NBTTagCompound());
        }
        return stack.func_77978_p().func_74762_e("Experience");
    }

    public static int getMaxExperience(ItemStack stack) {
        return CAPACITY;
    }

    public static int getSpace(ItemStack stack) {
        return ItemExperienceTome.getMaxExperience(stack) - ItemExperienceTome.getExperience(stack);
    }
}

