/*
 * Decompiled with CFR 0.152.
 */
package com.zeitheron.hammercore.utils;

import com.zeitheron.hammercore.HammerCore;
import com.zeitheron.hammercore.annotations.MCFBus;
import com.zeitheron.hammercore.client.PerUserModule;
import com.zeitheron.hammercore.client.UserModule;
import com.zeitheron.hammercore.utils.EnumSide;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraftforge.fml.common.discovery.ASMDataTable;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class AnnotatedInstanceUtil {
    public static <T> List<Class<? extends T>> getTypes(@Nonnull ASMDataTable asmDataTable, Class annotationClass, Class<T> typeClass) {
        String annotationClassName = annotationClass.getCanonicalName();
        Set asmDatas = asmDataTable.getAll(annotationClassName);
        ArrayList<Class<T>> instances = new ArrayList<Class<T>>();
        for (ASMDataTable.ASMData asmData : asmDatas) {
            try {
                Class<?> asmClass = Class.forName(asmData.getClassName());
                if (!typeClass.isAssignableFrom(asmClass)) continue;
                instances.add(asmClass.asSubclass(typeClass));
            }
            catch (Throwable throwable) {}
        }
        return instances;
    }

    public static <T> List<T> getInstances(@Nonnull ASMDataTable asmDataTable, Class annotationClass, Class<T> instanceClass) {
        String annotationClassName = annotationClass.getCanonicalName();
        Set asmDatas = asmDataTable.getAll(annotationClassName);
        ArrayList<T> instances = new ArrayList<T>();
        for (ASMDataTable.ASMData asmData : asmDatas) {
            try {
                Class<?> asmClass = Class.forName(asmData.getClassName());
                if (!instanceClass.isAssignableFrom(asmClass)) continue;
                Class<T> asmInstanceClass = asmClass.asSubclass(instanceClass);
                T instance = asmInstanceClass.newInstance();
                instances.add(instance);
            }
            catch (Throwable throwable) {}
        }
        return instances;
    }

    public static <T> List<T> getMCFBInstances(@Nonnull ASMDataTable asmDataTable, EnumSide side, Class<T> instanceClass) {
        String annotationClassName = MCFBus.class.getCanonicalName();
        Set asmDatas = asmDataTable.getAll(annotationClassName);
        ArrayList<T> instances = new ArrayList<T>();
        for (ASMDataTable.ASMData asmData : asmDatas) {
            try {
                Class<?> asmClass = Class.forName(asmData.getClassName());
                if (!asmClass.getAnnotation(MCFBus.class).side().sideEqual(side)) continue;
                Class<T> asmInstanceClass = asmClass.asSubclass(instanceClass);
                T instance = asmInstanceClass.newInstance();
                instances.add(instance);
            }
            catch (Throwable throwable) {}
        }
        return instances;
    }

    @SideOnly(value=Side.CLIENT)
    public static PerUserModule getUserModule(@Nonnull ASMDataTable asmDataTable) {
        String username = Minecraft.func_71410_x().func_110432_I().func_111285_a();
        HammerCore.LOG.info("Guessing username.... You are " + username + ", aren't you?");
        String annotationClassName = UserModule.class.getCanonicalName();
        Set asmDatas = asmDataTable.getAll(annotationClassName);
        for (ASMDataTable.ASMData asmData : asmDatas) {
            try {
                Class<?> asmClass = Class.forName(asmData.getClassName());
                if (!PerUserModule.class.isAssignableFrom(asmClass) || !username.equals(asmClass.getAnnotation(UserModule.class).username())) continue;
                return asmClass.asSubclass(PerUserModule.class).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }
        return new PerUserModule();
    }
}

