/*
 * Decompiled with CFR 0.152.
 */
package com.zeitheron.hammercore.net;

import com.zeitheron.hammercore.HammerCore;
import com.zeitheron.hammercore.net.IPacket;
import com.zeitheron.hammercore.net.PacketHolder;
import com.zeitheron.hammercore.net.internal.PacketParticle;
import com.zeitheron.hammercore.net.internal.PacketSyncMouseStack;
import io.netty.buffer.Unpooled;
import java.lang.reflect.Constructor;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.PacketBuffer;
import net.minecraft.network.play.server.SPacketAnimation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.network.FMLEventChannel;
import net.minecraftforge.fml.common.network.FMLNetworkEvent;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.internal.FMLProxyPacket;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public enum HCNet {
    INSTANCE;

    public final String ch_name = "hammercore2";
    final FMLEventChannel channel = NetworkRegistry.INSTANCE.newEventDrivenChannel("hammercore2");
    private final Map<Class<? extends IPacket>, Supplier<? extends IPacket>> reconstruction = new HashMap<Class<? extends IPacket>, Supplier<? extends IPacket>>();

    @SideOnly(value=Side.CLIENT)
    public static void c_sendToServer(Packet<?> packet) {
        HammerCore.pipelineProxy.sendToServer(packet);
    }

    public static void s_sendTo(Packet<?> packet, EntityPlayerMP player) {
        HammerCore.pipelineProxy.sendTo(packet, player);
    }

    public static void s_sendToDimension(Packet<?> packet, int dim) {
        WorldServer sw;
        MinecraftServer mcs = FMLCommonHandler.instance().getMinecraftServerInstance();
        if (mcs != null && (sw = mcs.func_71218_a(dim)) != null) {
            sw.func_175661_b(EntityPlayerMP.class, p -> !(p instanceof FakePlayer)).forEach(player -> HCNet.s_sendTo(packet, player));
        }
    }

    public static void setMouseStack(EntityPlayer player, ItemStack stack) {
        if (player != null) {
            if (!player.field_70170_p.field_72995_K) {
                INSTANCE.sendTo(new PacketSyncMouseStack(stack), (EntityPlayerMP)player);
            }
            player.field_71071_by.func_70437_b(stack);
        }
    }

    public static ItemStack getMouseStack(EntityPlayer player) {
        return player != null ? player.field_71071_by.func_70445_o() : ItemStack.field_190927_a;
    }

    public static void spawnParticle(World world, EnumParticleTypes particle, double x, double y, double z, double motionX, double motionY, double motionZ, int ... args) {
        PacketParticle pp = new PacketParticle(world, particle, new Vec3d(x, y, z), new Vec3d(motionX, motionY, motionZ), args);
        if (!world.field_72995_K) {
            INSTANCE.sendToAllAround(pp, new NetworkRegistry.TargetPoint(world.field_73011_w.getDimension(), x, y, z, 100.0));
        } else {
            try {
                pp.executeOnClient(null);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    public static void swingArm(EntityPlayer player, EnumHand hand) {
        player.func_184609_a(hand);
        if (player instanceof EntityPlayerMP && !player.field_70170_p.field_72995_K) {
            HCNet.s_sendTo(new SPacketAnimation((Entity)player, hand == EnumHand.MAIN_HAND ? 0 : 3), (EntityPlayerMP)player);
        }
    }

    public void init() {
        this.channel.register((Object)this);
    }

    public <T extends IPacket> void handle(Class<T> t, Supplier<T> nev) {
        this.reconstruction.put(t, nev);
    }

    public <T extends IPacket> T newPacket(Class<T> t) {
        Supplier<? extends IPacket> sup = this.reconstruction.get(t);
        if (sup != null) {
            return (T)sup.get();
        }
        try {
            Constructor<T> c = t.getDeclaredConstructor(new Class[0]);
            c.setAccessible(true);
            return (T)((IPacket)c.newInstance(new Object[0]));
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    public void sendToAll(IPacket packet) {
        this.channel.sendToAll(this.wrap(new PacketHolder(packet), null));
    }

    public void sendTo(IPacket packet, EntityPlayerMP player) {
        this.channel.sendTo(this.wrap(new PacketHolder(packet), null), player);
    }

    public void sendToAllAround(IPacket packet, NetworkRegistry.TargetPoint point) {
        this.channel.sendToAllAround(this.wrap(new PacketHolder(packet), null), point);
    }

    public void sendToDimension(IPacket packet, int dimensionId) {
        this.channel.sendToDimension(this.wrap(new PacketHolder(packet), null), dimensionId);
    }

    @SideOnly(value=Side.CLIENT)
    public void sendToServer(IPacket packet) {
        EntityPlayerSP ep = Minecraft.func_71410_x().field_71439_g;
        if (ep != null) {
            this.channel.sendToServer(this.wrap(new PacketHolder(packet, (EntityPlayer)ep), null));
        }
    }

    public static NBTTagCompound writePacket(IPacket packet, NBTTagCompound nbt) {
        if (packet == null) {
            return nbt;
        }
        NBTTagCompound data = new NBTTagCompound();
        packet.writeToNBT(data);
        nbt.func_74782_a("Data", (NBTBase)data);
        nbt.func_74778_a("Class", packet.getClass().getCanonicalName());
        return nbt;
    }

    public static IPacket readPacket(NBTTagCompound nbt) {
        try {
            Class<IPacket> pktc = Class.forName(nbt.func_74779_i("Class")).asSubclass(IPacket.class);
            IPacket pkt = INSTANCE.newPacket(pktc);
            pkt.readFromNBT(nbt.func_74775_l("Data"));
            return pkt;
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    public static NetworkRegistry.TargetPoint point(Entity entity, double range) {
        return HCNet.point(entity.field_70170_p, new Vec3d(entity.field_70165_t + (double)(entity.field_70130_N / 2.0f), entity.field_70163_u + (double)(entity.field_70131_O / 2.0f), entity.field_70161_v + (double)(entity.field_70130_N / 2.0f)), range);
    }

    public static NetworkRegistry.TargetPoint point(World world, Vec3d pos, double range) {
        return new NetworkRegistry.TargetPoint(world.field_73011_w.getDimension(), pos.field_72450_a, pos.field_72448_b, pos.field_72449_c, range);
    }

    private FMLProxyPacket wrap(PacketHolder pkt, Side target) {
        return this.wrap(pkt, target, null);
    }

    private FMLProxyPacket wrap(PacketHolder pkt, Side target, @Nullable FMLProxyPacket origin) {
        PacketBuffer buf = new PacketBuffer(Unpooled.buffer());
        buf.func_150786_a(pkt.writeToNBT(new NBTTagCompound()));
        FMLProxyPacket fmlpp = new FMLProxyPacket(buf, "hammercore2");
        if (origin != null) {
            fmlpp.setDispatcher(origin.getDispatcher());
        }
        if (target != null) {
            fmlpp.setTarget(target);
        }
        return fmlpp;
    }

    private PacketHolder unwrap(FMLProxyPacket pkt) {
        PacketBuffer payload = new PacketBuffer(pkt.payload());
        NBTTagCompound nbt = null;
        try {
            nbt = payload.func_150793_b();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        payload.release();
        return nbt != null ? new PacketHolder(nbt) : null;
    }

    @SubscribeEvent
    public void packetToClient(FMLNetworkEvent.ClientCustomPacketEvent e) {
        FMLProxyPacket fmlpp = e.getPacket();
        PacketHolder pkt = this.unwrap(fmlpp);
        NetworkManager networker = e.getManager();
        Runnable task = () -> {
            PacketHolder reply = pkt.execute(e);
            if (reply != null && reply.packet != null) {
                networker.func_179290_a((Packet)this.wrap(reply, this.oppositeSide(e.side()), fmlpp));
            }
        };
        if (pkt.enforceMainThread()) {
            HammerCore.pipelineProxy.runFromMainThread(e.side(), task);
        } else {
            task.run();
        }
    }

    @SubscribeEvent
    public void packetToServer(FMLNetworkEvent.ServerCustomPacketEvent e) {
        FMLProxyPacket fmlpp = e.getPacket();
        PacketHolder pkt = this.unwrap(fmlpp);
        NetworkManager networker = e.getManager();
        Runnable task = () -> {
            PacketHolder reply = pkt.execute(e);
            if (reply != null && reply.packet != null) {
                networker.func_179290_a((Packet)this.wrap(reply, this.oppositeSide(e.side()), fmlpp));
            }
        };
        if (pkt.enforceMainThread()) {
            HammerCore.pipelineProxy.runFromMainThread(e.side(), task);
        } else {
            task.run();
        }
    }

    private Side oppositeSide(Side s) {
        return s == Side.CLIENT ? Side.SERVER : Side.CLIENT;
    }
}

