/*
 * Decompiled with CFR 0.152.
 */
package com.zeitheron.hammercore.internal.blocks.multipart;

import com.zeitheron.hammercore.api.handlers.IHandlerProvider;
import com.zeitheron.hammercore.api.handlers.ITileHandler;
import com.zeitheron.hammercore.api.multipart.IRandomDisplayTick;
import com.zeitheron.hammercore.api.multipart.MultipartSignature;
import com.zeitheron.hammercore.tile.TileSyncableTickable;
import com.zeitheron.hammercore.utils.base.Cast;
import com.zeitheron.hammercore.utils.math.vec.Cuboid6;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import java.util.Set;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class TileMultipart
extends TileSyncableTickable
implements IHandlerProvider {
    private Set<MultipartSignature> signatures = new HashSet<MultipartSignature>();
    private Cuboid6[] lastBaked = null;
    private boolean hasSyncedOnce = false;
    private List<MultipartSignature> renderSignatures = new ArrayList<MultipartSignature>();
    private Set<IRandomDisplayTick> displayTickable = new HashSet<IRandomDisplayTick>();
    private int lastPlayerCount = 0;
    private int ticksEmpty = 0;
    int syncSignatureCount;

    @Override
    public void tick() {
        for (MultipartSignature signature : this.signatures()) {
            if (signature.getOwner() != this) {
                this.removeMultipart(signature, false);
                return;
            }
            signature.setWorld(this.field_145850_b);
            signature.setPos(this.field_174879_c);
            if (!(signature instanceof ITickable)) continue;
            ((ITickable)signature).func_73660_a();
        }
        if (!this.field_145850_b.field_72995_K && this.signatures().isEmpty()) {
            this.field_145850_b.func_175698_g(this.field_174879_c);
        }
        if (!this.field_145850_b.field_72995_K && this.ticksExisted > 40 && this.hasSyncedOnce) {
            List players = this.field_145850_b.func_72872_a(EntityPlayerMP.class, new AxisAlignedBB(this.field_174879_c).func_72321_a(4.0, 4.0, 4.0));
            if (this.lastPlayerCount == -1 || this.lastPlayerCount != players.size()) {
                this.sync();
            }
            this.lastPlayerCount = players.size();
        }
        if (!this.hasSyncedOnce && !this.field_145850_b.field_72995_K) {
            this.ticksExisted = 0;
            this.hasSyncedOnce = true;
            this.lastPlayerCount = -1;
        }
        if (this.ticksExisted % 40 == 0) {
            this.lastBaked = null;
        }
    }

    @Override
    public void sync() {
        super.sync();
        this.lastBaked = this.bakeCuboids();
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void onPreSync(NBTTagCompound nbt) {
        this.syncSignatureCount = this.signatures.size();
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void onSynced() {
        if (this.syncSignatureCount != this.signatures.size()) {
            this.field_145850_b.func_175704_b(this.field_174879_c, this.field_174879_c);
            this.field_145850_b.markAndNotifyBlock(this.field_174879_c, this.field_145850_b.func_175726_f(this.field_174879_c), this.field_145850_b.func_180495_p(this.field_174879_c), this.field_145850_b.func_180495_p(this.field_174879_c), 3);
        }
    }

    public int getWeakPower(EnumFacing side) {
        int power = 0;
        for (MultipartSignature s : this.signatures()) {
            power = Math.max(s.getWeakPower(side), power);
        }
        return power;
    }

    public int getStrongPower(EnumFacing side) {
        int power = 0;
        for (MultipartSignature s : this.signatures()) {
            power = Math.max(s.getStrongPower(side), power);
        }
        return power;
    }

    public List<MultipartSignature> signatures() {
        return this.renderSignatures;
    }

    public boolean onBoxActivated(int boxID, Cuboid6 box, World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        for (MultipartSignature s : this.signatures()) {
            if (s == null || box == null || s.getBoundingBox() == null || !s.getBoundingBox().func_72326_a(box.aabb())) continue;
            return s.onSignatureActivated(worldIn, pos, state, playerIn, hand, facing, hitX, hitY, hitZ);
        }
        return false;
    }

    public int getLightLevel() {
        int max = 0;
        for (MultipartSignature s : this.signatures()) {
            max = Math.max(max, s.getLightLevel());
        }
        return max;
    }

    public void randomDisplayTick(Random rand) {
        for (IRandomDisplayTick rdt : this.displayTickable) {
            rdt.randomDisplayTick(rand);
        }
    }

    @Override
    public void readNBT(NBTTagCompound nbt) {
        if (this.field_145850_b != null && this.field_145850_b.field_72995_K) {
            this.hasSyncedOnce = true;
        }
        this.lastBaked = null;
        this.signatures = new HashSet<MultipartSignature>();
        this.renderSignatures = new ArrayList<MultipartSignature>();
        this.displayTickable = new HashSet<IRandomDisplayTick>();
        NBTTagList list = nbt.func_150295_c("signature", 10);
        for (int i = 0; i < list.func_74745_c(); ++i) {
            this.internal_addMultipart(MultipartSignature.createAndLoadSignature(list.func_150305_b(i), this));
        }
    }

    @Override
    public void writeNBT(NBTTagCompound nbt) {
        NBTTagList list = new NBTTagList();
        for (MultipartSignature s : this.signatures()) {
            NBTTagCompound tag = new NBTTagCompound();
            s.writeSignature(tag);
            list.func_74742_a((NBTBase)tag);
        }
        nbt.func_74782_a("signature", (NBTBase)list);
    }

    public int getNextSignatureIndex() {
        return this.signatures().size();
    }

    public boolean canPlace_def(MultipartSignature signature) {
        AxisAlignedBB aabb = signature.getBoundingBox();
        for (MultipartSignature s : this.signatures()) {
            if (s.getBoundingBox() == null || !s.getBoundingBox().func_72326_a(aabb) || s.isReplaceable() || !s.doesMindCollision(signature.getBoundingBox(), aabb.func_111270_a(signature.getBoundingBox()))) continue;
            return false;
        }
        return true;
    }

    public boolean canPlace(MultipartSignature signature) {
        return signature.canPlaceInto(this);
    }

    public boolean addMultipart(MultipartSignature signature) {
        if (!this.canPlace(signature)) {
            return false;
        }
        this.internal_addMultipart(signature);
        return true;
    }

    private void internal_addMultipart(MultipartSignature signature) {
        signature.setPos(this.field_174879_c);
        signature.setWorld(this.field_145850_b);
        signature.setOwner(this);
        HashSet<MultipartSignature> signs_new = new HashSet<MultipartSignature>(this.signatures);
        signs_new.add(signature);
        this.signatures = signs_new;
        if (signature instanceof IRandomDisplayTick) {
            HashSet<IRandomDisplayTick> ticks = new HashSet<IRandomDisplayTick>(this.displayTickable);
            ticks.add((IRandomDisplayTick)((Object)signature));
            this.displayTickable = ticks;
        }
        this.renderSignatures = new ArrayList<MultipartSignature>(signs_new);
        this.lastBaked = null;
        if (this.field_145850_b != null && !this.field_145850_b.field_72995_K) {
            this.sync();
        }
    }

    public void removeMultipart(MultipartSignature signature, boolean spawnDrop) {
        if (!this.signatures.contains(signature)) {
            return;
        }
        signature.onRemoved(spawnDrop);
        HashSet<MultipartSignature> signs_new = new HashSet<MultipartSignature>(this.signatures);
        signs_new.remove(signature);
        this.signatures = signs_new;
        this.renderSignatures = new ArrayList<MultipartSignature>(this.signatures);
        signature.setOwner(null);
        if (signature instanceof IRandomDisplayTick) {
            HashSet<IRandomDisplayTick> ticks = new HashSet<IRandomDisplayTick>(this.displayTickable);
            ticks.remove(signature);
            this.displayTickable = ticks;
        }
        this.lastBaked = null;
        if (this.field_145850_b != null && !this.field_145850_b.field_72995_K) {
            this.sync();
        }
    }

    public MultipartSignature getSignature(Vec3d pos) {
        if (this.signatures().size() > 100) {
            this.field_145850_b.func_175655_b(this.func_174877_v(), false);
        }
        for (MultipartSignature s : this.signatures()) {
            if (s.getBoundingBox() == null || !s.getBoundingBox().func_189973_a(pos.func_72441_c(-1.0E-4, -1.0E-4, -1.0E-4), pos.func_72441_c(1.0E-4, 1.0E-4, 1.0E-4))) continue;
            return s;
        }
        return null;
    }

    public Cuboid6[] getCuboids() {
        if (this.lastBaked == null) {
            this.lastBaked = this.bakeCuboids();
        }
        return this.lastBaked;
    }

    public Cuboid6[] bakeCuboids() {
        ArrayList<Cuboid6> cubs = new ArrayList<Cuboid6>();
        for (MultipartSignature signature : this.signatures()) {
            cubs.add(new Cuboid6(signature.getBoundingBox()));
        }
        return cubs.toArray(new Cuboid6[0]);
    }

    @Override
    public <T extends ITileHandler> T getHandler(EnumFacing facing, Class<T> handler, Object ... params) {
        for (MultipartSignature signature : this.signatures()) {
            IHandlerProvider provider = Cast.cast(signature, IHandlerProvider.class);
            if (provider == null) continue;
            T h = provider.getHandler(facing, handler, params);
            if (handler == null) continue;
            return h;
        }
        return null;
    }

    @Override
    public <T extends ITileHandler> boolean hasHandler(EnumFacing facing, Class<T> handler, Object ... params) {
        for (MultipartSignature signature : this.signatures()) {
            IHandlerProvider provider = Cast.cast(signature, IHandlerProvider.class);
            if (provider == null || !provider.hasHandler(facing, handler, params)) continue;
            return true;
        }
        return false;
    }
}

