/*
 * Decompiled with CFR 0.152.
 */
package com.zeitheron.hammercore.client.render.shader;

import com.zeitheron.hammercore.client.render.shader.IShaderOperation;
import it.unimi.dsi.fastutil.objects.Object2IntArrayMap;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.function.Function;
import org.lwjgl.opengl.ARBShaderObjects;
import org.lwjgl.opengl.ARBVertexShader;
import org.lwjgl.util.vector.Matrix4f;

@Deprecated
public class ShaderProgram {
    private int programID;
    private final ArrayList<IShaderOperation> ops = new ArrayList();
    Object2IntArrayMap<String> uniforms = new Object2IntArrayMap();
    Object2IntArrayMap<String> attribs = new Object2IntArrayMap();
    Function<String, Integer> getUniform = name -> ARBShaderObjects.glGetUniformLocationARB((int)this.programID, (CharSequence)name);
    Function<String, Integer> getAttrib = name -> ARBVertexShader.glGetAttribLocationARB((int)this.programID, (CharSequence)name);

    public ShaderProgram() {
        this.programID = ARBShaderObjects.glCreateProgramObjectARB();
        if (this.programID == 0) {
            throw new RuntimeException("Unable to allocate shader program object.");
        }
    }

    public void attachShaderOperation(IShaderOperation operation) {
        this.ops.add(operation);
    }

    public void bindShader() {
        ARBShaderObjects.glUseProgramObjectARB((int)this.programID);
    }

    public void freeBindShader() {
        ARBShaderObjects.glUseProgramObjectARB((int)this.programID);
        for (IShaderOperation op : this.ops) {
            op.operate(this);
        }
    }

    public static void unbindShader() {
        ARBShaderObjects.glUseProgramObjectARB((int)0);
    }

    public ShaderProgram attachVert(String resource) {
        return this.attach(35633, resource);
    }

    public ShaderProgram attachFrag(String resource) {
        return this.attach(35632, resource);
    }

    public ShaderProgram attach(int shaderType, String resource) {
        InputStream stream = ShaderProgram.class.getResourceAsStream(resource);
        if (stream == null) {
            throw new RuntimeException("Unable to locate resource: " + resource);
        }
        return this.attach(shaderType, stream);
    }

    public ShaderProgram attach(int shaderType, InputStream stream) {
        if (stream == null) {
            throw new RuntimeException("Invalid shader inputstream");
        }
        int shaderID = 0;
        try {
            shaderID = ARBShaderObjects.glCreateShaderObjectARB((int)shaderType);
            if (shaderID == 0) {
                throw new RuntimeException("Unable to allocate shader object.");
            }
            try {
                ARBShaderObjects.glShaderSourceARB((int)shaderID, (CharSequence)ShaderProgram.asString(stream));
            }
            catch (IOException e) {
                throw new RuntimeException("Error reading inputstream.", e);
            }
            ARBShaderObjects.glCompileShaderARB((int)shaderID);
            if (ARBShaderObjects.glGetObjectParameteriARB((int)shaderID, (int)35713) == 0) {
                throw new RuntimeException("Error compiling shader: " + ShaderProgram.getInfoLog(shaderID));
            }
            ARBShaderObjects.glAttachObjectARB((int)this.programID, (int)shaderID);
        }
        catch (RuntimeException e) {
            ARBShaderObjects.glDeleteObjectARB((int)shaderID);
            throw e;
        }
        return this;
    }

    public ShaderProgram validate() {
        ARBShaderObjects.glLinkProgramARB((int)this.programID);
        if (ARBShaderObjects.glGetObjectParameteriARB((int)this.programID, (int)35714) == 0) {
            throw new RuntimeException("Error linking program: " + ShaderProgram.getInfoLog(this.programID));
        }
        ARBShaderObjects.glValidateProgramARB((int)this.programID);
        if (ARBShaderObjects.glGetObjectParameteriARB((int)this.programID, (int)35715) == 0) {
            throw new RuntimeException("Error validating program: " + ShaderProgram.getInfoLog(this.programID));
        }
        return this;
    }

    public static String asString(InputStream stream) throws IOException {
        String line;
        StringBuilder sb = new StringBuilder();
        BufferedReader bin = new BufferedReader(new InputStreamReader(stream));
        while ((line = bin.readLine()) != null) {
            sb.append(line).append('\n');
        }
        stream.close();
        return sb.toString();
    }

    private static String getInfoLog(int shaderID) {
        return ARBShaderObjects.glGetInfoLogARB((int)shaderID, (int)ARBShaderObjects.glGetObjectParameteriARB((int)shaderID, (int)35716));
    }

    public int getUniformLoc(String name) {
        return (Integer)this.uniforms.computeIfAbsent((Object)name, this.getUniform);
    }

    public int getAttribLoc(String name) {
        return (Integer)this.attribs.computeIfAbsent((Object)name, this.getAttrib);
    }

    public void uniformTexture(String name, int textureIndex) {
        ARBShaderObjects.glUniform1iARB((int)this.getUniformLoc(name), (int)textureIndex);
    }

    public void glVertexAttributeMat4(int loc, Matrix4f matrix2) {
        ARBVertexShader.glVertexAttrib4fARB((int)loc, (float)matrix2.m00, (float)matrix2.m01, (float)matrix2.m02, (float)matrix2.m03);
        ARBVertexShader.glVertexAttrib4fARB((int)(loc + 1), (float)matrix2.m10, (float)matrix2.m11, (float)matrix2.m12, (float)matrix2.m13);
        ARBVertexShader.glVertexAttrib4fARB((int)(loc + 2), (float)matrix2.m20, (float)matrix2.m21, (float)matrix2.m22, (float)matrix2.m23);
        ARBVertexShader.glVertexAttrib4fARB((int)(loc + 3), (float)matrix2.m30, (float)matrix2.m31, (float)matrix2.m32, (float)matrix2.m33);
    }

    public void cleanup() {
        this.ops.clear();
        ARBShaderObjects.glDeleteObjectARB((int)this.programID);
    }

    protected void finalize() throws Throwable {
        this.cleanup();
        super.finalize();
    }
}

