/*
 * Decompiled with CFR 0.152.
 */
package com.zeitheron.expequiv.exp.thaumcraft;

import com.google.common.collect.ImmutableMap;
import com.zeitheron.expequiv.api.IEMCConverter;
import com.zeitheron.expequiv.exp.Expansion;
import com.zeitheron.expequiv.exp.ExpansionReg;
import com.zeitheron.expequiv.exp.thaumcraft.MagicalEMCConverter;
import com.zeitheron.hammercore.cfg.file1132.Configuration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import moze_intel.projecte.api.ProjectEAPI;
import moze_intel.projecte.api.proxy.IConversionProxy;
import moze_intel.projecte.api.proxy.IEMCProxy;
import moze_intel.projecte.api.proxy.ITransmutationProxy;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.api.blocks.BlocksTC;
import thaumcraft.api.items.ItemsTC;

@ExpansionReg(modid="thaumcraft")
public class ExpansionThaumcraft
extends Expansion {
    private final Map<Aspect, Integer> defAspectCosts = new HashMap<Aspect, Integer>();
    public int instabilityMod;

    public ExpansionThaumcraft(String modid, Configuration config, Object[] args) {
        super(modid, config, args);
    }

    @Override
    protected void preInit(Configuration configs) {
        for (Aspect a : Aspect.aspects.values()) {
            this.defAspectCosts.put(a, configs.getCategory("AspectEMC").getIntEntry(a.getName(), 64, 0, Integer.MAX_VALUE).setDescription("Default cost of " + a.getName() + ".").getValue());
        }
        this.instabilityMod = configs.getCategory("Additional").getIntEntry("Instability", 2048, 0, Integer.MAX_VALUE).setDescription("Additional EMC penalty per instability point.").getValue();
    }

    @Override
    protected void addCfgEMC() {
        this.addEMCCfg(128, "Shimmerleaf");
        this.addEMCCfg(256, "Quicksilver");
        this.addEMCCfg(768, "Cinderpearl");
        this.addEMCCfg(512, "Amber");
        this.addEMCCfg(256, "ZombieBrains");
        this.addEMCCfg(131072, "PrimordialPearl");
        this.addEMCCfg(4096, "RareEarths");
        this.addEMCCfg(128, "SalisMundus");
        this.addEMCCfg(32, "VisCrystal");
        this.addEMCCfg(16, "AncientStone");
        this.addEMCCfg(32, "EldritchStone");
        this.addEMCCfg(576, "AlchemicalBrassIngot");
    }

    @Override
    public void postInit(IEMCProxy emcProxy, ITransmutationProxy transmuteProxy) {
        super.postInit(emcProxy, transmuteProxy);
        IConversionProxy conv = ProjectEAPI.getConversionProxy();
        conv.addConversion(1, (Object)BlocksTC.researchTable, (Map)ImmutableMap.of((Object)BlocksTC.tableWood, (Object)1));
        conv.addConversion(1, (Object)ItemsTC.thaumonomicon, (Map)ImmutableMap.of((Object)Blocks.field_150342_X, (Object)1, (Object)ItemsTC.salisMundus, (Object)1));
        conv.addConversion(1, (Object)BlocksTC.crucible, (Map)ImmutableMap.of((Object)Items.field_151066_bu, (Object)1, (Object)ItemsTC.salisMundus, (Object)1));
        conv.addConversion(1, (Object)BlocksTC.arcaneWorkbench, (Map)ImmutableMap.of((Object)BlocksTC.tableWood, (Object)1, (Object)ItemsTC.salisMundus, (Object)1));
        conv.addConversion(1, (Object)BlocksTC.condenserlatticeDirty, (Map)ImmutableMap.of((Object)BlocksTC.condenserlattice, (Object)1));
    }

    public long getVisCrystalCost() {
        return this.getCfgEmc("VisCrystal").getValue();
    }

    public long getPrimordialPearlCost() {
        return this.getCfgEmc("PrimordialPearl").getValue();
    }

    public int getAspectCost(Aspect a) {
        Integer i = this.defAspectCosts.getOrDefault(a, 64);
        return i == null ? 64 : i;
    }

    @Override
    public void registerEMC(IEMCProxy emc) {
        this.addEMC(ItemsTC.nuggets, 10, "RareEarths");
        this.addEMC(ItemsTC.ingots, 2, "AlchemicalBrassIngot");
        this.addEMC(ItemsTC.salisMundus, "SalisMundus");
        this.addEMC(ItemsTC.quicksilver, "Quicksilver");
        this.addEMC(ItemsTC.amber, "Amber");
        this.addEMC(ItemsTC.brain, "ZombieBrains");
        this.addEMC(ItemsTC.primordialPearl, "PrimordialPearl");
        this.addEMC(Item.func_150898_a((Block)BlocksTC.cinderpearl), "Cinderpearl");
        this.addEMC(Item.func_150898_a((Block)BlocksTC.shimmerleaf), "Shimmerleaf");
        this.addEMC(Item.func_150898_a((Block)BlocksTC.stoneAncient), "AncientStone");
        this.addEMC(Item.func_150898_a((Block)BlocksTC.stoneEldritchTile), "EldritchStone");
    }

    @Override
    public void getConverters(List<IEMCConverter> mappers) {
        mappers.add(new MagicalEMCConverter(this));
    }
}

