/*
 * Decompiled with CFR 0.152.
 */
package com.zeitheron.expequiv.exp;

import com.zeitheron.expequiv.ExpandedEquivalence;
import com.zeitheron.expequiv.api.IEMCConverter;
import com.zeitheron.hammercore.cfg.file1132.Configuration;
import java.io.File;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import moze_intel.projecte.api.proxy.IEMCProxy;
import moze_intel.projecte.api.proxy.ITransmutationProxy;
import moze_intel.projecte.impl.EMCProxyImpl;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.ModContainer;

public abstract class Expansion {
    public static final Map<String, List<Class<? extends Expansion>>> EXPANSIONS = new HashMap<String, List<Class<? extends Expansion>>>();
    public final String modid;
    public final Object[] args;
    private final Configuration config;
    protected final Map<String, ConfigEMCValue> cfgEmc = new HashMap<String, ConfigEMCValue>();
    private List<ConfigEMCValue> values;

    public Expansion(String modid, Configuration config, Object[] args) {
        this.config = config;
        this.args = args;
        this.modid = modid;
    }

    protected void addCfgEMC() {
    }

    public ConfigEMCValue getCfgEmc(String id) {
        return this.cfgEmc.get(id);
    }

    protected void addEMCCfg(int base, String id) {
        this.addEMCCfg(base, id, "$");
    }

    protected void addEMCCfg(int base, String id, String name) {
        if (this.values != null) {
            this.values.add(new ConfigEMCValue(base, id, name != null ? (name.equals("$") ? Expansion.splitName(id) : name) : id));
        }
    }

    protected long getCfgEMC(long base, String id, String name) {
        return this.config.getCategory("EMC").getLongEntry(id, base, 0L, Long.MAX_VALUE).setDescription("Base cost for " + name + ". Set to 0 to disable.").getValue();
    }

    private static String splitName(String str) {
        StringBuilder sb = new StringBuilder();
        for (char c : str.toCharArray()) {
            if (Character.toUpperCase(c) == c && Character.toLowerCase(c) != c && sb.length() > 0 && sb.charAt(sb.length() - 1) != ' ') {
                sb.append(' ');
            }
            sb.append(c);
        }
        return sb.toString();
    }

    public Configuration getConfig() {
        return this.config;
    }

    public static void registerExpansion(String modid, Class<? extends Expansion> cl) {
        List<Class<? extends Expansion>> exps = EXPANSIONS.get(modid);
        if (exps == null || !(exps instanceof ArrayList)) {
            exps = new ArrayList<Class<? extends Expansion>>();
            EXPANSIONS.put(modid, exps);
        }
        if (!exps.contains(cl)) {
            exps.add(cl);
        }
    }

    public static List<Expansion> createExpansionList(File dir, Object ... args) {
        ArrayList<Expansion> exps = new ArrayList<Expansion>();
        List loadedMods = EXPANSIONS.keySet().stream().filter(Loader::isModLoaded).collect(Collectors.toList());
        for (String modid : loadedMods) {
            List<Class<? extends Expansion>> classes = EXPANSIONS.get(modid);
            for (Class<? extends Expansion> c : classes) {
                try {
                    ExpandedEquivalence.LOG.info("Creating expansion " + c.getName() + " for mod " + modid + " (" + ((ModContainer)Loader.instance().getIndexedModList().get(modid)).getName() + ")");
                    Constructor<? extends Expansion> exp = c.getConstructor(String.class, Configuration.class, Object[].class);
                    exp.setAccessible(true);
                    File subMod = new File(dir, modid);
                    if (!subMod.isDirectory()) {
                        subMod.mkdir();
                    }
                    File cfgFile = new File(subMod, c.getSimpleName() + ".cfg");
                    Configuration cfg = new Configuration(cfgFile);
                    Expansion ex = exp.newInstance(modid, cfg, args);
                    boolean b = ex.getConfig().getCategory("Base").getBooleanEntry("Enabled", true).setDescription("Enable this part of ExpandedEquivalence").getValue();
                    if (cfg.hasChanged()) {
                        cfg.save();
                    }
                    if (!b) continue;
                    exps.add(ex);
                }
                catch (Throwable err) {
                    ExpandedEquivalence.LOG.error("Failed to create new expansion instance for class " + c.getName(), err);
                }
            }
        }
        return exps;
    }

    public final void preInit$(Configuration configs) {
        ArrayList<ConfigEMCValue> emcs = new ArrayList<ConfigEMCValue>();
        this.values = emcs;
        this.addCfgEMC();
        this.values = null;
        emcs.forEach(c -> this.cfgEmc.put(c.id, (ConfigEMCValue)c));
        this.cfgEmc.values().forEach(c -> ((ConfigEMCValue)c).value = this.getCfgEMC(c.base, c.id, c.name));
        this.preInit(configs);
    }

    protected void preInit(Configuration configs) {
    }

    public void init() {
    }

    public void postInit(IEMCProxy emcProxy, ITransmutationProxy transmutateProxy) {
        this.registerEMC(emcProxy);
    }

    public void registerEMC(IEMCProxy emcProxy) {
    }

    protected boolean addEMC(Item item, String id) {
        return this.addEMC(item, 0, id);
    }

    protected boolean addEMC(Item item, int meta, String id) {
        boolean add = this.cfgEmc.containsKey(id);
        if (add) {
            EMCProxyImpl.instance.registerCustomEMC(new ItemStack(item, 1, meta), this.cfgEmc.get(id).getValue());
        }
        return add;
    }

    public void getConverters(List<IEMCConverter> mappers) {
    }

    public static class ConfigEMCValue {
        final long base;
        final String id;
        final String name;
        private long value;

        ConfigEMCValue(long base, String id, String name) {
            this.base = base;
            this.id = id;
            this.name = name;
            this.value = base;
        }

        public long getValue() {
            return this.value;
        }
    }
}

