/*
 * Decompiled with CFR 0.152.
 */
package com.zeitheron.expequiv;

import com.zeitheron.expequiv.api.IEMC;
import com.zeitheron.expequiv.api.IEMCConverter;
import com.zeitheron.expequiv.exp.Expansion;
import com.zeitheron.expequiv.exp.ExpansionReg;
import com.zeitheron.hammercore.HammerCore;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import moze_intel.projecte.api.ProjectEAPI;
import moze_intel.projecte.impl.EMCProxyImpl;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.event.FMLConstructionEvent;
import net.minecraftforge.fml.common.event.FMLFingerprintViolationEvent;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.EventBus;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(modid="expequiv", name="Expanded Equivalence", version="13r", certificateFingerprint="4d7b29cd19124e986da685107d16ce4b49bc0a97", dependencies="required-after:hammercore@[2.0.4.8,);required-after:projecte", updateJSON="https://dccg.herokuapp.com/api/fmluc/295222", acceptedMinecraftVersions="[1.12.2]")
public class ExpandedEquivalence {
    public List<Expansion> expansions;
    @Mod.Instance
    public static ExpandedEquivalence instance;
    public static final Logger LOG;

    @Mod.EventHandler
    public void certificateViolation(FMLFingerprintViolationEvent e) {
        LOG.warn("*****************************");
        LOG.warn("WARNING: Somebody has been tampering with ExpandedEquivalence jar!");
        LOG.warn("It is highly recommended that you redownload mod from https://www.curseforge.com/projects/295222 !");
        LOG.warn("*****************************");
        HammerCore.invalidCertificates.put("expequiv", "https://www.curseforge.com/projects/295222");
    }

    @Mod.EventHandler
    public void construct(FMLConstructionEvent e) {
    }

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent e) {
        ArrayList annotated = new ArrayList();
        Set asmDatas = e.getAsmData().getAll(ExpansionReg.class.getCanonicalName());
        asmDatas.forEach(asm -> {
            if (Loader.isModLoaded((String)asm.getAnnotationInfo().get("modid").toString())) {
                try {
                    Class<?> cl = Class.forName(asm.getClassName());
                    ExpansionReg reg = cl.getAnnotation(ExpansionReg.class);
                    if (reg != null && Expansion.class.isAssignableFrom(cl)) {
                        Class<Expansion> acl = cl.asSubclass(Expansion.class);
                        annotated.add(acl);
                        Expansion.registerExpansion(reg.modid(), acl);
                    }
                }
                catch (Throwable er) {
                    if (er instanceof NoClassDefFoundError || er instanceof ClassNotFoundException) {
                        return;
                    }
                    er.printStackTrace();
                }
            }
        });
        LOG.info("Registered " + annotated.size() + " new possible expansions based off @ExpansionReg:");
        for (Class c : annotated) {
            LOG.info("  " + c.getName());
        }
        File cfgDir = e.getSuggestedConfigurationFile();
        String path = cfgDir.getAbsolutePath();
        File cfgsDir = new File(path = path.substring(0, path.lastIndexOf(File.separator)), "Expanded Equivalence");
        if (!cfgsDir.isDirectory()) {
            cfgsDir.mkdirs();
        }
        this.expansions = Expansion.createExpansionList(cfgsDir, "expequiv", "Expanded Equivalence", "13r");
        LOG.info("Created " + this.expansions.size() + " expansions.");
        this.expansions.forEach(ex -> {
            ex.preInit$(ex.getConfig());
            if (ex.getConfig().hasChanged()) {
                ex.getConfig().save();
            }
        });
        this.expansions.forEach(arg_0 -> ((EventBus)MinecraftForge.EVENT_BUS).register(arg_0));
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent e) {
        this.expansions.forEach(ex -> ex.init());
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent evt) {
        this.expansions.forEach(ex -> ex.postInit(EMCProxyImpl.instance, ProjectEAPI.getTransmutationProxy()));
        ExpandedEquivalence.instance.expansions.forEach(ex -> {
            ArrayList<IEMCConverter> mappers = new ArrayList<IEMCConverter>();
            ex.getConverters(mappers);
            for (IEMCConverter m : mappers) {
                try {
                    m.register(IEMC.PE_WRAPPER, ex.getConfig());
                    LOG.info("Collected EMC convertions from " + m.getClass().getName());
                }
                catch (Throwable err) {
                    LOG.fatal("Exception while gathering EMC convertions from converter " + m.getClass().getName() + ". PLEASE REPORT THIS! EMC VALUES MIGHT BE INCONSISTENT!", err);
                }
            }
        });
    }

    static {
        LOG = LogManager.getLogger((String)"expequiv");
    }
}

