/*
 * Decompiled with CFR 0.152.
 */
package wanion.unidict.integration;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import mods.railcraft.api.crafting.Crafters;
import mods.railcraft.api.crafting.IBlastFurnaceCrafter;
import mods.railcraft.api.crafting.IOutputEntry;
import mods.railcraft.api.crafting.IRockCrusherCrafter;
import mods.railcraft.api.crafting.IRollingMachineCrafter;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.ShapedRecipes;
import net.minecraft.item.crafting.ShapelessRecipes;
import wanion.unidict.integration.AbstractIntegrationThread;

public class RailCraftIntegration
extends AbstractIntegrationThread {
    private Class<?> metalRollingRecipe;
    private Field metalRollingTrueRecipe;
    private Class<?> rockCrusherOutputEntry;
    private Field rockCrusherOutputItem;

    public RailCraftIntegration() {
        super("Rail Craft");
        try {
            this.metalRollingRecipe = Class.forName("mods.railcraft.common.util.crafting.RollingMachineCrafter$RollingRecipe");
            this.metalRollingTrueRecipe = this.metalRollingRecipe.getDeclaredField("recipe");
            this.metalRollingTrueRecipe.setAccessible(true);
            this.rockCrusherOutputEntry = Class.forName("mods.railcraft.common.util.crafting.RockCrusherCrafter$OutputEntry");
            this.rockCrusherOutputItem = this.rockCrusherOutputEntry.getDeclaredField("output");
            this.rockCrusherOutputItem.setAccessible(true);
        }
        catch (ClassNotFoundException | NoSuchFieldException e) {
            this.logger.error("Could not find railcraft field!");
            e.printStackTrace();
        }
    }

    public String call() {
        this.fixBlastFurnaceRecipes();
        if (this.metalRollingRecipe != null && this.metalRollingTrueRecipe != null) {
            try {
                this.fixMetalRollingRecipes();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        }
        if (this.rockCrusherOutputEntry != null && this.rockCrusherOutputItem != null) {
            this.fixRockCrushingRecipes();
        }
        return this.threadName + "The rails seem more viable.";
    }

    private void fixBlastFurnaceRecipes() {
        IBlastFurnaceCrafter iBlastFurnaceCrafter = Crafters.blastFurnace();
        Iterator blastFurnaceRecipeIterator = iBlastFurnaceCrafter.getRecipes().iterator();
        ArrayList<IBlastFurnaceCrafter.IBlastFurnaceRecipeBuilder> newRecipes = new ArrayList<IBlastFurnaceCrafter.IBlastFurnaceRecipeBuilder>();
        while (blastFurnaceRecipeIterator.hasNext()) {
            IBlastFurnaceCrafter.IRecipe recipe = (IBlastFurnaceCrafter.IRecipe)blastFurnaceRecipeIterator.next();
            ItemStack correctOutput = this.resourceHandler.getMainItemStack(recipe.getOutput());
            if (correctOutput == recipe.getOutput()) continue;
            IBlastFurnaceCrafter.IBlastFurnaceRecipeBuilder res = (IBlastFurnaceCrafter.IBlastFurnaceRecipeBuilder)((IBlastFurnaceCrafter.IBlastFurnaceRecipeBuilder)((IBlastFurnaceCrafter.IBlastFurnaceRecipeBuilder)iBlastFurnaceCrafter.newRecipe((Object)recipe.getInput()).name(recipe.getName())).slagOutput(recipe.getSlagOutput()).output(correctOutput)).time(recipe.getTickTime(correctOutput));
            newRecipes.add(res);
            blastFurnaceRecipeIterator.remove();
        }
        newRecipes.forEach(IBlastFurnaceCrafter.IBlastFurnaceRecipeBuilder::register);
    }

    private void fixRockCrushingRecipes() {
        IRockCrusherCrafter iRockCrusherCrafter = Crafters.rockCrusher();
        for (IRockCrusherCrafter.IRecipe recipe : iRockCrusherCrafter.getRecipes()) {
            for (IOutputEntry output : recipe.getOutputs()) {
                if (!this.rockCrusherOutputEntry.isInstance(output)) continue;
                try {
                    this.rockCrusherOutputItem.set(output, this.resourceHandler.getMainItemStack((ItemStack)this.rockCrusherOutputItem.get(output)));
                }
                catch (IllegalAccessException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private void fixMetalRollingRecipes() throws IllegalAccessException {
        IRollingMachineCrafter iRollingMachineCrafter = Crafters.rollingMachine();
        ArrayList<IRollingMachineCrafter.IRollingRecipe> toRemove = new ArrayList<IRollingMachineCrafter.IRollingRecipe>();
        List recipes = iRollingMachineCrafter.getRecipes();
        for (IRollingMachineCrafter.IRollingRecipe recipe : new ArrayList(recipes)) {
            ItemStack correctOutput = this.resourceHandler.getMainItemStack(recipe.func_77571_b());
            if (correctOutput == recipe.func_77571_b() || !this.metalRollingRecipe.isInstance(recipe)) continue;
            IRecipe trueRecipe = (IRecipe)this.metalRollingTrueRecipe.get(recipe);
            IRollingMachineCrafter.IRollingMachineRecipeBuilder newRecipe = (IRollingMachineCrafter.IRollingMachineRecipeBuilder)((IRollingMachineCrafter.IRollingMachineRecipeBuilder)iRollingMachineCrafter.newRecipe(correctOutput).name(correctOutput.toString())).time(recipe.getTickTime());
            if (trueRecipe instanceof ShapedRecipes) {
                ShapedRecipes shapedRecipe = (ShapedRecipes)trueRecipe;
                newRecipe.recipe((IRecipe)new ShapedRecipes(shapedRecipe.func_193358_e(), shapedRecipe.field_77576_b, shapedRecipe.field_77577_c, shapedRecipe.func_192400_c(), correctOutput));
            } else if (trueRecipe instanceof ShapelessRecipes) {
                ShapelessRecipes shapelessRecipe = (ShapelessRecipes)trueRecipe;
                newRecipe.recipe((IRecipe)new ShapelessRecipes(shapelessRecipe.func_193358_e(), correctOutput, shapelessRecipe.func_192400_c()));
            }
            toRemove.add(recipe);
        }
        recipes.removeAll(toRemove);
    }
}

