/*
 * Decompiled with CFR 0.152.
 */
package wanion.unidict.integration;

import gnu.trove.set.TIntSet;
import gnu.trove.set.hash.TIntHashSet;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.Map;
import javax.annotation.Nonnull;
import mekanism.common.recipe.RecipeHandler;
import mekanism.common.recipe.inputs.AdvancedMachineInput;
import mekanism.common.recipe.inputs.DoubleMachineInput;
import mekanism.common.recipe.inputs.GasInput;
import mekanism.common.recipe.inputs.InfusionInput;
import mekanism.common.recipe.inputs.ItemStackInput;
import mekanism.common.recipe.inputs.MachineInput;
import mekanism.common.recipe.inputs.PressurizedInput;
import mekanism.common.recipe.machines.CrystallizerRecipe;
import mekanism.common.recipe.machines.MachineRecipe;
import mekanism.common.recipe.machines.PressurizedRecipe;
import mekanism.common.recipe.machines.SawmillRecipe;
import mekanism.common.recipe.outputs.ChanceOutput;
import mekanism.common.recipe.outputs.ItemStackOutput;
import mekanism.common.recipe.outputs.PressurizedOutput;
import net.minecraft.item.ItemStack;
import wanion.lib.common.MetaItem;
import wanion.unidict.integration.AbstractIntegrationThread;
import wanion.unidict.resource.UniResourceContainer;

final class MekanismIntegration
extends AbstractIntegrationThread {
    MekanismIntegration() {
        super("Mekanism");
    }

    public String call() {
        try {
            this.fixMachineRecipes(RecipeHandler.Recipe.ENERGIZED_SMELTER.get());
            this.fixMachineRecipes(RecipeHandler.Recipe.ENRICHMENT_CHAMBER.get());
            this.fixMachineRecipes(RecipeHandler.Recipe.CRUSHER.get());
            this.fixMachineRecipes(RecipeHandler.Recipe.COMBINER.get());
            this.fixMachineRecipes(RecipeHandler.Recipe.CHEMICAL_INJECTION_CHAMBER.get());
            this.fixMachineRecipes(RecipeHandler.Recipe.METALLURGIC_INFUSER.get());
            this.fixSawmillRecipes(RecipeHandler.Recipe.PRECISION_SAWMILL.get());
            this.fixCrystallizerRecipes(RecipeHandler.Recipe.CHEMICAL_CRYSTALLIZER.get());
            this.fixPRCRecipes(RecipeHandler.Recipe.PRESSURIZED_REACTION_CHAMBER.get());
        }
        catch (Exception e) {
            this.logger.error(this.threadName + e);
        }
        return this.threadName + "All the mekanisms were checked.";
    }

    private <I extends MachineInput<I>, R extends MachineRecipe<I, ? extends ItemStackOutput, R>> void fixMachineRecipes(@Nonnull Map<I, R> recipes) {
        HashMap<MachineInput, MachineRecipe> correctRecipes = new HashMap<MachineInput, MachineRecipe>(recipes.size(), 1.0f);
        IdentityHashMap<UniResourceContainer, TIntHashSet> containerMap = new IdentityHashMap<UniResourceContainer, TIntHashSet>();
        Iterator<R> mekanismRecipeIterator = recipes.values().iterator();
        while (mekanismRecipeIterator.hasNext()) {
            ItemStack inputStack;
            MachineRecipe mekanismRecipe = (MachineRecipe)mekanismRecipeIterator.next();
            ItemStack inputItemStack = this.getInputStackFromInput(mekanismRecipe.recipeInput);
            if (inputItemStack == null) continue;
            UniResourceContainer inputContainer = this.resourceHandler.getContainer(inputItemStack);
            UniResourceContainer outputContainer = this.resourceHandler.getContainer(((ItemStackOutput)mekanismRecipe.recipeOutput).output);
            if (outputContainer == null) continue;
            if (inputContainer == null) {
                ((ItemStackOutput)mekanismRecipe.recipeOutput).output = outputContainer.getMainEntry(((ItemStackOutput)mekanismRecipe.recipeOutput).output.func_190916_E());
                continue;
            }
            MachineRecipe correctRecipe = mekanismRecipe.copy();
            ItemStack itemStack = inputStack = this.config.keepOneEntry ? inputContainer.getMainEntry(inputItemStack.func_190916_E()) : inputItemStack.func_77946_l();
            if (!this.config.inputReplacementMekanism && this.config.keepOneEntry) {
                this.setInputStack(correctRecipe.recipeInput, inputStack);
            }
            int inputId = this.config.inputReplacementMekanism ? inputContainer.kind : MetaItem.get((ItemStack)inputStack);
            containerMap.putIfAbsent(outputContainer, new TIntHashSet());
            TIntSet inputKeySet = (TIntSet)containerMap.get(outputContainer);
            if (!inputKeySet.contains(inputId)) {
                inputKeySet.add(inputId);
                if (this.config.inputReplacementMekanism) {
                    this.setInputStack(correctRecipe.recipeInput, inputContainer.getMainEntry(inputItemStack.func_190916_E()));
                    ((ItemStackOutput)correctRecipe.recipeOutput).output = outputContainer.getMainEntry(((ItemStackOutput)mekanismRecipe.recipeOutput).output.func_190916_E());
                } else {
                    ((ItemStackOutput)correctRecipe.recipeOutput).output = outputContainer.getMainEntry(((ItemStackOutput)correctRecipe.recipeOutput).output.func_190916_E());
                }
                correctRecipes.put(correctRecipe.recipeInput, correctRecipe);
            }
            mekanismRecipeIterator.remove();
        }
        recipes.putAll(correctRecipes);
    }

    private <I extends MachineInput<I>> ItemStack getInputStackFromInput(I input) {
        if (input instanceof ItemStackInput) {
            return ((ItemStackInput)input).ingredient;
        }
        if (input instanceof DoubleMachineInput) {
            return ((DoubleMachineInput)input).itemStack;
        }
        if (input instanceof AdvancedMachineInput) {
            return ((AdvancedMachineInput)input).itemStack;
        }
        if (input instanceof InfusionInput) {
            return ((InfusionInput)input).inputStack;
        }
        return null;
    }

    private <I extends MachineInput<I>> void setInputStack(I input, ItemStack itemStack) {
        if (input instanceof ItemStackInput) {
            ((ItemStackInput)input).ingredient = itemStack;
        } else if (input instanceof DoubleMachineInput) {
            ((DoubleMachineInput)input).itemStack = itemStack;
        } else if (input instanceof AdvancedMachineInput) {
            ((AdvancedMachineInput)input).itemStack = itemStack;
        } else if (input instanceof InfusionInput) {
            ((InfusionInput)input).inputStack = itemStack;
        }
    }

    private void fixSawmillRecipes(@Nonnull Map<ItemStackInput, SawmillRecipe> recipes) {
        HashMap<MachineInput, SawmillRecipe> correctRecipes = new HashMap<MachineInput, SawmillRecipe>(recipes.size(), 1.0f);
        HashMap<SawMillRecipeKey, TIntHashSet> containerMap = new HashMap<SawMillRecipeKey, TIntHashSet>();
        Iterator<SawmillRecipe> mekanismRecipeIterator = recipes.values().iterator();
        while (mekanismRecipeIterator.hasNext()) {
            ItemStack inputStack;
            SawmillRecipe mekanismRecipe = mekanismRecipeIterator.next();
            UniResourceContainer inputContainer = this.resourceHandler.getContainer(((ItemStackInput)mekanismRecipe.recipeInput).ingredient);
            UniResourceContainer primaryOutputContainer = this.resourceHandler.getContainer(((ChanceOutput)mekanismRecipe.recipeOutput).primaryOutput);
            UniResourceContainer secondaryOutputContainer = this.resourceHandler.getContainer(((ChanceOutput)mekanismRecipe.recipeOutput).secondaryOutput);
            if (primaryOutputContainer == null) {
                if (secondaryOutputContainer == null) continue;
                ((ChanceOutput)mekanismRecipe.recipeOutput).secondaryOutput = secondaryOutputContainer.getMainEntry(((ChanceOutput)mekanismRecipe.recipeOutput).secondaryOutput.func_190916_E());
                continue;
            }
            if (inputContainer == null) {
                ((ChanceOutput)mekanismRecipe.recipeOutput).primaryOutput = primaryOutputContainer.getMainEntry(((ChanceOutput)mekanismRecipe.recipeOutput).primaryOutput.func_190916_E());
                if (secondaryOutputContainer == null) continue;
                ((ChanceOutput)mekanismRecipe.recipeOutput).secondaryOutput = secondaryOutputContainer.getMainEntry(((ChanceOutput)mekanismRecipe.recipeOutput).secondaryOutput.func_190916_E());
                continue;
            }
            SawmillRecipe correctRecipe = mekanismRecipe.copy();
            ItemStack itemStack = inputStack = this.config.keepOneEntry ? inputContainer.getMainEntry(((ItemStackInput)correctRecipe.recipeInput).ingredient.func_190916_E()) : ((ItemStackInput)correctRecipe.recipeInput).ingredient.func_77946_l();
            if (!this.config.inputReplacementMekanism && this.config.keepOneEntry) {
                ((ItemStackInput)correctRecipe.recipeInput).ingredient = inputStack;
            }
            int inputId = this.config.inputReplacementMekanism ? inputContainer.kind : MetaItem.get((ItemStack)inputStack);
            SawMillRecipeKey key = new SawMillRecipeKey(primaryOutputContainer, secondaryOutputContainer);
            containerMap.putIfAbsent(key, new TIntHashSet());
            TIntSet inputKeySet = (TIntSet)containerMap.get(key);
            if (!inputKeySet.contains(inputId)) {
                inputKeySet.add(inputId);
                if (this.config.inputReplacementMekanism) {
                    ((ItemStackInput)correctRecipe.recipeInput).ingredient = inputContainer.getMainEntry(((ItemStackInput)correctRecipe.recipeInput).ingredient.func_190916_E());
                    ((ChanceOutput)correctRecipe.recipeOutput).primaryOutput = primaryOutputContainer.getMainEntry(((ChanceOutput)mekanismRecipe.recipeOutput).primaryOutput.func_190916_E());
                    if (secondaryOutputContainer != null) {
                        ((ChanceOutput)correctRecipe.recipeOutput).secondaryOutput = secondaryOutputContainer.getMainEntry(((ChanceOutput)mekanismRecipe.recipeOutput).secondaryOutput.func_190916_E());
                    }
                } else {
                    ((ChanceOutput)correctRecipe.recipeOutput).primaryOutput = primaryOutputContainer.getMainEntry(((ChanceOutput)correctRecipe.recipeOutput).primaryOutput.func_190916_E());
                    if (secondaryOutputContainer != null) {
                        ((ChanceOutput)correctRecipe.recipeOutput).secondaryOutput = secondaryOutputContainer.getMainEntry(((ChanceOutput)correctRecipe.recipeOutput).secondaryOutput.func_190916_E());
                    }
                }
                correctRecipes.put(correctRecipe.recipeInput, correctRecipe);
            }
            mekanismRecipeIterator.remove();
        }
        recipes.putAll(correctRecipes);
    }

    private void fixCrystallizerRecipes(HashMap<GasInput, CrystallizerRecipe> recipes) {
        HashMap<MachineInput, CrystallizerRecipe> correctRecipes = new HashMap<MachineInput, CrystallizerRecipe>(recipes.size(), 1.0f);
        Iterator<CrystallizerRecipe> recipeIterator = recipes.values().iterator();
        while (recipeIterator.hasNext()) {
            CrystallizerRecipe recipe = recipeIterator.next();
            UniResourceContainer outputContainer = this.resourceHandler.getContainer(((ItemStackOutput)recipe.recipeOutput).output);
            if (outputContainer == null) continue;
            CrystallizerRecipe correctRecipe = recipe.copy();
            ((ItemStackOutput)correctRecipe.recipeOutput).output = outputContainer.getMainEntry(((ItemStackOutput)recipe.recipeOutput).output.func_190916_E());
            correctRecipes.put(correctRecipe.recipeInput, correctRecipe);
            recipeIterator.remove();
        }
        recipes.putAll(correctRecipes);
    }

    private void fixPRCRecipes(HashMap<PressurizedInput, PressurizedRecipe> recipes) {
        HashMap<MachineInput, PressurizedRecipe> correctRecipes = new HashMap<MachineInput, PressurizedRecipe>(recipes.size(), 1.0f);
        Iterator<PressurizedRecipe> recipeIterator = recipes.values().iterator();
        while (recipeIterator.hasNext()) {
            PressurizedRecipe recipe = recipeIterator.next();
            ItemStack inputStack = ((PressurizedOutput)recipe.recipeOutput).getItemOutput();
            UniResourceContainer outputContainer = this.resourceHandler.getContainer(inputStack);
            if (outputContainer == null) continue;
            PressurizedRecipe correctRecipe = recipe.copy();
            correctRecipe.recipeOutput = new PressurizedOutput(outputContainer.getMainEntry(inputStack.func_190916_E()), ((PressurizedOutput)recipe.recipeOutput).getGasOutput());
            correctRecipes.put(correctRecipe.recipeInput, correctRecipe);
            recipeIterator.remove();
        }
        recipes.putAll(correctRecipes);
    }

    private static class SawMillRecipeKey {
        private final UniResourceContainer primary;
        private final UniResourceContainer secondary;

        public SawMillRecipeKey(UniResourceContainer primary, UniResourceContainer secondary) {
            this.primary = primary;
            this.secondary = secondary;
        }

        public boolean equals(Object obj) {
            if (obj instanceof SawMillRecipeKey) {
                return this.primary.equals(((SawMillRecipeKey)obj).primary) && this.secondary.equals(((SawMillRecipeKey)obj).secondary);
            }
            return false;
        }

        public int hashCode() {
            return System.identityHashCode(this.primary) + 31 * System.identityHashCode(this.secondary);
        }

        public String toString() {
            return "(" + this.primary + ";" + this.secondary + ")";
        }
    }
}

