/*
 * Decompiled with CFR 0.152.
 */
package wanion.unidict.integration;

import java.io.File;
import java.util.LinkedHashSet;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fml.common.Loader;
import org.apache.commons.lang3.text.WordUtils;
import wanion.lib.module.AbstractModule;
import wanion.unidict.UniDict;
import wanion.unidict.common.Reference;
import wanion.unidict.integration.AE2Integration;
import wanion.unidict.integration.AbstractIntegrationThread;
import wanion.unidict.integration.AbyssalCraftIntegration;
import wanion.unidict.integration.ActuallyAdditionsIntegration;
import wanion.unidict.integration.AdvancedRocketryIntegration;
import wanion.unidict.integration.AdvancedSolarPanelsIntegration;
import wanion.unidict.integration.BaseMetalsIntegration;
import wanion.unidict.integration.BloodMagicIntegration;
import wanion.unidict.integration.ChickensIntegration;
import wanion.unidict.integration.CraftingIntegration;
import wanion.unidict.integration.DraconicEvolutionIntegration;
import wanion.unidict.integration.EmbersIntegration;
import wanion.unidict.integration.EnderIOIntegration;
import wanion.unidict.integration.ForestryIntegration;
import wanion.unidict.integration.ForgeCraftIntegration;
import wanion.unidict.integration.FurnaceIntegration;
import wanion.unidict.integration.GadgetryCoreIntegration;
import wanion.unidict.integration.GadgetryMachinesIntegration;
import wanion.unidict.integration.IC2CIntegration;
import wanion.unidict.integration.IC2Integration;
import wanion.unidict.integration.IEIntegration;
import wanion.unidict.integration.IndustrialForegoingIntegration;
import wanion.unidict.integration.MagneticraftIntegration;
import wanion.unidict.integration.MekanismIntegration;
import wanion.unidict.integration.RailCraftIntegration;
import wanion.unidict.integration.TEIntegration;
import wanion.unidict.integration.TechRebornIntegration;
import wanion.unidict.integration.VillagerIntegration;

public final class IntegrationModule
extends AbstractModule
implements UniDict.IDependency {
    private final Set<Class<AbstractIntegrationThread>> MOD_INTEGRATIONS = new LinkedHashSet<Class<AbstractIntegrationThread>>();

    public IntegrationModule() {
        super("Integration", Class::newInstance);
    }

    public static IntegrationModule getIntegrationModule() {
        return (IntegrationModule)UniDict.getDependencies().get(IntegrationModule.class);
    }

    public void registerIntegration(@Nonnull Class<AbstractIntegrationThread> integrationClassToRegister) {
        this.MOD_INTEGRATIONS.add(integrationClassToRegister);
    }

    protected void init() {
        Configuration config = new Configuration(new File("." + Reference.SLASH + "config" + Reference.SLASH + "unidict" + Reference.SLASH + "IntegrationModule.cfg"));
        for (Integration integration : Integration.values()) {
            if (!config.get("Integrations", WordUtils.capitalizeFully((String)integration.name().replace("_", " ")).replace(" ", ""), integration.enabledByDefault).getBoolean() || integration.modId != null && !Loader.isModLoaded((String)integration.modId) || integration.blackListedModId != null && Loader.isModLoaded((String)integration.blackListedModId)) continue;
            this.manager.add(integration.integrationClass);
        }
        this.MOD_INTEGRATIONS.forEach(arg_0 -> ((AbstractModule.Manager)this.manager).add(arg_0));
        if (config.hasChanged()) {
            config.save();
        }
    }

    private static enum Integration {
        CRAFTING(CraftingIntegration.class),
        FURNACE(FurnaceIntegration.class),
        VILLAGER(VillagerIntegration.class),
        ABYSSAL_CRAFT("abyssalcraft", AbyssalCraftIntegration.class),
        ACTUALLY_ADDITIONS("actuallyadditions", ActuallyAdditionsIntegration.class),
        ADVANCED_ROCKETRY("advancedrocketry", AdvancedRocketryIntegration.class),
        ADVANCED_SOLAR_PANELS("advanced_solar_panels", AdvancedSolarPanelsIntegration.class),
        APPLIED_ENERGISTICS_2("appliedenergistics2", AE2Integration.class),
        BASE_METALS("basemetals", BaseMetalsIntegration.class),
        BLOOD_MAGIC("bloodmagic", BloodMagicIntegration.class),
        CHICKENS("chickens", ChickensIntegration.class),
        EMBERS("embers", EmbersIntegration.class),
        ENDER_IO("enderio", EnderIOIntegration.class),
        FORESTRY("forestry", ForestryIntegration.class),
        FORGE_CRAFT("forgecraft", ForgeCraftIntegration.class),
        GADGETRY_CORE("gadgetrycore", GadgetryCoreIntegration.class),
        GADGETRY_MACHINES("gadgetrymachines", GadgetryMachinesIntegration.class),
        IMMERSIVE_ENGINEERING("immersiveengineering", IEIntegration.class),
        INDUSTRIAL_CRAFT_2("ic2", IC2Integration.class, true, "ic2-classic-spmod"),
        INDUSTRIAL_CRAFT_2_CLASSIC("ic2-classic-spmod", IC2CIntegration.class),
        INDUSTRIAL_FOREGOING("industrialforegoing", IndustrialForegoingIntegration.class),
        MAGNETICRAFT("magneticraft", MagneticraftIntegration.class),
        MEKANISM("mekanism", MekanismIntegration.class),
        RAILCRAFT("railcraft", RailCraftIntegration.class),
        TECH_REBORN("techreborn", TechRebornIntegration.class),
        THERMAL_EXPANSION("thermalexpansion", TEIntegration.class),
        DRACONIC_EVOLUTION("draconicevolution", DraconicEvolutionIntegration.class);

        private final String modId;
        private final String blackListedModId;
        private final Class<? extends AbstractIntegrationThread> integrationClass;
        private final boolean enabledByDefault;

        private Integration(Class<? extends AbstractIntegrationThread> integrationClass) {
            this(null, integrationClass);
        }

        private Integration(String modId, Class<? extends AbstractIntegrationThread> integrationClass) {
            this(modId, integrationClass, true, null);
        }

        private Integration(String modId, @Nullable Class<? extends AbstractIntegrationThread> integrationClass, boolean enabledByDefault, String blackListedModId) {
            this.modId = modId;
            this.integrationClass = integrationClass;
            this.enabledByDefault = enabledByDefault;
            this.blackListedModId = blackListedModId;
        }
    }
}

