/*
 * Decompiled with CFR 0.152.
 */
package wanion.unidict;

import com.google.common.collect.Sets;
import gnu.trove.map.TObjectIntMap;
import gnu.trove.map.hash.THashMap;
import gnu.trove.map.hash.TObjectIntHashMap;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fml.common.Loader;
import wanion.unidict.common.Reference;

public final class Config {
    public static final Config INSTANCE = new Config();
    public final boolean libraryMode;
    public final boolean keepOneEntry;
    public final boolean registerNewCraftingIngredientsAsItemStacks;
    public final Set<String> keepOneEntryModBlackSet;
    public final Set<String> keepOneEntryKindBlackSet;
    public final Set<String> keepOneEntryEntryBlackSet;
    public final boolean keepOneEntryDisableJEIHide;
    public final List<String> itemStacksNamesToIgnore;
    public final List<ItemStack> itemStacksToIgnore = new ArrayList<ItemStack>();
    public final boolean keepOneEntryBlackListsAsWhiteLists;
    public final boolean autoHideInJEI;
    public final Set<String> hideInJEIKindBlackSet;
    public final Set<String> hideInJEIEntryBlackSet;
    public final Set<String> hideInJEIResourceBlackSet;
    public final List<String> hideInJEIItemBlackSet;
    public final boolean kindsDump;
    public final boolean entriesDump;
    public final boolean unifiedEntriesDump;
    public final boolean inputReplacementFurnace;
    public final boolean inputReplacementMekanism;
    public final boolean enableSpecificKindSort;
    public final boolean enableSpecificEntrySort;
    public final TObjectIntMap<String> ownerOfEveryThing;
    public final Set<String> metalsToUnify;
    public final Set<String> childrenOfMetals;
    public final List<String> resourceBlackList;
    public final Set<ResourceLocation> recipesToIgnore;
    public final List<String> furnaceInputsToIgnore;
    public final List<String> furnaceOutputsToIgnore;
    public final Boolean treatRecipesToRemoveAsRegex;
    public final List<String> recipesToRemove;
    public final Set<String> ignoreModIdRecipes;
    public final Map<String, Set<String>> customUnifiedResources;
    public final boolean ieIntegrationDuplicateRemoval;
    public final List<String> userOreDictEntries;
    public final boolean integrationModule;
    public final boolean modConfigModule;
    private final Configuration config;
    private final String resources = "resources";

    private Config() {
        boolean deleted = false;
        this.config = new Configuration(new File("." + Reference.SLASH + "config" + Reference.SLASH + "unidict" + Reference.SLASH + "UniDict" + ".cfg"), "1.12.2-3.0.6");
        try {
            if (!this.config.getDefinedConfigVersion().equals(this.config.getLoadedConfigVersion())) {
                deleted = this.config.getConfigFile().delete();
            }
            String general = "general";
            this.libraryMode = this.config.getBoolean("libraryMode", "general", false, "Enable this if you have mods that depend on UniDict but you don't like the unification.");
            this.keepOneEntry = this.config.getBoolean("keepOneEntry", "general", false, "Keep only one entry per ore dictionary entry");
            this.keepOneEntryModBlackSet = Collections.unmodifiableSet(Sets.newHashSet(Arrays.asList(this.config.getStringList("keepOneEntryModBlackList", "general", new String[0], "Mods listed here will be blacklisted in keepOneEntry.\nMust be the exact modID."))));
            this.keepOneEntryKindBlackSet = Collections.unmodifiableSet(Sets.newHashSet(Arrays.asList(this.config.getStringList("keepOneEntryKindBlackList", "general", new String[0], "Kinds listed here will be blacklisted in keepOneEntry.\nMust be the exact kind name."))));
            this.keepOneEntryEntryBlackSet = Collections.unmodifiableSet(Sets.newHashSet(Arrays.asList(this.config.getStringList("keepOneEntryEntryBlackList", "general", new String[0], "Entries listed here will be blacklisted in keepOneEntry.\nMust be the exact entry name."))));
            this.keepOneEntryBlackListsAsWhiteLists = this.config.getBoolean("keepOneEntryBlackListsAsWhiteLists", "general", false, "Enable this if you want the keepOneEntry blacklist to became a whitelist.\nNote: This doesn't applies for \"S:keepOneEntryModBlackList\"");
            this.keepOneEntryDisableJEIHide = this.config.getBoolean("keepOneEntryDisableHideFromJEI", "general", false, "Entries blacklisted from keepOneEntry will not be hidden in JEI if enabled.");
            this.itemStacksNamesToIgnore = Arrays.asList(this.config.getStringList("itemStacksNamesToIgnore", "general", new String[0], "ItemStacks that you want to be ignored/not unified.\nExample Format: minecraft:iron_ingot#0"));
            this.registerNewCraftingIngredientsAsItemStacks = this.config.getBoolean("registerNewCraftingIngredientsAsItemStacks", "general", false, "If Enabled, the ingredients of all the new recipes created by Crafting Integration will be registered as ItemStacks.\nEnable this if you don't like the cycling through possibilities in JEI.");
            this.autoHideInJEI = this.config.getBoolean("autoHideInJEI", "general", true, "Automatically hide items in JEI") && Loader.isModLoaded((String)"jei");
            this.hideInJEIKindBlackSet = Collections.unmodifiableSet(Sets.newHashSet(Arrays.asList(this.config.getStringList("autoHideInJEIKindBlackList", "general", new String[]{"ore"}, "Kinds listed here won't be hidden in JEI.\nOnly works if keepOneEntry is false."))));
            this.hideInJEIEntryBlackSet = Collections.unmodifiableSet(Sets.newHashSet(Arrays.asList(this.config.getStringList("autoHideInJEIEntryBlackList", "general", new String[0], "Entries listed here won't be hidden in JEI.\nOnly works if keepOneEntry is false."))));
            this.hideInJEIResourceBlackSet = Collections.unmodifiableSet(Sets.newHashSet(Arrays.asList(this.config.getStringList("autoHideInJEIResourceBlackList", "general", new String[0], "Resources listed here won't be hidden in JEI.\nOnly works if keepOneEntry is false."))));
            this.hideInJEIItemBlackSet = Arrays.asList(this.config.getStringList("autoHideInJEIItemBlackList", "general", new String[0], "ItemStack names listed here won't be hidden in JEI\nExample Format: minecraft:iron_ingot#0"));
            this.kindsDump = this.config.getBoolean("kindsDump", "dump", false, "Enable this to keep track of all the kinds.\nThe output file will be saved in \"config\\unidict\\dump\" folder.\nOnce the file is generated, you must delete it to re-generate.");
            this.entriesDump = this.config.getBoolean("entriesDump", "dump", false, "Enable this to keep track of all the entries.\nThe output file will be saved in \"config\\unidict\\dump\"  folder.\nOnce the file is generated, you must delete it to re-generate.");
            this.unifiedEntriesDump = this.config.getBoolean("unifiedEntriesDump", "dump", false, "Enable this to keep track of all the unified entries.\nThe output file will be saved in \"config\\unidict\\dump\" folder.\nOnce the file is generated, you must delete it to re-generate.");
            this.inputReplacementFurnace = this.config.getBoolean("furnace", "inputReplacement", false, "Enabling this will remove all non-standard items from inputs of the Furnace.");
            this.inputReplacementMekanism = this.config.getBoolean("mekanism", "inputReplacement", false, "Enabling this will remove all non-standard items from inputs of Mekanism Machine Recipes.");
            this.enableSpecificKindSort = this.config.getBoolean("enableSpecificKindSort", "resources", false, "Enabling this allows you to specify the \"owner\" of each kind.\nIt also will make \"S:ownerOfEveryThing\" be ignored for this kind.\nexample: \"ore\"\n");
            this.enableSpecificEntrySort = this.config.getBoolean("enableSpecificEntrySort", "resources", false, "Enabling this allows you to specify the \"owner\" of each entry.\nIt also will make \"S:ownerOfEveryThing\" be ignored for this entry.\nexample: \"ingotIron\"\n");
            this.ownerOfEveryThing = new TObjectIntHashMap(this.getOwnerOfEveryThingMap());
            this.metalsToUnify = Collections.unmodifiableSet(Sets.newHashSet(Arrays.asList(this.config.getStringList("metalsToUnify", "resources", new String[]{"Iron", "Gold", "Copper", "Tin", "Silver", "Lead", "Nickel", "Platinum", "Zinc", "Aluminium", "Aluminum", "Alumina", "Chromium", "Chrome", "Uranium", "Iridium", "Osmium", "Bronze", "Steel", "Brass", "Invar", "Electrum", "Cupronickel", "Constantan"}, "List of Metals to unify.\nNote 1: This will only work for \"metals\"\nNote 2: If your \"metal\" doesn't have an ingot form, check the \"S:customUnifiedResources\" option.\n"))));
            this.childrenOfMetals = Collections.unmodifiableSet(Sets.newHashSet(Arrays.asList(this.config.getStringList("childrenOfMetals", "resources", new String[]{"ore", "dustTiny", "dustSmall", "chunk", "dust", "nugget", "ingot", "block", "plate", "gear", "rod"}, "What kind of children do you want to make standard\n"))));
            this.resourceBlackList = Arrays.asList(this.config.getStringList("resourceBlackList", "resources", new String[]{"Aluminium", "Alumina", "Chrome", "Redstone"}, "Resources to be black-listed.\nThis exists to avoid duplicates.\nThis affects the API."));
            this.recipesToIgnore = new HashSet<ResourceLocation>();
            for (String recipeToIgnore : this.config.getStringList("recipeToIgnoreList", "resources", new String[]{"minecraft:iron_nugget", "minecraft:iron_block", "minecraft:iron_ingot_from_block", "minecraft:iron_ingot_from_nuggets", "minecraft:gold_nugget", "minecraft:gold_ingot_from_block", "minecraft:gold_ingot_from_nuggets", "minecraft:gold_block"}, "Recipe names that you don't want the Crafting Integration to mess with.")) {
                int separator = recipeToIgnore.indexOf(58);
                if (separator <= 0) continue;
                this.recipesToIgnore.add(new ResourceLocation(recipeToIgnore.substring(0, separator), recipeToIgnore.substring(separator + 1)));
            }
            this.furnaceInputsToIgnore = Arrays.asList(this.config.getStringList("furnaceInputsToIgnore", "resources", new String[]{""}, "Input ItemStack (item registry names) that you don't want the Furnace Integration to mess with.\nFormat:\nminecraft:iron_ingot#0"));
            this.furnaceOutputsToIgnore = Arrays.asList(this.config.getStringList("furnaceOutputsToIgnore", "resources", new String[]{""}, "Output ItemStacks (item registry names) that you don't want the Furnace Integration to mess with.\nFormat:\nminecraft:iron_ingot#0"));
            this.ieIntegrationDuplicateRemoval = this.config.getBoolean("ieIntegrationDuplicateRemoval", "integrations", true, "This controls if duplicates are removed in Immersive Engineering Integration.");
            this.treatRecipesToRemoveAsRegex = this.config.getBoolean("treatRecipeToRemoveAsRegex", "resources", false, "This controls whether the recipes in recipeToRemoveList are treated as regular expressions (Regex).");
            this.recipesToRemove = Arrays.asList(this.config.getStringList("recipeToRemoveList", "resources", new String[0], "Recipe names that you want to be removed.\nNote: This will be executed after Crafting Integration.\nNote 2: If there is a space on the end of the recipe, then the recipe name must stay in \"recipename\", this is ONLY required when there is a space on the end \" \""));
            this.ignoreModIdRecipes = new LinkedHashSet<String>(Arrays.asList(this.config.getStringList("ignoreModIdRecipes", "resources", new String[]{"oreshrubs"}, "Crafting Integration will ignore recipes created by the ModIds listed below.\n")));
            this.customUnifiedResources = Collections.unmodifiableMap(this.getCustomUnifiedResourcesMap());
            this.userOreDictEntries = Arrays.asList(this.config.getStringList("userOreDictEntries", "general", new String[0], "This allows to the user to add/remove entries before the unification happen.\nThis is mainly useful to avoid trying to unify certain things.\n\nFormat to Add entries to the OreDictionary:\nweirdStone+minecraft:stone#1\nThe example above will register Granite as weirdStone.\n\nFormat to Remove entries from the OreDictionary:\nweirdStone-minecraft:stone#1\nThe example above will remove Granite from weirdStone."));
            this.integrationModule = this.config.getBoolean("integration", "modules", true, "Integration Module.\nIf false all of the Integrations will be disabled.\n");
            this.modConfigModule = this.config.getBoolean("modConfig", "modules", true, "Mod Config Module.\nIf false UniDict will not modify other mods' configs to achieve unification.\n");
        }
        catch (Exception e) {
            throw new RuntimeException("Something went wrong when loading config file \"" + this.config.getConfigFile() + "\" " + e);
        }
        if (this.config.hasChanged() || deleted) {
            this.config.save();
        }
    }

    public void saveIfHasChanged() {
        if (this.config.hasChanged()) {
            this.config.save();
        }
    }

    private TObjectIntMap<String> getOwnerOfEveryThingMap() {
        String[] ownerOfEveryThing = this.config.getStringList("ownerOfEveryThing", "resources", new String[]{"minecraft", "thermalfoundation", "substratum", "ic2", "mekanism", "immersiveengineering", "techreborn"}, "All the entries will be sorted according to the modID list below\nMust be the exact ModID.\n");
        TObjectIntHashMap ownerOfEveryThingMap = new TObjectIntHashMap(10, 1.0f, Integer.MAX_VALUE);
        for (int i = 0; i < ownerOfEveryThing.length; ++i) {
            ownerOfEveryThingMap.put((Object)ownerOfEveryThing[i], i);
        }
        return ownerOfEveryThingMap;
    }

    private Map<String, Set<String>> getCustomUnifiedResourcesMap() {
        THashMap customUnifiedResources = new THashMap();
        Pattern splitPattern = Pattern.compile("\\|");
        for (String customUnifiedResource : this.config.getStringList("customUnifiedResources", "resources", new String[]{"Obsidian:dustTiny|dust", "Stone:dust", "Obsidian:dust|dustSmall", "Coal:dust|dustSmall", "Sulfur:dust|dustSmall", "Salt:dust"}, "Here you can put a list to custom unifications.\nMust be in this format \"ResourceName:kind1|kind2|...\".")) {
            HashSet kindSet;
            int baseSeparatorIndex = customUnifiedResource.indexOf(58);
            if (baseSeparatorIndex == -1 || (kindSet = Sets.newHashSet(Arrays.asList(splitPattern.split(customUnifiedResource.substring(baseSeparatorIndex + 1))))).isEmpty()) continue;
            customUnifiedResources.put(customUnifiedResource.substring(0, baseSeparatorIndex), kindSet);
        }
        return customUnifiedResources;
    }
}

