/*
 * Decompiled with CFR 0.152.
 */
package com.black_dog20.servertabinfo.utility;

import com.black_dog20.servertabinfo.client.objects.IRenderable;
import com.black_dog20.servertabinfo.utility.ColorObject;
import com.black_dog20.servertabinfo.utility.CompatibilityHelper;
import java.util.ArrayList;
import net.minecraft.client.Minecraft;

public class TpsDimension
implements IRenderable {
    public String name;
    public Double meanTickTime;
    public int Id;
    private int responseVersion;
    private int spacing = 3;

    public TpsDimension(String name, Double meanTickTime) {
        this.name = name;
        this.meanTickTime = meanTickTime;
    }

    public TpsDimension(String name, Double meanTickTiem, int id) {
        this.name = name;
        this.meanTickTime = meanTickTiem;
        this.Id = id;
    }

    public TpsDimension(String name, Double meanTickTime, double responseVersion) {
        this.name = name;
        this.meanTickTime = meanTickTime;
        this.responseVersion = (int)responseVersion;
    }

    public TpsDimension(String name, Double meanTickTiem, int id, double responseVersion) {
        this.name = name;
        this.meanTickTime = meanTickTiem;
        this.Id = id;
        this.responseVersion = (int)responseVersion;
    }

    public String getDimString(int responseVersion) {
        String[] strings = this.getStrings(responseVersion);
        return String.format("%s: %s %s (%s %s)", strings[0], strings[1], strings[2], strings[3], strings[4]);
    }

    public String getShortDimString(int responseVersion) {
        String[] strings = this.getStrings(responseVersion);
        return String.format("%s(%s)", strings[0], strings[3]);
    }

    @Override
    public int getWidth() {
        Minecraft mc = Minecraft.func_71410_x();
        String[] strings = this.getStrings(this.responseVersion);
        int width = 0;
        width += CompatibilityHelper.getStringWidth(mc, strings[0] + ":");
        width += this.spacing;
        width += CompatibilityHelper.getStringWidth(mc, strings[1]);
        width += this.spacing;
        width += CompatibilityHelper.getStringWidth(mc, strings[2]);
        width += this.spacing;
        width += CompatibilityHelper.getStringWidth(mc, String.format("(%s %s)", strings[3], strings[4]));
        return width += 3;
    }

    @Override
    public int getWidthOfElement(int n) {
        return this.getWidthArray()[n];
    }

    @Override
    public int[] getWidthArray() {
        int[] width = new int[4];
        int tempWidth = 0;
        Minecraft mc = Minecraft.func_71410_x();
        String[] strings = this.getStrings(this.responseVersion);
        tempWidth += CompatibilityHelper.getStringWidth(mc, strings[0] + ":");
        width[0] = tempWidth += this.spacing;
        tempWidth = 0;
        tempWidth += CompatibilityHelper.getStringWidth(mc, strings[1]);
        width[1] = tempWidth += this.spacing;
        tempWidth = 0;
        tempWidth += CompatibilityHelper.getStringWidth(mc, strings[2]);
        width[2] = tempWidth += 2 * this.spacing;
        tempWidth = 0;
        tempWidth += CompatibilityHelper.getStringWidth(mc, String.format("(%s %s)", strings[3], strings[4]));
        width[3] = tempWidth += 3;
        tempWidth = 0;
        return width;
    }

    private String[] getStrings(int responseVersion) {
        String nameC;
        ArrayList<String> strings = new ArrayList<String>();
        ColorObject color = new ColorObject(ColorObject.Color.Green);
        int tps = responseVersion >= 2 ? (int)Math.min(1000.0 / (this.meanTickTime * 1.0E-6), 20.0) : (int)Math.min(1000.0 / this.meanTickTime, 20.0);
        if (tps < 20) {
            color = new ColorObject(ColorObject.Color.Yellow);
        }
        if (tps <= 10) {
            color = new ColorObject(ColorObject.Color.Red);
        }
        String tpsValue = CompatibilityHelper.text(Integer.toString(tps), color);
        String mean = CompatibilityHelper.translate("gui.servertabinfo.mean");
        String dim = CompatibilityHelper.translate("gui.servertabinfo.dim");
        String ms = CompatibilityHelper.translate("gui.servertabinfo.ms");
        String tpsText = CompatibilityHelper.translate("gui.servertabinfo.tps");
        String nameT = CompatibilityHelper.translate(dim + " " + Integer.toString(this.Id));
        if (!this.name.equals("") && (nameT = CompatibilityHelper.translate(this.name)).equals(this.name + "\u00c2\u00a7r") && !(nameC = CompatibilityHelper.translate("servertabinfo.dim." + this.name)).equals("servertabinfo.dim." + this.name + "\u00c2\u00a7r")) {
            nameT = nameC;
        }
        strings.add(nameT);
        strings.add(mean);
        if (responseVersion >= 2) {
            strings.add(String.format("%5.2f%s", this.meanTickTime * 1.0E-6, ms));
        } else {
            strings.add(String.format("%5.2f%s", this.meanTickTime, ms));
        }
        strings.add(tpsValue);
        strings.add(tpsText);
        return strings.toArray(new String[0]);
    }

    @Override
    public void render(int x, int y, int width) {
        int leftoverspacing = width - this.getWidth();
        Minecraft mc = Minecraft.func_71410_x();
        String[] strings = this.getStrings(this.responseVersion);
        String s4 = strings[0] + ":";
        CompatibilityHelper.drawStringWithShadow(mc, s4, x, y, -1);
        CompatibilityHelper.drawStringWithShadow(mc, strings[1], x += CompatibilityHelper.getStringWidth(mc, s4) + 2 * this.spacing + leftoverspacing, y, -1);
        CompatibilityHelper.drawStringWithShadow(mc, strings[2], x += CompatibilityHelper.getStringWidth(mc, strings[1]) + this.spacing, y, -1);
        CompatibilityHelper.drawStringWithShadow(mc, String.format("(%s %s)", strings[3], strings[4]), x += CompatibilityHelper.getStringWidth(mc, strings[2]) + this.spacing, y, -1);
    }

    private int calcLeftOverspace(int[] maxWidth, int n) {
        return maxWidth[n] - this.getWidthOfElement(n);
    }

    @Override
    public void render(int x, int y, int[] width) {
        Minecraft mc = Minecraft.func_71410_x();
        String[] strings = this.getStrings(this.responseVersion);
        String s4 = strings[0] + ":";
        CompatibilityHelper.drawStringWithShadow(mc, s4, x, y, -1);
        CompatibilityHelper.drawStringWithShadow(mc, strings[1], x += CompatibilityHelper.getStringWidth(mc, s4) + 2 * this.spacing + this.calcLeftOverspace(width, 0), y, -1);
        CompatibilityHelper.drawStringWithShadow(mc, strings[2], x += CompatibilityHelper.getStringWidth(mc, strings[1]) + this.spacing + this.calcLeftOverspace(width, 1), y, -1);
        CompatibilityHelper.drawStringWithShadow(mc, String.format("(%s %s)", strings[3], strings[4]), x += CompatibilityHelper.getStringWidth(mc, strings[2]) + this.spacing + this.calcLeftOverspace(width, 2), y, -1);
    }
}

