/*
 * Decompiled with CFR 0.152.
 */
package com.black_dog20.servertabinfo.utility;

import com.black_dog20.servertabinfo.ServerTabInfo;
import com.black_dog20.servertabinfo.client.objects.IRenderable;
import com.black_dog20.servertabinfo.utility.CompatibilityHelper;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;

public class RenderHelper {
    public static int RenderList(List<String> list, Minecraft mc, int startTop, int width) {
        if (list != null && !list.isEmpty()) {
            int maxWidth = RenderHelper.findMaxWidthString(list, mc);
            GuiScreen.func_73734_a((int)(width / 2 - maxWidth / 2 - 1), (int)(startTop - 1), (int)(width / 2 + maxWidth / 2 + 1), (int)(startTop + list.size() * CompatibilityHelper.getFontRenderHeight(mc)), (int)Integer.MIN_VALUE);
            for (String string : list) {
                GuiScreen.func_73734_a((int)(width / 2 - maxWidth / 2), (int)startTop, (int)(width / 2 + maxWidth / 2), (int)(startTop + 8), (int)0x20FFFFFF);
                CompatibilityHelper.glListHelper();
                int i2 = CompatibilityHelper.getStringWidth(mc, string);
                CompatibilityHelper.drawStringWithShadow(mc, string, width / 2 - i2 / 2, startTop, -1);
                startTop += CompatibilityHelper.getFontRenderHeight(mc);
            }
        }
        return startTop;
    }

    public static int RenderListAtStartPoint(List<String> list, Minecraft mc, int x, int y) {
        if (list != null && !list.isEmpty()) {
            int maxWidth = RenderHelper.findMaxWidthString(list, mc);
            GuiScreen.func_73734_a((int)x, (int)(y - 1), (int)(x + maxWidth + 3), (int)(y + list.size() * CompatibilityHelper.getFontRenderHeight(mc)), (int)Integer.MIN_VALUE);
            for (String string : list) {
                GuiScreen.func_73734_a((int)(x + 1), (int)y, (int)(x + maxWidth + 2), (int)(y + 8), (int)0x20FFFFFF);
                CompatibilityHelper.glListHelper();
                CompatibilityHelper.drawStringWithShadow(mc, string, (float)x + 2.0f, y, -1);
                y += CompatibilityHelper.getFontRenderHeight(mc);
            }
        }
        return y;
    }

    public static int RenderObjectList(List<IRenderable> list, Minecraft mc, int y, int width) {
        if (list != null && !list.isEmpty()) {
            int maxWidth = RenderHelper.findMaxWidth(list, mc);
            int[] maxWidthArray = RenderHelper.findMaxWidthArray(list, mc);
            if (maxWidthArray == null) {
                return y;
            }
            GuiScreen.func_73734_a((int)(width / 2 - maxWidth / 2 - 1), (int)(y - 1), (int)(width / 2 + maxWidth / 2 + 1), (int)(y + list.size() * CompatibilityHelper.getFontRenderHeight(mc)), (int)Integer.MIN_VALUE);
            for (IRenderable o : list) {
                GuiScreen.func_73734_a((int)(width / 2 - maxWidth / 2), (int)y, (int)(width / 2 + maxWidth / 2), (int)(y + 8), (int)0x20FFFFFF);
                CompatibilityHelper.glListHelper();
                o.render(width / 2 - maxWidth / 2, y, maxWidthArray);
                y += CompatibilityHelper.getFontRenderHeight(mc);
            }
        }
        return y;
    }

    public static int RenderObjectListAtStartPoint(List<IRenderable> list, Minecraft mc, int x, int y) {
        if (list != null && !list.isEmpty()) {
            int maxWidth = RenderHelper.findMaxWidth(list, mc);
            int[] maxWidthArray = RenderHelper.findMaxWidthArray(list, mc);
            if (maxWidthArray == null) {
                return y;
            }
            GuiScreen.func_73734_a((int)x, (int)(y - 1), (int)(x + maxWidth + 3), (int)(y + list.size() * CompatibilityHelper.getFontRenderHeight(mc)), (int)Integer.MIN_VALUE);
            for (IRenderable o : list) {
                GuiScreen.func_73734_a((int)(x + 1), (int)y, (int)(x + maxWidth + 2), (int)(y + 8), (int)0x20FFFFFF);
                CompatibilityHelper.glListHelper();
                o.render(x, y, maxWidthArray);
                y += CompatibilityHelper.getFontRenderHeight(mc);
            }
        }
        return y;
    }

    public static int findMaxWidthString(List<String> list, Minecraft mc) {
        int maxWidth = 0;
        for (String s : list) {
            int i = CompatibilityHelper.getStringWidth(mc, s);
            maxWidth = Math.max(maxWidth, i);
        }
        return maxWidth;
    }

    public static int findMaxWidthString(String[] list, Minecraft mc) {
        int maxWidth = 0;
        for (String s : list) {
            int i = CompatibilityHelper.getStringWidth(mc, s);
            maxWidth = Math.max(maxWidth, i);
        }
        return maxWidth;
    }

    public static int findMaxWidth(List<IRenderable> list, Minecraft mc) {
        int maxWidth = 0;
        for (IRenderable s : list) {
            int i = s.getWidth();
            maxWidth = Math.max(maxWidth, i);
        }
        return maxWidth;
    }

    public static int[] findMaxWidthArray(List<IRenderable> list, Minecraft mc) {
        int[] maxWidth = null;
        for (IRenderable s : list) {
            if (maxWidth == null) {
                maxWidth = s.getWidthArray();
            }
            int[] i = s.getWidthArray();
            for (int n = 0; n < maxWidth.length; ++n) {
                maxWidth[n] = Math.max(maxWidth[n], i[n]);
            }
        }
        return maxWidth;
    }

    public static List<IRenderable> getPage(int page, int itemPerPage, List<IRenderable> input) {
        int first = (page - 1) * itemPerPage;
        if (first > input.size()) {
            first = input.size() - itemPerPage;
        }
        if (first < 0) {
            first = 0;
        }
        try {
            return input.stream().skip(first).limit(itemPerPage).collect(Collectors.toList());
        }
        catch (Exception e) {
            ServerTabInfo.logger.error(String.format("%s at getPage with page=%d, itemPerPage=%d, input.size=%d, skip=%d", e.getClass().getName(), page, itemPerPage, input.size(), first));
            return new ArrayList<IRenderable>();
        }
    }
}

