/*
 * Decompiled with CFR 0.152.
 */
package com.black_dog20.servertabinfo.network.message;

import com.black_dog20.servertabinfo.client.GuiTabPage;
import com.black_dog20.servertabinfo.utility.TpsDimension;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class MessageResponseServerInfo
implements IMessage,
IMessageHandler<MessageResponseServerInfo, IMessage> {
    private int version;
    private List<TpsDimension> dims = new ArrayList<TpsDimension>();
    private int ping;
    private String versionString;

    public IMessage onMessage(final MessageResponseServerInfo message, MessageContext context) {
        Minecraft.func_71410_x().func_152344_a(new Runnable(){

            @Override
            public void run() {
                GuiTabPage.responseVersion = message.version;
                GuiTabPage.dims = message.dims;
                GuiTabPage.ping = message.ping;
                GuiTabPage.serverVersion = message.versionString;
            }
        });
        return null;
    }

    public MessageResponseServerInfo() {
    }

    public MessageResponseServerInfo(int version, List<TpsDimension> dims, int ping) {
        this.version = version;
        this.dims = dims;
        this.ping = ping;
    }

    public void toBytes(ByteBuf buf) {
        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)"1.2.6");
        buf.writeInt(this.version);
        buf.writeInt(this.dims.size());
        for (TpsDimension s : this.dims) {
            ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)s.name);
            buf.writeDouble(s.meanTickTime.doubleValue());
            buf.writeInt(s.Id);
        }
        buf.writeInt(this.ping);
    }

    public void fromBytes(ByteBuf buf) {
        this.versionString = ByteBufUtils.readUTF8String((ByteBuf)buf);
        this.version = buf.readInt();
        for (int length = buf.readInt(); length != 0; --length) {
            this.dims.add(new TpsDimension(ByteBufUtils.readUTF8String((ByteBuf)buf), (Double)buf.readDouble(), buf.readInt()));
        }
        if (this.version >= 2) {
            this.ping = buf.readInt();
        }
    }
}

