/*
 * Decompiled with CFR 0.152.
 */
package com.black_dog20.servertabinfo.client.objects;

import com.black_dog20.servertabinfo.client.CustomPlayerList;
import com.black_dog20.servertabinfo.client.GuiTabPage;
import com.black_dog20.servertabinfo.client.objects.IRenderable;
import com.black_dog20.servertabinfo.utility.CompatibilityHelper;
import com.black_dog20.servertabinfo.utility.RenderHelper;
import com.black_dog20.servertabinfo.utility.TpsDimension;
import com.mojang.authlib.GameProfile;
import java.util.ArrayList;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.network.NetworkPlayerInfo;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EnumPlayerModelParts;
import net.minecraft.scoreboard.ScorePlayerTeam;
import net.minecraft.scoreboard.Team;
import net.minecraft.world.GameType;

public class Player
implements IRenderable {
    private NetworkPlayerInfo networkInfo;
    private Minecraft mc;
    private int headWidth = 10;
    private int spacing = 3;
    private boolean flag = false;

    public Player(NetworkPlayerInfo info, Minecraft minecraft) {
        this.networkInfo = info;
        this.mc = minecraft;
        this.flag = this.mc.func_71387_A() || this.mc.func_147114_u().func_147298_b().func_179292_f();
    }

    @Override
    public int getWidth() {
        int width = 0;
        if (this.flag) {
            width += this.headWidth;
        }
        ArrayList<String> playerList = new ArrayList<String>();
        for (IRenderable p : CustomPlayerList.playerList) {
            if (!(p instanceof Player)) continue;
            playerList.add(((Player)p).getPlayerName());
        }
        width += RenderHelper.findMaxWidthString(playerList, this.mc);
        width += 2 * this.spacing;
        width = GuiTabPage.responseVersion >= 3 && CustomPlayerList.playerDims.isEmpty() ? (width += CompatibilityHelper.getStringWidth(this.mc, I18n.func_135052_a((String)"gui.servertabinfo.analysing", (Object[])new Object[0]))) : (GuiTabPage.responseVersion < 3 ? (width += CompatibilityHelper.getStringWidth(this.mc, I18n.func_135052_a((String)"gui.servertabinfo.unknown", (Object[])new Object[0]))) : (width += CompatibilityHelper.getStringWidth(this.mc, this.getDim(Player.getPlayerName(this.networkInfo)))));
        width += this.spacing;
        return width += CompatibilityHelper.getStringWidth(this.mc, this.getPing());
    }

    @Override
    public int getWidthOfElement(int n) {
        return this.getWidthArrayPrivate()[n];
    }

    @Override
    public int[] getWidthArray() {
        return this.getWidtArrayHelper(false);
    }

    private int[] getWidthArrayPrivate() {
        return this.getWidtArrayHelper(true);
    }

    private int[] getWidtArrayHelper(boolean here) {
        int[] width = new int[3];
        int tempWidth = 0;
        if (this.flag) {
            tempWidth += this.headWidth;
        }
        if (!here) {
            ArrayList<String> playerList = new ArrayList<String>();
            for (IRenderable p : CustomPlayerList.playerList) {
                if (!(p instanceof Player)) continue;
                playerList.add(((Player)p).getPlayerName());
            }
            tempWidth += RenderHelper.findMaxWidthString(playerList, this.mc);
        } else {
            tempWidth += CompatibilityHelper.getStringWidth(this.mc, this.getPlayerName());
        }
        width[0] = tempWidth += 2 * this.spacing;
        tempWidth = 0;
        tempWidth = GuiTabPage.responseVersion >= 3 && CustomPlayerList.playerDims.isEmpty() ? (tempWidth += CompatibilityHelper.getStringWidth(this.mc, I18n.func_135052_a((String)"gui.servertabinfo.analysing", (Object[])new Object[0]))) : (GuiTabPage.responseVersion < 3 ? (tempWidth += CompatibilityHelper.getStringWidth(this.mc, I18n.func_135052_a((String)"gui.servertabinfo.unknown", (Object[])new Object[0]))) : (tempWidth += CompatibilityHelper.getStringWidth(this.mc, this.getDim(this.getPlayerName()))));
        width[1] = tempWidth += this.spacing;
        tempWidth = 0;
        width[2] = tempWidth += CompatibilityHelper.getStringWidth(this.mc, this.getPing());
        return width;
    }

    @Override
    public void render(int x, int y, int width) {
        int leftoverspacing = width - this.getWidth();
        GameProfile gameprofile = this.networkInfo.func_178845_a();
        EntityPlayer entityplayer = this.mc.field_71441_e.func_152378_a(gameprofile.getId());
        if (this.flag) {
            boolean flag1 = entityplayer != null && entityplayer.func_175148_a(EnumPlayerModelParts.CAPE) && ("Dinnerbone".equals(gameprofile.getName()) || "Grumm".equals(gameprofile.getName()));
            this.mc.func_110434_K().func_110577_a(this.networkInfo.func_178837_g());
            int l2 = 8 + (flag1 ? 8 : 0);
            int i3 = 8 * (flag1 ? -1 : 1);
            Gui.func_152125_a((int)x, (int)y, (float)8.0f, (float)l2, (int)8, (int)i3, (int)8, (int)8, (float)64.0f, (float)64.0f);
            if (entityplayer != null && entityplayer.func_175148_a(EnumPlayerModelParts.HAT)) {
                int j3 = 8 + (flag1 ? 8 : 0);
                int k3 = 8 * (flag1 ? -1 : 1);
                Gui.func_152125_a((int)x, (int)y, (float)40.0f, (float)j3, (int)8, (int)k3, (int)8, (int)8, (float)64.0f, (float)64.0f);
            }
            x += this.headWidth;
        }
        String s4 = this.getPlayerName();
        if (this.networkInfo.func_178848_b() == GameType.SPECTATOR) {
            CompatibilityHelper.drawStringWithShadowItalic(this.mc, s4, x, y, -1862270977);
        } else {
            CompatibilityHelper.drawStringWithShadow(this.mc, s4, x, y, -1);
        }
        String dim = CompatibilityHelper.translate("gui.servertabinfo.unknown");
        dim = GuiTabPage.responseVersion >= 3 && CustomPlayerList.playerDims.isEmpty() ? CompatibilityHelper.translate("gui.servertabinfo.analysing") : (GuiTabPage.responseVersion < 3 ? CompatibilityHelper.translate("gui.servertabinfo.unknown") : this.getDim(Player.getPlayerName(this.networkInfo)));
        CompatibilityHelper.drawStringWithShadow(this.mc, dim, x += CompatibilityHelper.getStringWidth(this.mc, s4) + 2 * this.spacing + leftoverspacing, y, -1);
        CompatibilityHelper.drawStringWithShadow(this.mc, this.getPing(), x += CompatibilityHelper.getStringWidth(this.mc, dim) + this.spacing, y, -1);
    }

    private int calcLeftOverspace(int[] maxWidth, int n) {
        return maxWidth[n] - this.getWidthOfElement(n);
    }

    @Override
    public void render(int x, int y, int[] maxWidth) {
        GameProfile gameprofile = this.networkInfo.func_178845_a();
        EntityPlayer entityplayer = this.mc.field_71441_e.func_152378_a(gameprofile.getId());
        if (this.flag) {
            boolean flag1 = entityplayer != null && entityplayer.func_175148_a(EnumPlayerModelParts.CAPE) && ("Dinnerbone".equals(gameprofile.getName()) || "Grumm".equals(gameprofile.getName()));
            this.mc.func_110434_K().func_110577_a(this.networkInfo.func_178837_g());
            int l2 = 8 + (flag1 ? 8 : 0);
            int i3 = 8 * (flag1 ? -1 : 1);
            Gui.func_152125_a((int)x, (int)y, (float)8.0f, (float)l2, (int)8, (int)i3, (int)8, (int)8, (float)64.0f, (float)64.0f);
            if (entityplayer != null && entityplayer.func_175148_a(EnumPlayerModelParts.HAT)) {
                int j3 = 8 + (flag1 ? 8 : 0);
                int k3 = 8 * (flag1 ? -1 : 1);
                Gui.func_152125_a((int)x, (int)y, (float)40.0f, (float)j3, (int)8, (int)k3, (int)8, (int)8, (float)64.0f, (float)64.0f);
            }
            x += this.headWidth;
        }
        String s4 = this.getPlayerName();
        if (this.networkInfo.func_178848_b() == GameType.SPECTATOR) {
            CompatibilityHelper.drawStringWithShadowItalic(this.mc, s4, x, y, -1862270977);
        } else {
            CompatibilityHelper.drawStringWithShadow(this.mc, s4, x, y, -1);
        }
        String dim = CompatibilityHelper.translate("gui.servertabinfo.unknown");
        dim = GuiTabPage.responseVersion >= 3 && CustomPlayerList.playerDims.isEmpty() ? CompatibilityHelper.translate("gui.servertabinfo.analysing") : (GuiTabPage.responseVersion < 3 ? CompatibilityHelper.translate("gui.servertabinfo.unknown") : this.getDim(Player.getPlayerName(this.networkInfo)));
        CompatibilityHelper.drawStringWithShadow(this.mc, dim, x += CompatibilityHelper.getStringWidth(this.mc, s4) + 2 * this.spacing + this.calcLeftOverspace(maxWidth, 0), y, -1);
        CompatibilityHelper.drawStringWithShadow(this.mc, this.getPing(), x += CompatibilityHelper.getStringWidth(this.mc, dim) + this.spacing + this.calcLeftOverspace(maxWidth, 1), y, -1);
    }

    public String getPlayerName() {
        return this.networkInfo.func_178854_k() != null ? this.networkInfo.func_178854_k().func_150260_c() : ScorePlayerTeam.func_96667_a((Team)this.networkInfo.func_178850_i(), (String)this.networkInfo.func_178845_a().getName());
    }

    public static String getPlayerName(NetworkPlayerInfo networkPlayerInfoIn) {
        return networkPlayerInfoIn.func_178854_k() != null ? networkPlayerInfoIn.func_178854_k().func_150260_c() : ScorePlayerTeam.func_96667_a((Team)networkPlayerInfoIn.func_178850_i(), (String)networkPlayerInfoIn.func_178845_a().getName());
    }

    private String getPing() {
        String pingValue = CompatibilityHelper.text(Integer.toString(this.networkInfo.func_178853_c()));
        String ms = CompatibilityHelper.translate("gui.servertabinfo.ms");
        String pingString = String.format("%s%s", pingValue, ms);
        return pingString;
    }

    private String getDim(String player) {
        TpsDimension dim = CustomPlayerList.playerDims.get(player);
        if (dim != null) {
            return CustomPlayerList.playerDims.get(player).getShortDimString(2);
        }
        return "";
    }
}

