/*
 * Decompiled with CFR 0.152.
 */
package com.enderio.core.client.gui.button;

import com.enderio.core.api.client.gui.IGuiScreen;
import com.enderio.core.api.client.render.IWidgetIcon;
import com.enderio.core.client.gui.button.IButtonAwareButton;
import com.enderio.core.client.gui.button.TooltipButton;
import com.enderio.core.client.render.EnderWidget;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import org.lwjgl.opengl.GL11;

public class IconButton
extends TooltipButton
implements IButtonAwareButton {
    public static final int DEFAULT_WIDTH = 16;
    public static final int DEFAULT_HEIGHT = 16;
    @Nullable
    protected IWidgetIcon icon;
    private int marginY = 0;
    private int marginX = 0;

    public IconButton(@Nonnull IGuiScreen gui, int id, int x, int y, @Nullable IWidgetIcon icon) {
        super(gui, id, x, y, 16, 16, "");
        this.icon = icon;
    }

    @Override
    public IconButton setPosition(int x, int y) {
        super.setPosition(x, y);
        return this;
    }

    public IconButton setIconMargin(int x, int y) {
        this.marginX = x;
        this.marginY = y;
        return this;
    }

    @Nullable
    public IWidgetIcon getIcon() {
        return this.icon;
    }

    public void setIcon(@Nullable IWidgetIcon icon) {
        this.icon = icon;
    }

    @Override
    @Deprecated
    public boolean func_146116_c(@Nonnull Minecraft mc, int mouseX, int mouseY) {
        return this.mousePressedButton(mc, mouseX, mouseY, 0);
    }

    @Override
    public boolean mousePressedButton(@Nonnull Minecraft mc, int mouseX, int mouseY, int button) {
        return button == 0 && this.checkMousePress(mc, mouseX, mouseY);
    }

    @Override
    public boolean checkMousePress(@Nonnull Minecraft mc, int mouseX, int mouseY) {
        return super.func_146116_c(mc, mouseX, mouseY);
    }

    @Override
    public void func_191745_a(@Nonnull Minecraft mc, int mouseX, int mouseY, float partialTicks) {
        this.updateTooltip(mc, mouseX, mouseY);
        if (this.isVisible()) {
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            this.field_146123_n = mouseX >= this.field_146128_h && mouseY >= this.field_146129_i && mouseX < this.field_146128_h + this.field_146120_f && mouseY < this.field_146129_i + this.field_146121_g;
            int hoverState = this.func_146114_a(this.field_146123_n);
            this.func_146119_b(mc, mouseX, mouseY);
            IWidgetIcon background = this.getIconForHoverState(hoverState);
            GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
            GL11.glPushAttrib((int)8192);
            GL11.glEnable((int)3042);
            GL11.glBlendFunc((int)770, (int)771);
            background.getMap().render(background, this.field_146128_h, this.field_146129_i, this.field_146120_f, this.field_146121_g, 0.0, true);
            IWidgetIcon icon2 = this.icon;
            if (icon2 != null) {
                icon2.getMap().render(icon2, this.field_146128_h + this.marginX, this.field_146129_i + this.marginY, this.field_146120_f - 2 * this.marginX, this.field_146121_g - 2 * this.marginY, 0.0, true);
            }
            GL11.glPopAttrib();
        }
    }

    @Nonnull
    protected IWidgetIcon getIconForHoverState(int hoverState) {
        if (hoverState == 0) {
            return EnderWidget.BUTTON_DISABLED;
        }
        if (hoverState == 2) {
            return EnderWidget.BUTTON_HIGHLIGHT;
        }
        return EnderWidget.BUTTON;
    }
}

