/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.tileentities;

import com.ldtteam.structurize.blocks.ModBlocks;
import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.IColonyManager;
import com.minecolonies.api.colony.IColonyView;
import com.minecolonies.api.tileentities.AbstractScarescrowTileEntity;
import com.minecolonies.api.tileentities.ScareCrowType;
import com.minecolonies.api.tileentities.ScarecrowFieldStage;
import com.minecolonies.api.util.EntityUtils;
import com.minecolonies.api.util.ItemStackUtils;
import com.minecolonies.api.util.LanguageHandler;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockFence;
import net.minecraft.block.BlockFenceGate;
import net.minecraft.block.BlockWall;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TileEntityScarecrow
extends AbstractScarescrowTileEntity {
    private static final int MAX_RANGE = 5;
    private boolean taken = false;
    private boolean doesNeedWork = true;
    private ScarecrowFieldStage fieldStage = ScarecrowFieldStage.EMPTY;
    private int lengthPlusX;
    private int widthPlusZ;
    private int lengthMinusX;
    private int widthMinusZ;
    private int ownerId;
    @NotNull
    private String owner = "";
    private final Random random = new Random();
    private ScareCrowType type;
    @Nullable
    private IColony colony;
    private String name;
    private final IItemHandlerModifiable inventory = new ItemStackHandler(1);

    public TileEntityScarecrow() {
        this.name = LanguageHandler.format("com.minecolonies.coremod.gui.scarecrow.user", LanguageHandler.format(this.owner, new Object[0]));
    }

    @Override
    public String getDesc() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
        this.func_190575_a(name);
        this.func_70296_d();
    }

    private static int getMaxRange() {
        return 5;
    }

    @Override
    public final void calculateSize(@NotNull World world, @NotNull BlockPos position) {
        this.lengthPlusX = this.searchNextBlock(0, position.func_177974_f(), EnumFacing.EAST, world);
        this.lengthMinusX = this.searchNextBlock(0, position.func_177976_e(), EnumFacing.WEST, world);
        this.widthPlusZ = this.searchNextBlock(0, position.func_177968_d(), EnumFacing.SOUTH, world);
        this.widthMinusZ = this.searchNextBlock(0, position.func_177978_c(), EnumFacing.NORTH, world);
        this.func_70296_d();
    }

    private int searchNextBlock(int blocksChecked, @NotNull BlockPos position, EnumFacing direction, @NotNull World world) {
        if (blocksChecked >= TileEntityScarecrow.getMaxRange() || this.isNoPartOfField(world, position)) {
            return blocksChecked;
        }
        return this.searchNextBlock(blocksChecked + 1, position.func_177972_a(direction), direction, world);
    }

    @Override
    public boolean isNoPartOfField(@NotNull World world, @NotNull BlockPos position) {
        return world.func_175623_d(position) || TileEntityScarecrow.isValidDelimiter(world.func_180495_p(position.func_177984_a()).func_177230_c());
    }

    private static boolean isValidDelimiter(Block block) {
        return block instanceof BlockFence || block instanceof BlockFenceGate || block == ModBlocks.blockCactusFence || block == ModBlocks.blockCactusFenceGate || block instanceof BlockWall;
    }

    @Override
    public BlockPos getID() {
        return this.func_174877_v();
    }

    @Override
    public boolean isTaken() {
        return this.taken;
    }

    @Override
    public void setTaken(boolean taken) {
        this.taken = taken;
        this.func_70296_d();
    }

    @Override
    public void nextState() {
        if (this.getFieldStage().ordinal() + 1 >= ScarecrowFieldStage.values().length) {
            this.doesNeedWork = false;
            this.setFieldStage(ScarecrowFieldStage.values()[0]);
            return;
        }
        this.setFieldStage(ScarecrowFieldStage.values()[this.getFieldStage().ordinal() + 1]);
        this.func_70296_d();
    }

    @Override
    public ScarecrowFieldStage getFieldStage() {
        return this.fieldStage;
    }

    @Override
    public void setFieldStage(ScarecrowFieldStage fieldStage) {
        this.fieldStage = fieldStage;
        this.func_70296_d();
    }

    @Override
    public boolean needsWork() {
        return this.doesNeedWork;
    }

    @Override
    public void setNeedsWork(boolean needsWork) {
        this.doesNeedWork = needsWork;
        this.func_70296_d();
    }

    @Override
    @Nullable
    public ItemStack getSeed() {
        if (this.inventory.getStackInSlot(0) != ItemStackUtils.EMPTY && this.inventory.getStackInSlot(0).func_77973_b() instanceof IPlantable) {
            return this.inventory.getStackInSlot(0);
        }
        return null;
    }

    @Override
    public int getLengthPlusX() {
        return this.lengthPlusX;
    }

    @Override
    public int getWidthPlusZ() {
        return this.widthPlusZ;
    }

    @Override
    public int getLengthMinusX() {
        return this.lengthMinusX;
    }

    @Override
    public int getWidthMinusZ() {
        return this.widthMinusZ;
    }

    @Override
    public BlockPos getPosition() {
        return this.field_174879_c;
    }

    @Override
    @NotNull
    public String getOwner() {
        return this.owner;
    }

    @Override
    public int getOwnerId() {
        return this.ownerId;
    }

    @Override
    public void setOwner(@NotNull int ownerId) {
        this.ownerId = ownerId;
        if (this.colony != null) {
            this.owner = this.colony.getCitizenManager().getCitizen(ownerId) == null ? "" : this.colony.getCitizenManager().getCitizen(ownerId).getName();
        }
        this.setName(LanguageHandler.format("com.minecolonies.coremod.gui.scarecrow.user", LanguageHandler.format(this.owner, new Object[0])));
        this.func_70296_d();
    }

    @Override
    public void setOwner(int ownerId, IColonyView tempColony) {
        this.ownerId = ownerId;
        if (tempColony != null) {
            this.owner = tempColony.getCitizen(ownerId) == null ? "" : tempColony.getCitizen(ownerId).getName();
        }
        this.func_70296_d();
    }

    @Override
    public IItemHandlerModifiable getInventory() {
        return this.inventory;
    }

    public SPacketUpdateTileEntity func_189518_D_() {
        NBTTagCompound compound = new NBTTagCompound();
        this.func_189515_b(compound);
        if (this.colony != null) {
            compound.func_74768_a("colony", this.colony.getID());
        }
        return new SPacketUpdateTileEntity(this.field_174879_c, 0, compound);
    }

    @NotNull
    public NBTTagCompound func_189517_E_() {
        return this.func_189515_b(new NBTTagCompound());
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity packet) {
        NBTTagCompound compound = packet.func_148857_g();
        this.func_145839_a(compound);
        if (compound.func_74764_b("colony")) {
            this.setOwner(this.ownerId, IColonyManager.getInstance().getColonyView(compound.func_74762_e("colony"), this.field_145850_b.field_73011_w.getDimension()));
        }
    }

    public void onLoad() {
        Entity entity;
        super.onLoad();
        World world = this.func_145831_w();
        this.colony = IColonyManager.getInstance().getColonyByPosFromWorld(world, this.field_174879_c);
        if (this.colony != null && !this.colony.getBuildingManager().getFields().contains(this.field_174879_c) && (entity = EntityUtils.getEntityFromUUID(world, this.colony.getPermissions().getOwner())) instanceof EntityPlayer) {
            this.colony.getBuildingManager().addNewField(this, this.field_174879_c, world);
        }
    }

    public void func_145839_a(NBTTagCompound compound) {
        NBTTagList inventoryTagList = compound.func_150295_c("inventory", 10);
        for (int i = 0; i < inventoryTagList.func_74745_c(); ++i) {
            NBTTagCompound inventoryCompound = inventoryTagList.func_150305_b(i);
            ItemStack stack = new ItemStack(inventoryCompound);
            if (ItemStackUtils.getSize(stack) <= 0) {
                this.inventory.setStackInSlot(i, ItemStackUtils.EMPTY);
                continue;
            }
            this.inventory.setStackInSlot(i, stack);
        }
        this.taken = compound.func_74767_n("taken");
        this.fieldStage = ScarecrowFieldStage.values()[compound.func_74762_e("stage")];
        this.lengthPlusX = compound.func_74762_e("length+");
        this.widthPlusZ = compound.func_74762_e("width+");
        this.lengthMinusX = compound.func_74762_e("length-");
        this.widthMinusZ = compound.func_74762_e("width-");
        this.ownerId = compound.func_74762_e("owner");
        this.name = compound.func_74779_i("name");
        this.setOwner(this.ownerId);
        super.func_145839_a(compound);
    }

    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        NBTTagList inventoryTagList = new NBTTagList();
        for (int slot = 0; slot < this.inventory.getSlots(); ++slot) {
            NBTTagCompound inventoryCompound = new NBTTagCompound();
            ItemStack stack = this.inventory.getStackInSlot(slot);
            if (stack == ItemStackUtils.EMPTY) {
                new ItemStack(Blocks.field_150350_a, 0).func_77955_b(inventoryCompound);
            } else {
                stack.func_77955_b(inventoryCompound);
            }
            inventoryTagList.func_74742_a((NBTBase)inventoryCompound);
        }
        compound.func_74782_a("inventory", (NBTBase)inventoryTagList);
        compound.func_74757_a("taken", this.taken);
        compound.func_74768_a("stage", this.fieldStage.ordinal());
        compound.func_74768_a("length+", this.lengthPlusX);
        compound.func_74768_a("width+", this.widthPlusZ);
        compound.func_74768_a("length-", this.lengthMinusX);
        compound.func_74768_a("width-", this.widthMinusZ);
        compound.func_74768_a("owner", this.ownerId);
        compound.func_74778_a("name", this.name);
        return super.func_189515_b(compound);
    }

    @Override
    public ScareCrowType getType() {
        if (this.type == null) {
            this.type = ScareCrowType.values()[this.random.nextInt(2)];
        }
        return this.type;
    }
}

