/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.network.messages;

import com.minecolonies.api.items.ModItems;
import com.minecolonies.api.util.BlockPosUtil;
import com.minecolonies.coremod.network.messages.AbstractMessage;
import io.netty.buffer.ByteBuf;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import org.jetbrains.annotations.NotNull;

public class LumberjackScepterMessage
extends AbstractMessage<LumberjackScepterMessage, IMessage> {
    private BlockPos buildingId;
    private int colonyId;

    public LumberjackScepterMessage() {
    }

    public LumberjackScepterMessage(BlockPos buildingId, int colonyId) {
        this.buildingId = buildingId;
        this.colonyId = colonyId;
    }

    public void fromBytes(@NotNull ByteBuf buf) {
        this.buildingId = BlockPosUtil.readFromByteBuf(buf);
        this.colonyId = buf.readInt();
    }

    public void toBytes(@NotNull ByteBuf buf) {
        BlockPosUtil.writeToByteBuf(buf, this.buildingId);
        buf.writeInt(this.colonyId);
    }

    @Override
    public void messageOnServerThread(LumberjackScepterMessage message, EntityPlayerMP player) {
        NBTTagCompound compound;
        ItemStack scepter;
        boolean giveToPlayer = true;
        if (player.func_184614_ca().func_77973_b() == ModItems.scepterLumberjack) {
            scepter = player.func_184614_ca();
            giveToPlayer = false;
        } else {
            scepter = new ItemStack(ModItems.scepterLumberjack);
        }
        if (!scepter.func_77942_o()) {
            scepter.func_77982_d(new NBTTagCompound());
        }
        if ((compound = scepter.func_77978_p()) == null) {
            return;
        }
        int emptySlot = player.field_71071_by.func_70447_i();
        BlockPosUtil.writeToNBT(compound, "pos", message.buildingId);
        compound.func_74768_a("id", message.colonyId);
        if (giveToPlayer) {
            ItemStack item = player.field_71071_by.func_70301_a(player.field_71071_by.field_70461_c);
            player.field_71071_by.func_70299_a(emptySlot, item);
            player.field_71071_by.func_70299_a(player.field_71071_by.field_70461_c, scepter);
        }
        player.field_71071_by.func_70296_d();
    }
}

