/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.network.messages;

import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.IColonyManager;
import com.minecolonies.api.colony.guardtype.GuardType;
import com.minecolonies.api.colony.guardtype.registry.IGuardTypeRegistry;
import com.minecolonies.api.colony.permissions.Action;
import com.minecolonies.api.entity.ai.citizen.guards.GuardTask;
import com.minecolonies.api.util.BlockPosUtil;
import com.minecolonies.coremod.colony.buildings.AbstractBuildingGuards;
import com.minecolonies.coremod.network.messages.AbstractMessage;
import io.netty.buffer.ByteBuf;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import org.jetbrains.annotations.NotNull;

public class GuardTaskMessage
extends AbstractMessage<GuardTaskMessage, IMessage> {
    private int colonyId;
    private BlockPos buildingId;
    private ResourceLocation job;
    private boolean assignmentMode;
    private boolean patrollingMode;
    private boolean retrieval;
    private int task;
    private int dimension;
    private boolean tightGrouping;

    public GuardTaskMessage() {
    }

    public GuardTaskMessage(@NotNull AbstractBuildingGuards.View building, ResourceLocation job, boolean assignmentMode, boolean patrollingMode, boolean retrieval, int task, boolean tightGrouping) {
        this.colonyId = building.getColony().getID();
        this.buildingId = building.getID();
        this.job = job;
        this.assignmentMode = assignmentMode;
        this.patrollingMode = patrollingMode;
        this.retrieval = retrieval;
        this.task = task;
        this.tightGrouping = tightGrouping;
        this.dimension = building.getColony().getDimension();
    }

    public void fromBytes(@NotNull ByteBuf buf) {
        this.colonyId = buf.readInt();
        this.buildingId = BlockPosUtil.readFromByteBuf(buf);
        this.job = new ResourceLocation(ByteBufUtils.readUTF8String((ByteBuf)buf));
        this.assignmentMode = buf.readBoolean();
        this.patrollingMode = buf.readBoolean();
        this.tightGrouping = buf.readBoolean();
        this.retrieval = buf.readBoolean();
        this.task = buf.readInt();
        this.dimension = buf.readInt();
    }

    public void toBytes(@NotNull ByteBuf buf) {
        buf.writeInt(this.colonyId);
        BlockPosUtil.writeToByteBuf(buf, this.buildingId);
        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.job.toString());
        buf.writeBoolean(this.assignmentMode);
        buf.writeBoolean(this.patrollingMode);
        buf.writeBoolean(this.tightGrouping);
        buf.writeBoolean(this.retrieval);
        buf.writeInt(this.task);
        buf.writeInt(this.dimension);
    }

    @Override
    public void messageOnServerThread(GuardTaskMessage message, EntityPlayerMP player) {
        IColony colony = IColonyManager.getInstance().getColonyByDimension(message.colonyId, message.dimension);
        if (colony != null) {
            if (!colony.getPermissions().hasPermission((EntityPlayer)player, Action.MANAGE_HUTS)) {
                return;
            }
            AbstractBuildingGuards building = colony.getBuildingManager().getBuilding(message.buildingId, AbstractBuildingGuards.class);
            if (building != null) {
                building.setGuardType((GuardType)IGuardTypeRegistry.getInstance().getValue(message.job));
                building.setAssignManually(message.assignmentMode);
                building.setPatrolManually(message.patrollingMode);
                building.setTightGrouping(message.tightGrouping);
                building.setRetrieveOnLowHealth(message.retrieval);
                building.setTask(GuardTask.values()[message.task]);
                if (building.getTask().equals((Object)GuardTask.FOLLOW)) {
                    building.setPlayerToFollow((EntityPlayer)player);
                }
            }
        }
    }
}

