/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.network.messages;

import com.minecolonies.api.util.BlockPosUtil;
import com.minecolonies.coremod.blocks.BlockDecorationController;
import com.minecolonies.coremod.network.messages.AbstractMessage;
import com.minecolonies.coremod.tileentities.TileEntityDecorationController;
import io.netty.buffer.ByteBuf;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import org.jetbrains.annotations.NotNull;

public class DecorationControllUpdateMessage
extends AbstractMessage<DecorationControllUpdateMessage, IMessage> {
    private BlockPos pos;
    private String name;
    private int level;

    public DecorationControllUpdateMessage() {
    }

    public DecorationControllUpdateMessage(@NotNull BlockPos pos, String name, int level) {
        this.pos = pos;
        this.name = name;
        this.level = level;
    }

    public void fromBytes(@NotNull ByteBuf buf) {
        this.name = ByteBufUtils.readUTF8String((ByteBuf)buf);
        this.pos = BlockPosUtil.readFromByteBuf(buf);
        this.level = buf.readInt();
    }

    public void toBytes(@NotNull ByteBuf buf) {
        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.name);
        BlockPosUtil.writeToByteBuf(buf, this.pos);
        buf.writeInt(this.level);
    }

    @Override
    public void messageOnServerThread(DecorationControllUpdateMessage message, EntityPlayerMP player) {
        TileEntity tileEntity = player.func_71121_q().func_175625_s(message.pos);
        if (tileEntity instanceof TileEntityDecorationController) {
            IBlockState state = player.func_71121_q().func_180495_p(message.pos);
            EnumFacing basicFacing = (EnumFacing)state.func_177229_b((IProperty)BlockDecorationController.field_185512_D);
            ((TileEntityDecorationController)tileEntity).setSchematicName(message.name);
            ((TileEntityDecorationController)tileEntity).setLevel(message.level);
            ((TileEntityDecorationController)tileEntity).setBasicFacing(basicFacing);
        }
    }
}

