/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.entity.mobs.aitasks;

import com.minecolonies.api.configuration.Configurations;
import com.minecolonies.api.entity.mobs.AbstractEntityMinecoloniesMob;
import com.minecolonies.api.util.BlockPosUtil;
import com.minecolonies.api.util.constant.Constants;
import com.minecolonies.coremod.entity.pathfinding.GeneralEntityWalkToProxy;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import net.minecraft.block.BlockDoor;
import net.minecraft.block.BlockLadder;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.init.Blocks;
import net.minecraft.pathfinding.Path;
import net.minecraft.pathfinding.PathPoint;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.World;
import org.jetbrains.annotations.NotNull;

public class EntityAIWalkToRandomHuts
extends EntityAIBase {
    private static final double MIN_TP_DIST = 10000.0;
    protected final AbstractEntityMinecoloniesMob entity;
    private final List<EnumFacing> directions = Arrays.asList(Arrays.copyOf(EnumFacing.field_176754_o, 4));
    protected final World world;
    protected final double speed;
    private final Random random = new Random();
    private BlockPos targetBlock;
    private GeneralEntityWalkToProxy proxy;
    private int lastIndex = -1;
    private int stuckTime = 1;
    private int passedTicks = 0;
    private static int UPDATE_INTERVAL = 40;
    int tickTimer = 0;
    private int totalStuckTime = 0;
    boolean hadPath = false;

    public EntityAIWalkToRandomHuts(AbstractEntityMinecoloniesMob creatureIn, double speedIn) {
        this.entity = creatureIn;
        this.speed = speedIn;
        this.world = creatureIn.func_130014_f_();
        this.func_75248_a(3);
    }

    public boolean func_75250_a() {
        return this.entity.func_70089_S() && this.entity.getColony() != null && this.entity.func_70638_az() == null && this.entity.func_94060_bK() == null;
    }

    public void func_75246_d() {
        if (++this.tickTimer < UPDATE_INTERVAL) {
            return;
        }
        this.tickTimer = 0;
        if (this.isEntityAtSiteWithMove(this.targetBlock, 2)) {
            this.targetBlock = this.getRandomBuilding();
            this.resetStuckCounters();
        }
    }

    private void resetStuckCounters() {
        this.passedTicks = 0;
        this.stuckTime = 0;
        this.lastIndex = -1;
        this.entity.setStuckCounter(0);
        this.totalStuckTime = 0;
    }

    public void func_75249_e() {
        this.proxy = new GeneralEntityWalkToProxy((EntityLiving)this.entity);
        this.targetBlock = this.getRandomBuilding();
        this.hadPath = false;
        this.resetStuckCounters();
    }

    public void func_75251_c() {
        this.targetBlock = this.getRandomBuilding();
        this.hadPath = false;
        this.resetStuckCounters();
    }

    private boolean isEntityAtSiteWithMove(@NotNull BlockPos site, int range) {
        if (this.entity.func_70644_a(Constants.LEVITATION_EFFECT)) {
            return true;
        }
        if (this.proxy.walkToBlock(site, range, true)) {
            return true;
        }
        if (this.entity.getNavigator().func_75505_d() == null || this.entity.getNavigator().func_75505_d().func_75879_b()) {
            this.lastIndex = -1;
            if (!this.hadPath) {
                ++this.stuckTime;
            }
        } else {
            if (this.entity.getNavigator().func_75505_d().func_75873_e() == this.lastIndex) {
                ++this.stuckTime;
                if (this.totalStuckTime > 0 && this.trySkipAheadOnPath()) {
                    this.resetStuckCounters();
                }
            } else if (this.entity.getNavigator().func_75505_d().func_75873_e() > 5) {
                this.resetStuckCounters();
            }
            this.lastIndex = this.entity.getNavigator().func_75505_d().func_75873_e();
        }
        this.hadPath = this.entity.getNavigator().func_75505_d() != null && !this.entity.getNavigator().func_75505_d().func_75879_b();
        this.passedTicks += UPDATE_INTERVAL;
        long targetDist = BlockPosUtil.getDistance2D(this.entity.func_180425_c(), this.targetBlock);
        if (this.entity.getStuckCounter() >= 5 || targetDist * 60L < (long)this.passedTicks) {
            if (this.handleTotalStuck(targetDist)) {
                this.resetStuckCounters();
                this.targetBlock = this.getRandomBuilding();
            }
            return false;
        }
        if (this.stuckTime > 5) {
            this.handleEntityBeingStuck();
        }
        return false;
    }

    private boolean handleTotalStuck(long targetDist) {
        ++this.totalStuckTime;
        if (this.trySkipAheadOnPath()) {
            return true;
        }
        if (this.totalStuckTime == 1) {
            this.passedTicks -= UPDATE_INTERVAL * 2;
            this.entity.setStuckCounter(this.entity.getStuckCounter() - 2);
            this.targetBlock = this.entity.getColony().getRaiderManager().getRandomBuilding();
            return false;
        }
        if ((double)targetDist > 10000.0) {
            BlockPos tpPos = BlockPosUtil.getFloor(this.entity.func_180425_c().func_177967_a(BlockPosUtil.getXZFacing(this.entity.func_180425_c(), this.targetBlock), 5), this.world);
            this.entity.func_70634_a(tpPos.func_177958_n(), tpPos.func_177956_o(), tpPos.func_177952_p());
            return true;
        }
        return false;
    }

    private boolean trySkipAheadOnPath() {
        Path path = this.entity.getNavigator().func_75505_d();
        if (path != null && !path.func_75879_b() && path.func_75874_d() >= 5) {
            PathPoint pathPoint = path.func_75877_a(4);
            this.entity.func_70634_a(pathPoint.field_75839_a, pathPoint.field_75837_b, pathPoint.field_75838_c);
            return true;
        }
        return false;
    }

    private boolean handleEntityBeingStuck() {
        this.entity.getNavigator().func_75499_g();
        this.stuckTime = 0;
        this.entity.setStuckCounter(this.entity.getStuckCounter() + 1);
        BlockPos front = this.entity.func_180425_c().func_177977_b().func_177972_a(this.entity.func_174811_aO());
        if (this.world.func_175623_d(front) && this.world.func_175623_d(front.func_177979_c(3)) || this.world.func_180495_p(front).func_177230_c() == Blocks.field_150353_l || this.world.func_180495_p(front).func_177230_c() == Blocks.field_150356_k) {
            this.world.func_175656_a(front, Blocks.field_150361_u.func_176223_P());
        }
        if (this.entity.getStuckCounter() % 5 == 0) {
            this.entity.getNavigator().moveAwayFromXYZ(this.entity.func_180425_c(), this.random.nextInt(4), 2.0);
        } else {
            this.handleBarbarianMovementSpecials();
        }
        return false;
    }

    private void handleBarbarianMovementSpecials() {
        Collections.shuffle(this.directions);
        if (this.entity.getStuckCounter() % 10 < 5) {
            this.handleBarbarianLadderPlacement();
        } else if (Configurations.gameplay.doBarbariansBreakThroughWalls) {
            this.handleBarbarianBlockBreakment();
        }
    }

    private void handleBarbarianLadderPlacement() {
        IBlockState ladderHere = this.world.func_180495_p(this.entity.func_180425_c());
        IBlockState ladderUp = this.world.func_180495_p(this.entity.func_180425_c().func_177984_a());
        if (ladderHere.func_177230_c() == Blocks.field_150468_ap && ladderUp.func_177230_c() != Blocks.field_150468_ap && !ladderUp.func_185904_a().func_76224_d()) {
            EnumFacing facingHere = (EnumFacing)ladderHere.func_177229_b((IProperty)BlockLadder.field_176382_a);
            IBlockState upState = this.world.func_180495_p(this.entity.func_180425_c().func_177984_a().func_177972_a(facingHere));
            if (upState.func_185904_a().func_76220_a() && upState.func_185913_b() && Blocks.field_150468_ap.func_176198_a(this.world, this.entity.func_180425_c().func_177984_a(), facingHere)) {
                this.world.func_175656_a(this.entity.func_180425_c().func_177984_a(), ladderHere);
            }
        } else if (ladderUp.func_177230_c() == Blocks.field_150468_ap && ladderHere.func_177230_c() != Blocks.field_150468_ap && !ladderHere.func_185904_a().func_76224_d()) {
            EnumFacing facingUp = (EnumFacing)ladderUp.func_177229_b((IProperty)BlockLadder.field_176382_a);
            IBlockState downState = this.world.func_180495_p(this.entity.func_180425_c().func_177972_a(facingUp.func_176734_d()));
            if (downState.func_185904_a().func_76220_a() && downState.func_185913_b() && Blocks.field_150468_ap.func_176198_a(this.world, this.entity.func_180425_c(), facingUp)) {
                this.world.func_175656_a(this.entity.func_180425_c(), ladderUp);
            }
        } else if (ladderUp.func_177230_c() != Blocks.field_150468_ap && ladderHere.func_177230_c() != Blocks.field_150468_ap) {
            this.handleNextLadderPlacement();
        }
    }

    private void handleBarbarianBlockBreakment() {
        for (EnumFacing dir : this.directions) {
            BlockPos posToDestroy = this.entity.func_180425_c().func_177981_b(this.random.nextInt(3)).func_177972_a(dir);
            IBlockState state = this.world.func_180495_p(posToDestroy);
            if ((state.func_177230_c() == Blocks.field_150350_a || !state.func_177230_c().func_149703_v() || state.func_185904_a().func_76224_d()) && (!(state.func_177230_c() instanceof BlockDoor) || this.world.func_175659_aa() != EnumDifficulty.HARD)) continue;
            this.world.func_175655_b(posToDestroy, true);
        }
    }

    private void handleNextLadderPlacement() {
        for (EnumFacing dir : this.directions) {
            IBlockState state = this.world.func_180495_p(this.entity.func_180425_c().func_177984_a().func_177972_a(dir));
            if (!state.func_185904_a().func_76220_a() || !state.func_185913_b() || !Blocks.field_150468_ap.func_176198_a(this.world, this.entity.func_180425_c().func_177972_a(dir), dir)) continue;
            this.world.func_175656_a(this.entity.func_180425_c().func_177984_a(), Blocks.field_150468_ap.func_176223_P().func_177226_a((IProperty)BlockLadder.field_176382_a, (Comparable)dir.func_176734_d()));
            break;
        }
    }

    private BlockPos getRandomBuilding() {
        if (this.entity.getColony() == null) {
            return null;
        }
        return this.entity.getColony().getRaiderManager().getRandomBuilding();
    }
}

