/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.entity.ai.citizen.crusher;

import com.minecolonies.api.colony.requestsystem.request.RequestState;
import com.minecolonies.api.colony.requestsystem.requestable.crafting.PublicCrafting;
import com.minecolonies.api.colony.requestsystem.token.IToken;
import com.minecolonies.api.entity.ai.statemachine.AITarget;
import com.minecolonies.api.entity.ai.statemachine.states.AIWorkerState;
import com.minecolonies.api.entity.ai.statemachine.states.IAIState;
import com.minecolonies.api.util.CraftingUtils;
import com.minecolonies.api.util.SoundUtils;
import com.minecolonies.coremod.MineColonies;
import com.minecolonies.coremod.colony.buildings.AbstractCitizenAssignable;
import com.minecolonies.coremod.colony.buildings.AbstractSchematicProvider;
import com.minecolonies.coremod.colony.buildings.workerbuildings.BuildingCrusher;
import com.minecolonies.coremod.colony.jobs.JobCrusher;
import com.minecolonies.coremod.entity.ai.basic.AbstractEntityAICrafting;
import com.minecolonies.coremod.network.messages.LocalizedParticleEffectMessage;
import com.minecolonies.coremod.util.WorkerUtil;
import net.minecraft.entity.Entity;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumHand;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import org.jetbrains.annotations.NotNull;

public class EntityAIWorkCrusher<J extends JobCrusher>
extends AbstractEntityAICrafting<J> {
    private static final int STRENGTH_MULTIPLIER = 2;
    private static final int ENDURANCE_MULTIPLIER = 1;
    private static final int TICK_DELAY = 20;

    public EntityAIWorkCrusher(@NotNull J job) {
        super(job);
        super.registerTargets(new AITarget((IAIState)AIWorkerState.IDLE, AIWorkerState.START_WORKING, 1), new AITarget((IAIState)AIWorkerState.CRUSH, this::crush, 20));
        this.worker.getCitizenExperienceHandler().setSkillModifier(2 * this.worker.getCitizenData().getStrength() + 1 * this.worker.getCitizenData().getEndurance());
        this.worker.func_98053_h(true);
    }

    @Override
    public Class getExpectedBuildingClass() {
        return BuildingCrusher.class;
    }

    @Override
    protected IAIState decide() {
        IAIState nextState = super.decide();
        if (nextState != AIWorkerState.START_WORKING) {
            return nextState;
        }
        return AIWorkerState.CRUSH;
    }

    protected IAIState crush() {
        if (this.walkToBuilding()) {
            return this.getState();
        }
        ((JobCrusher)this.job).setProgress(((JobCrusher)this.job).getProgress() + 20);
        BuildingCrusher crusherBuilding = this.getOwnBuilding(BuildingCrusher.class);
        WorkerUtil.faceBlock(crusherBuilding.getPosition(), this.worker);
        if (this.currentRecipeStorage == null) {
            this.currentRecipeStorage = crusherBuilding.getCurrentRecipe();
        }
        if (this.getState() != AIWorkerState.CRAFT && crusherBuilding.getCurrentDailyQuantity() >= (Integer)crusherBuilding.getCrusherMode().func_76340_b() || this.currentRecipeStorage == null) {
            return AIWorkerState.START_WORKING;
        }
        IAIState check = this.checkForItems(this.currentRecipeStorage);
        if (((JobCrusher)this.job).getProgress() > 50 - Math.min(this.worker.getCitizenExperienceHandler().getLevel() + 1, 50)) {
            ((JobCrusher)this.job).setProgress(0);
            if (check == AIWorkerState.CRAFT) {
                if (this.getState() != AIWorkerState.CRAFT) {
                    crusherBuilding.setCurrentDailyQuantity(crusherBuilding.getCurrentDailyQuantity() + 1);
                    if (crusherBuilding.getCurrentDailyQuantity() >= (Integer)crusherBuilding.getCrusherMode().func_76340_b()) {
                        this.incrementActionsDoneAndDecSaturation();
                    }
                }
                this.worker.func_184609_a(EnumHand.MAIN_HAND);
                ((JobCrusher)this.job).setCraftCounter(((JobCrusher)this.job).getCraftCounter() + 1);
                this.currentRecipeStorage.fullFillRecipe(this.worker.getItemHandlerCitizen());
                this.worker.decreaseSaturationForContinuousAction();
                this.worker.getCitizenExperienceHandler().addExperience(0.1);
            } else {
                if (this.getState() != AIWorkerState.CRAFT) {
                    this.currentRecipeStorage = crusherBuilding.getCurrentRecipe();
                    int requestQty = Math.min(((Integer)crusherBuilding.getCrusherMode().func_76340_b() - crusherBuilding.getCurrentDailyQuantity()) * 2, 64);
                    if (requestQty <= 0) {
                        return AIWorkerState.START_WORKING;
                    }
                    ItemStack stack = this.currentRecipeStorage.getInput().get(0).func_77946_l();
                    stack.func_190920_e(requestQty);
                    this.checkIfRequestForItemExistOrCreateAsynch(stack);
                    return AIWorkerState.START_WORKING;
                }
                return check;
            }
        }
        if (check == AIWorkerState.CRAFT) {
            MineColonies.getNetwork().sendToAllTracking((IMessage)new LocalizedParticleEffectMessage(this.currentRecipeStorage.getInput().get(0).func_77946_l(), crusherBuilding.getID()), (Entity)this.worker);
            MineColonies.getNetwork().sendToAllTracking((IMessage)new LocalizedParticleEffectMessage(this.currentRecipeStorage.getPrimaryOutput().func_77946_l(), crusherBuilding.getID().func_177977_b()), (Entity)this.worker);
            SoundUtils.playSoundAtCitizen(this.world, ((AbstractSchematicProvider)this.getOwnBuilding()).getID(), SoundEvents.field_187835_fT);
        }
        return this.getState();
    }

    @Override
    protected IAIState craft() {
        if (this.currentRecipeStorage == null) {
            this.setDelay(20);
            return AIWorkerState.START_WORKING;
        }
        if (this.walkToBuilding()) {
            this.setDelay(5);
            return this.getState();
        }
        if (((JobCrusher)this.job).getMaxCraftingCount() == 0) {
            PublicCrafting crafting = (PublicCrafting)((JobCrusher)this.job).getCurrentTask().getRequest();
            ((JobCrusher)this.job).setMaxCraftingCount(CraftingUtils.calculateMaxCraftingCount(crafting.getCount(), this.currentRecipeStorage));
        }
        if (((JobCrusher)this.job).getMaxCraftingCount() == 0) {
            ((AbstractCitizenAssignable)this.getOwnBuilding()).getColony().getRequestManager().updateRequestState((IToken<?>)((JobCrusher)this.job).getCurrentTask().getId(), RequestState.CANCELLED);
            ((JobCrusher)this.job).setMaxCraftingCount(0);
            ((JobCrusher)this.job).setCraftCounter(0);
            this.setDelay(20);
            return AIWorkerState.START_WORKING;
        }
        this.currentRequest = ((JobCrusher)this.job).getCurrentTask();
        IAIState nextState = this.crush();
        if (nextState == this.getState()) {
            if (((JobCrusher)this.job).getCraftCounter() >= ((JobCrusher)this.job).getMaxCraftingCount()) {
                ItemStack primaryOutput = this.currentRecipeStorage.getPrimaryOutput();
                primaryOutput.func_190920_e(((PublicCrafting)this.currentRequest.getRequest()).getCount());
                this.currentRequest.addDelivery(primaryOutput);
                this.incrementActionsDoneAndDecSaturation();
                ((JobCrusher)this.job).setMaxCraftingCount(0);
                ((JobCrusher)this.job).setCraftCounter(0);
                this.currentRecipeStorage = null;
                return AIWorkerState.START_WORKING;
            }
        } else {
            ((JobCrusher)this.job).setMaxCraftingCount(0);
            ((JobCrusher)this.job).setCraftCounter(0);
            return AIWorkerState.START_WORKING;
        }
        return this.getState();
    }
}

