/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.entity.ai.citizen.builder;

import com.minecolonies.api.blocks.ModBlocks;
import com.minecolonies.api.colony.buildings.IBuilding;
import com.minecolonies.api.configuration.Configurations;
import com.minecolonies.api.entity.ai.statemachine.AITarget;
import com.minecolonies.api.entity.ai.statemachine.states.AIWorkerState;
import com.minecolonies.api.entity.ai.statemachine.states.IAIState;
import com.minecolonies.api.entity.ai.util.StructureIterator;
import com.minecolonies.api.util.BlockPosUtil;
import com.minecolonies.api.util.BlockUtils;
import com.minecolonies.api.util.EntityUtils;
import com.minecolonies.api.util.InventoryUtils;
import com.minecolonies.api.util.ItemStackUtils;
import com.minecolonies.api.util.MathUtils;
import com.minecolonies.coremod.colony.buildings.AbstractBuildingStructureBuilder;
import com.minecolonies.coremod.colony.buildings.AbstractCitizenAssignable;
import com.minecolonies.coremod.colony.buildings.AbstractSchematicProvider;
import com.minecolonies.coremod.colony.buildings.utils.BuildingBuilderResource;
import com.minecolonies.coremod.colony.buildings.workerbuildings.BuildingBuilder;
import com.minecolonies.coremod.colony.jobs.JobBuilder;
import com.minecolonies.coremod.colony.workorders.WorkOrderBuild;
import com.minecolonies.coremod.colony.workorders.WorkOrderBuildBuilding;
import com.minecolonies.coremod.colony.workorders.WorkOrderBuildDecoration;
import com.minecolonies.coremod.colony.workorders.WorkOrderBuildRemoval;
import com.minecolonies.coremod.entity.ai.basic.AbstractEntityAIStructureWithWorkOrder;
import java.util.ArrayList;
import java.util.function.Predicate;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.InvWrapper;
import org.jetbrains.annotations.NotNull;

public class EntityAIStructureBuilder
extends AbstractEntityAIStructureWithWorkOrder<JobBuilder> {
    private static final int INTELLIGENCE_MULTIPLIER = 2;
    private static final int STRENGTH_MULTIPLIER = 1;
    private static final int DEPTH_LEVEL_0 = 60;
    private static final int DEPTH_LEVEL_1 = 30;
    private static final int MAX_DEPTH_DIFFERENCE = 5;
    private static final int DEPTH_LEVEL_2 = 15;
    private static final double SPEED_BUFF_0 = 0.5;
    private static final int SPEED_BUFF_1 = 2;
    private static final int SPEED_BUFF_2 = 4;
    private static final int ACTIONS_UNTIL_DUMP = 1024;
    private static final int MIN_DISTANCE = 3;
    private static final int MAX_DISTANCE = 10;
    private static final double ACCEPTANCE_DISTANCE = 20.0;
    private static final int LEVEL_TO_PURGE_MOBS = 4;
    private int pickUpCount = 0;

    public EntityAIStructureBuilder(@NotNull JobBuilder job) {
        super(job);
        super.registerTargets(new AITarget((IAIState)AIWorkerState.IDLE, AIWorkerState.START_WORKING, 100), new AITarget(AIWorkerState.START_WORKING, this::checkForWorkOrder, this::startWorkingAtOwnBuilding, 100), new AITarget((IAIState)AIWorkerState.PICK_UP, this::pickUpMaterial, 5));
        this.worker.getCitizenExperienceHandler().setSkillModifier(2 * this.worker.getCitizenData().getIntelligence() + 1 * this.worker.getCitizenData().getStrength());
        this.worker.func_98053_h(true);
    }

    @Override
    public IAIState getStateAfterPickUp() {
        return AIWorkerState.PICK_UP;
    }

    public IAIState pickUpMaterial() {
        BuildingBuilder building = (BuildingBuilder)this.getOwnBuilding();
        ArrayList<Predicate<ItemStack>> neededItemsList = new ArrayList<Predicate<ItemStack>>();
        for (BuildingBuilderResource stack2 : building.getNeededResources().values()) {
            neededItemsList.add(itemstack -> ItemStackUtils.compareItemStacksIgnoreStackSize(stack2.getItemStack(), itemstack, true, true));
        }
        if (neededItemsList.size() <= this.pickUpCount || InventoryUtils.openSlotCount((IItemHandler)new InvWrapper((IInventory)this.worker.getInventoryCitizen())) <= 5L) {
            this.pickUpCount = 0;
            return AIWorkerState.START_WORKING;
        }
        this.needsCurrently = (Predicate)neededItemsList.get(this.pickUpCount);
        ++this.pickUpCount;
        if (this.currentStructure == null) {
            return AIWorkerState.IDLE;
        }
        if (this.currentStructure.getStage() != StructureIterator.Stage.DECORATE) {
            this.needsCurrently = this.needsCurrently.and(stack -> !ItemStackUtils.isDecoration(stack));
        }
        if (InventoryUtils.hasItemInItemHandler((IItemHandler)new InvWrapper((IInventory)this.worker.getInventoryCitizen()), this.needsCurrently)) {
            return this.getState();
        }
        if (InventoryUtils.hasItemInProvider((ICapabilityProvider)building.getTileEntity(), this.needsCurrently)) {
            return AIWorkerState.GATHERING_REQUIRED_MATERIALS;
        }
        return this.pickUpMaterial();
    }

    @Override
    public Class getExpectedBuildingClass() {
        return BuildingBuilder.class;
    }

    private boolean checkForWorkOrder() {
        if (!((JobBuilder)this.job).hasWorkOrder()) {
            this.getOwnBuilding(AbstractBuildingStructureBuilder.class).searchWorkOrder();
            return false;
        }
        WorkOrderBuildDecoration wo = ((JobBuilder)this.job).getWorkOrder();
        if (wo == null) {
            ((JobBuilder)this.job).setWorkOrder(null);
            return false;
        }
        IBuilding building = ((JobBuilder)this.job).getColony().getBuildingManager().getBuilding(wo.getBuildingLocation());
        if (building == null && wo instanceof WorkOrderBuild && !(wo instanceof WorkOrderBuildRemoval)) {
            ((JobBuilder)this.job).complete();
            return false;
        }
        if (!((JobBuilder)this.job).hasStructure()) {
            super.initiate();
        }
        return true;
    }

    @Override
    public IAIState switchStage(IAIState state) {
        if (((JobBuilder)this.job).getWorkOrder() instanceof WorkOrderBuildRemoval && state.equals(AIWorkerState.BUILDING_STEP)) {
            return AIWorkerState.COMPLETE_BUILD;
        }
        return super.switchStage(state);
    }

    private IAIState startWorkingAtOwnBuilding() {
        if (this.walkToBuilding()) {
            return this.getState();
        }
        return AIWorkerState.START_BUILDING;
    }

    private void killMobs() {
        if (((AbstractSchematicProvider)this.getOwnBuilding()).getBuildingLevel() >= 4 && ((JobBuilder)this.job).getWorkOrder() instanceof WorkOrderBuildBuilding) {
            BlockPos buildingPos = ((JobBuilder)this.job).getWorkOrder().getBuildingLocation();
            IBuilding building = this.worker.getCitizenColonyHandler().getColony().getBuildingManager().getBuilding(buildingPos);
            if (building != null) {
                this.world.func_72872_a(EntityMob.class, building.getTargetableArea(this.world)).forEach(Entity::func_70106_y);
            }
        }
    }

    @Override
    public void checkForExtraBuildingActions() {
        if (!this.getOwnBuilding(BuildingBuilder.class).hasPurgedMobsToday()) {
            this.killMobs();
            this.getOwnBuilding(BuildingBuilder.class).setPurgedMobsToday(true);
        }
    }

    @Override
    public IAIState afterRequestPickUp() {
        return AIWorkerState.INVENTORY_FULL;
    }

    @Override
    public IAIState afterDump() {
        return AIWorkerState.PICK_UP;
    }

    @Override
    public boolean walkToConstructionSite(BlockPos targetPos) {
        if (this.workFrom == null || MathUtils.twoDimDistance(targetPos, this.workFrom) < 3.0 || MathUtils.twoDimDistance(targetPos, this.workFrom) > 20.0) {
            this.workFrom = this.getWorkingPosition(targetPos);
        }
        return this.worker.isWorkerAtSiteWithMove(this.workFrom, 10) || MathUtils.twoDimDistance(this.worker.func_180425_c(), this.workFrom) <= 20.0;
    }

    @Override
    public BlockPos getWorkingPosition(BlockPos targetPosition) {
        if (((JobBuilder)this.job).getWorkOrder() != null) {
            BlockPos schemPos = ((JobBuilder)this.job).getWorkOrder().getBuildingLocation();
            int yStart = targetPosition.func_177956_o() > schemPos.func_177956_o() ? targetPosition.func_177956_o() : schemPos.func_177956_o();
            int yEnd = targetPosition.func_177956_o() < schemPos.func_177956_o() ? Math.max(targetPosition.func_177956_o(), schemPos.func_177956_o() - 5) : schemPos.func_177956_o();
            EnumFacing direction = BlockPosUtil.getXZFacing(this.worker.func_180425_c(), targetPosition).func_176734_d();
            for (int i = 4; i < 10; ++i) {
                for (int y = yStart; y >= yEnd; --y) {
                    BlockPos pos = targetPosition.func_177967_a(direction, i);
                    BlockPos basePos = new BlockPos(pos.func_177958_n(), y, pos.func_177952_p());
                    if (!EntityUtils.checkForFreeSpace(this.world, basePos)) continue;
                    return basePos;
                }
            }
            return schemPos.func_177984_a();
        }
        return targetPosition;
    }

    @Override
    public void connectBlockToBuildingIfNecessary(@NotNull IBlockState blockState, @NotNull BlockPos pos) {
        BlockPos buildingLocation = ((JobBuilder)this.job).getWorkOrder().getBuildingLocation();
        IBuilding building = ((AbstractCitizenAssignable)this.getOwnBuilding()).getColony().getBuildingManager().getBuilding(buildingLocation);
        if (building != null) {
            building.registerBlockPosition(blockState, pos, this.world);
        }
        if (blockState.func_177230_c() == ModBlocks.blockWayPoint) {
            this.worker.getCitizenColonyHandler().getColony().addWayPoint(pos, this.world.func_180495_p(pos));
        }
    }

    @Override
    public boolean shallReplaceSolidSubstitutionBlock(Block worldBlock, IBlockState worldMetadata) {
        return false;
    }

    @Override
    public IBlockState getSolidSubstitution(@NotNull BlockPos location) {
        return BlockUtils.getSubstitutionBlockAtWorld(this.world, location);
    }

    @Override
    public int getBlockMiningDelay(@NotNull Block block, @NotNull BlockPos pos) {
        int initialDelay = super.getBlockMiningDelay(block, pos);
        if (pos.func_177956_o() > 60 || !Configurations.gameplay.restrictBuilderUnderground) {
            return (int)((double)initialDelay * 0.5);
        }
        if (pos.func_177956_o() > 30) {
            return initialDelay;
        }
        if (pos.func_177956_o() < 15) {
            return initialDelay * 4;
        }
        return initialDelay * 2;
    }

    @Override
    protected int getActionsDoneUntilDumping() {
        return 1024;
    }
}

