/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.commands.generalcommands;

import com.minecolonies.coremod.commands.AbstractSingleCommand;
import com.minecolonies.coremod.commands.ActionMenuState;
import com.minecolonies.coremod.commands.IActionCommand;
import com.minecolonies.coremod.util.BackUpHelper;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import org.jetbrains.annotations.NotNull;

public class BackupCommand
extends AbstractSingleCommand
implements IActionCommand {
    public static final String DESC = "backup";
    public static final String NO_PERMISSION_MESSAGE = "You do not have permission to backup colony data!";
    public static final String BACKUP_SUCCESS_MESSAGE = "Successfully backed up colony data!";
    public static final String BACKUP_FAILURE_MESSAGE = "Failed to back up colony data!";

    public BackupCommand() {
        super(new String[0]);
    }

    public BackupCommand(String ... parents) {
        super(parents);
    }

    @Override
    public void execute(@NotNull MinecraftServer server, @NotNull ICommandSender sender, @NotNull ActionMenuState actionMenuState) throws CommandException {
        this.executeShared(server, sender);
    }

    @Override
    public void execute(@NotNull MinecraftServer server, @NotNull ICommandSender sender, String ... args) throws CommandException {
        this.executeShared(server, sender);
    }

    private void executeShared(@NotNull MinecraftServer server, @NotNull ICommandSender sender) throws CommandException {
        if (BackupCommand.isPlayerOpped(sender)) {
            server.func_152344_a(() -> {
                if (BackUpHelper.backupColonyData()) {
                    sender.func_145747_a((ITextComponent)new TextComponentString(BACKUP_SUCCESS_MESSAGE));
                } else {
                    sender.func_145747_a((ITextComponent)new TextComponentString(BACKUP_FAILURE_MESSAGE));
                }
            });
        } else {
            sender.func_145747_a((ITextComponent)new TextComponentString(NO_PERMISSION_MESSAGE));
        }
    }

    @Override
    @NotNull
    public List<String> getTabCompletionOptions(@NotNull MinecraftServer server, @NotNull ICommandSender sender, @NotNull String[] args, @Nullable BlockPos pos) {
        return Collections.emptyList();
    }

    @Override
    public boolean isUsernameIndex(@NotNull String[] args, int index) {
        return false;
    }
}

