/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.commands.colonycommands;

import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.IColonyManager;
import com.minecolonies.api.colony.permissions.Action;
import com.minecolonies.coremod.commands.AbstractSingleCommand;
import com.minecolonies.coremod.commands.ActionMenuState;
import com.minecolonies.coremod.commands.IActionCommand;
import com.minecolonies.coremod.util.TeleportToColony;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.World;
import org.jetbrains.annotations.NotNull;

public final class ColonyTeleportCommand
extends AbstractSingleCommand
implements IActionCommand {
    public static final String DESC = "teleport";
    private static final double MIN_DISTANCE_TO_TH = 20.0;

    public ColonyTeleportCommand() {
        super(new String[0]);
    }

    public ColonyTeleportCommand(String ... parents) {
        super(parents);
    }

    @Override
    @NotNull
    public String getCommandUsage(@NotNull ICommandSender sender) {
        return super.getCommandUsage(sender) + "colonytp<colID>";
    }

    @Override
    public boolean canRankUseCommand(@NotNull IColony colony, @NotNull EntityPlayer player) {
        return colony.getPermissions().hasPermission(player, Action.TELEPORT_TO_COLONY);
    }

    @Override
    public void execute(@NotNull MinecraftServer server, @NotNull ICommandSender sender, @NotNull ActionMenuState actionMenuState) throws CommandException {
        EntityPlayerMP player;
        IColony colony = actionMenuState.getColonyForArgument("colony");
        if (null == colony && (player = actionMenuState.getPlayerForArgument("player")) != null) {
            Entity senderEntity;
            IColony iColony = IColonyManager.getInstance().getIColonyByOwner(server.func_130014_f_(), (EntityPlayer)player);
            if (null == iColony && sender instanceof EntityPlayer && (senderEntity = sender.func_174793_f()) != null) {
                UUID mayorID = senderEntity.func_110124_au();
                if (iColony == null) {
                    iColony = IColonyManager.getInstance().getIColonyByOwner(sender.func_130014_f_(), mayorID);
                }
            }
            if (null != iColony) {
                colony = IColonyManager.getInstance().getColonyByWorld(iColony.getID(), (World)server.func_71218_a(sender.func_130014_f_().field_73011_w.getDimension()));
            }
        }
        if (null == colony) {
            sender.func_145747_a((ITextComponent)new TextComponentString("You are not allowed to do this"));
            return;
        }
        this.executeShared(server, sender, colony);
    }

    @Override
    public void execute(@NotNull MinecraftServer server, @NotNull ICommandSender sender, String ... args) throws CommandException {
        IColony colony = null;
        if (args.length == 1) {
            int colonyId = ColonyTeleportCommand.getColonyIdFromArg(args, 0, -1);
            int dimensionId = ColonyTeleportCommand.getDimensionIdFromArg(args, 0, 0);
            if (colonyId != -1) {
                colony = IColonyManager.getInstance().getColonyByWorld(colonyId, (World)server.func_71218_a(dimensionId));
            }
        }
        if (null == colony) {
            sender.func_145747_a((ITextComponent)new TextComponentString("You are not allowed to do this"));
            return;
        }
        this.executeShared(server, sender, colony);
    }

    private void executeShared(@NotNull MinecraftServer server, @NotNull ICommandSender sender, @NotNull IColony colony) {
        if (sender instanceof EntityPlayer && this.canPlayerUseCommand((EntityPlayer)sender, AbstractSingleCommand.Commands.COLONYTP, colony.getID())) {
            IColony colonyIn = IColonyManager.getInstance().getColonyByPosFromWorld((World)server.func_71218_a(colony.getDimension()), sender.func_180425_c());
            if (ColonyTeleportCommand.isPlayerOpped(sender) || colonyIn != null && colonyIn.hasTownHall() && colonyIn.getPermissions().hasPermission((EntityPlayer)sender, Action.TELEPORT_TO_COLONY) && ((EntityPlayer)sender).func_174818_b(colonyIn.getBuildingManager().getTownHall().getPosition()) < 20.0) {
                TeleportToColony.colonyTeleport(server, sender, colony.getDimension() + "|" + colony.getID());
            }
            return;
        }
        sender.func_145747_a((ITextComponent)new TextComponentString("You are not allowed to do this"));
    }

    @Override
    @NotNull
    public List<String> getTabCompletionOptions(@NotNull MinecraftServer server, @NotNull ICommandSender sender, @NotNull String[] args, BlockPos pos) {
        return Collections.emptyList();
    }

    @Override
    public boolean isUsernameIndex(@NotNull String[] args, int index) {
        return index == 0;
    }
}

