/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.commands.citizencommands;

import com.minecolonies.api.colony.ICitizenData;
import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.IColonyManager;
import com.minecolonies.coremod.commands.AbstractSingleCommand;
import com.minecolonies.coremod.commands.ActionMenuState;
import com.minecolonies.coremod.commands.IActionCommand;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.World;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractCitizensCommands
extends AbstractSingleCommand
implements IActionCommand {
    private static final String NO_ARGUMENTS = "Please define a valid citizen and/or colony";

    public AbstractCitizensCommands(String ... parents) {
        super(parents);
    }

    @Override
    public void execute(@NotNull MinecraftServer server, @NotNull ICommandSender sender, @NotNull ActionMenuState actionMenuState) throws CommandException {
        IColony colony = actionMenuState.getColonyForArgument("colony");
        if (colony == null) {
            sender.func_145747_a((ITextComponent)new TextComponentString(NO_ARGUMENTS));
            return;
        }
        ICitizenData citizenData = actionMenuState.getCitizenForArgument("citizen");
        if (null == citizenData && this.requiresCitizen()) {
            sender.func_145747_a((ITextComponent)new TextComponentString(NO_ARGUMENTS));
            return;
        }
        int citizenId = citizenData == null ? -1 : citizenData.getId();
        this.executeSpecializedCode(server, sender, colony, citizenId);
    }

    @Override
    @NotNull
    public String getCommandUsage(@NotNull ICommandSender sender) {
        return super.getCommandUsage(sender) + "<ColonyId> <CitizenId>";
    }

    @Override
    @NotNull
    public void execute(@NotNull MinecraftServer server, @NotNull ICommandSender sender, String ... args) throws CommandException {
        EntityPlayer player;
        IColony colony;
        IColony tempColony;
        if (args.length == 0) {
            sender.func_145747_a((ITextComponent)new TextComponentString(NO_ARGUMENTS));
            return;
        }
        boolean firstArgumentColonyId = true;
        int colonyId = -1;
        if (args.length >= 2 && (colonyId = AbstractCitizensCommands.getIthArgument(args, 0, -1)) == -1) {
            EntityPlayer player2 = server.func_130014_f_().func_72924_a(args[0]);
            if (player2 != null && (tempColony = IColonyManager.getInstance().getIColonyByOwner(server.func_130014_f_(), player2)) != null) {
                colonyId = tempColony.getID();
            }
            firstArgumentColonyId = false;
        }
        if (sender instanceof EntityPlayer && colonyId == -1 && (tempColony = IColonyManager.getInstance().getIColonyByOwner(sender.func_130014_f_(), (EntityPlayer)sender)) != null) {
            colonyId = tempColony.getID();
            firstArgumentColonyId = false;
        }
        if ((colony = IColonyManager.getInstance().getColonyByWorld(colonyId, (World)server.func_71218_a(sender.func_130014_f_().field_73011_w.getDimension()))) == null) {
            sender.func_145747_a((ITextComponent)new TextComponentString(NO_ARGUMENTS));
            return;
        }
        if (sender instanceof EntityPlayer && !this.canPlayerUseCommand(player = (EntityPlayer)sender, this.getCommand(), colonyId)) {
            sender.func_145747_a((ITextComponent)new TextComponentString("You are not allowed to do that!"));
            return;
        }
        int citizenId = -1;
        if (this.requiresCitizen() && ((citizenId = AbstractCitizensCommands.getValidCitizenId(colony, firstArgumentColonyId, args)) == -1 || colony.getCitizenManager().getCitizen(citizenId) == null) && this.requiresCitizen()) {
            sender.func_145747_a((ITextComponent)new TextComponentString(NO_ARGUMENTS));
            return;
        }
        this.executeSpecializedCode(server, sender, colony, citizenId);
    }

    @Override
    @NotNull
    public List<String> getTabCompletionOptions(@NotNull MinecraftServer server, @NotNull ICommandSender sender, @NotNull String[] args, @Nullable BlockPos pos) {
        return Collections.emptyList();
    }

    @Override
    public boolean isUsernameIndex(@NotNull String[] args, int index) {
        return false;
    }

    public abstract AbstractSingleCommand.Commands getCommand();

    private static int getValidCitizenId(IColony colony, boolean firstArgumentColonyId, String ... args) {
        int citizenId;
        int offset = 0;
        if (firstArgumentColonyId) {
            offset = 1;
        }
        if ((citizenId = AbstractCitizensCommands.getIthArgument(args, offset, -1)) == -1) {
            if (args.length >= offset + 2) {
                String citizenName = args[offset] + " " + args[offset + 1] + " " + args[offset + 2];
                for (int i = 1; i <= colony.getCitizenManager().getCitizens().size(); ++i) {
                    if (!colony.getCitizenManager().getCitizen(i).getName().equals(citizenName)) continue;
                    return i;
                }
            }
            return citizenId;
        }
        return citizenId;
    }

    protected boolean requiresCitizen() {
        return true;
    }

    public abstract void executeSpecializedCode(@NotNull MinecraftServer var1, @NotNull ICommandSender var2, @NotNull IColony var3, int var4);
}

