/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.commands;

import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.IColonyManager;
import com.minecolonies.api.configuration.Configurations;
import com.minecolonies.coremod.colony.permissions.ForgePermissionNodes;
import com.minecolonies.coremod.commands.AbstractCommandParser;
import com.minecolonies.coremod.commands.AbstractSingleCommand;
import com.minecolonies.coremod.commands.NavigationMenuType;
import com.mojang.authlib.GameProfile;
import java.util.List;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.server.permission.PermissionAPI;
import net.minecraftforge.server.permission.context.IContext;
import net.minecraftforge.server.permission.context.PlayerContext;
import org.jetbrains.annotations.NotNull;

public class CommandEntryPointNew
extends AbstractCommandParser {
    @Override
    protected ForgeCommandsPermissionsChecker getPermissionsChecker() {
        return new ForgeCommandsPermissionsChecker();
    }

    @Override
    protected NavigationMenuType getRootNavigationMenuType() {
        return NavigationMenuType.MINECOLONIES;
    }

    @Override
    protected AbstractCommandParser.ModuleContext getModuleContext() {
        return new AbstractCommandParser.ModuleContext(){

            @Override
            public <T> T get(Class<? extends T> type) {
                if (MineColonyDataProvider.class == type) {
                    return type.cast(new MineColonyDataProvider());
                }
                return null;
            }
        };
    }

    public class ForgeCommandsPermissionsChecker
    implements AbstractCommandParser.PermissionsChecker {
        @Override
        public boolean hasPermission(ForgePermissionNodes forgePermissionNode, EntityPlayer player) {
            return PermissionAPI.hasPermission((GameProfile)player.func_146103_bH(), (String)forgePermissionNode.getNodeName(), (IContext)new PlayerContext(player));
        }

        @Override
        public boolean canUseCommands(@NotNull MinecraftServer server, @NotNull ICommandSender sender) {
            if (sender instanceof EntityPlayer) {
                return AbstractSingleCommand.isPlayerOpped(sender) || Configurations.gameplay.opLevelForServer <= 0;
            }
            return true;
        }
    }

    public class MineColonyDataProvider {
        public List<IColony> getColonies() {
            return IColonyManager.getInstance().getAllColonies();
        }

        public IColony getIColonyByOwner(World entityWorld, EntityPlayer sender) {
            return IColonyManager.getInstance().getIColonyByOwner(entityWorld, sender);
        }

        public IColony getColony(int colonyNumber, int dimension) {
            return IColonyManager.getInstance().getColonyByWorld(colonyNumber, (World)FMLCommonHandler.instance().getMinecraftServerInstance().func_71218_a(dimension));
        }
    }
}

