/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.commands;

import com.minecolonies.coremod.commands.ActionArgumentType;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import org.jetbrains.annotations.NotNull;

public class ActionArgument {
    @NotNull
    private final String name;
    @NotNull
    private final ActionArgumentType type;
    private final boolean required;
    @Nullable
    private final List<ActionArgument> actionArgumentList;

    public ActionArgument(@NotNull String name, @NotNull ActionArgumentType type, ActionArgumentType.Is optionalOrRequired, ActionArgument ... actionArguments) {
        this.name = name;
        this.type = type;
        this.required = optionalOrRequired == ActionArgumentType.Is.REQUIRED;
        this.actionArgumentList = Arrays.asList(actionArguments);
    }

    public String getName() {
        return this.name;
    }

    public ActionArgumentType getType() {
        return this.type;
    }

    public boolean isRequired() {
        return this.required;
    }

    public List<ActionArgument> getActionArgumentList() {
        return Collections.unmodifiableList(this.actionArgumentList);
    }

    public String getUsage() {
        StringBuilder sb = new StringBuilder();
        if (this.isRequired()) {
            sb.append('<');
        } else {
            sb.append('[');
        }
        sb.append(this.name).append(": ").append(this.type.getUsageValue());
        if (this.isRequired()) {
            sb.append('>');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.actionArgumentList == null ? 0 : this.actionArgumentList.hashCode());
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.required ? 1231 : 1237);
        result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ActionArgument other = (ActionArgument)obj;
        if (this.actionArgumentList == null ? other.actionArgumentList != null : !this.actionArgumentList.equals(other.actionArgumentList)) {
            return false;
        }
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        if (this.required != other.required) {
            return false;
        }
        return this.type == other.type;
    }

    public String toString() {
        return "ActionArgument [name=" + this.name + ", type=" + (Object)((Object)this.type) + ", required=" + this.required + ", actionArgumentList=" + this.actionArgumentList + "]";
    }
}

