/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.colony.workorders;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.minecolonies.api.colony.ICitizenData;
import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.workorders.IWorkManager;
import com.minecolonies.api.colony.workorders.IWorkOrder;
import com.minecolonies.api.colony.workorders.WorkOrderType;
import com.minecolonies.api.colony.workorders.WorkOrderView;
import com.minecolonies.api.util.BlockPosUtil;
import com.minecolonies.api.util.Log;
import com.minecolonies.coremod.colony.buildings.workerbuildings.BuildingBuilder;
import com.minecolonies.coremod.colony.workorders.WorkManager;
import com.minecolonies.coremod.colony.workorders.WorkOrderBuild;
import com.minecolonies.coremod.colony.workorders.WorkOrderBuildBuilding;
import com.minecolonies.coremod.colony.workorders.WorkOrderBuildDecoration;
import com.minecolonies.coremod.colony.workorders.WorkOrderBuildMiner;
import com.minecolonies.coremod.colony.workorders.WorkOrderBuildRemoval;
import io.netty.buffer.ByteBuf;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractWorkOrder
implements IWorkOrder {
    private static final String TAG_BUILDING = "building";
    private static final String TAG_TYPE = "type";
    private static final String TAG_TH_PRIORITY = "priority";
    private static final String TAG_ID = "id";
    private static final String TAG_CLAIMED_BY = "claimedBy";
    private static final String TAG_CLAIMED_BY_BUILDING = "claimedByBuilding";
    @NotNull
    private static final BiMap<String, Class<? extends IWorkOrder>> nameToClassBiMap = HashBiMap.create();
    protected int id;
    private BlockPos claimedBy;
    private int priority;
    private boolean changed = false;
    protected BlockPos buildingLocation;

    private static void addMapping(String name, @NotNull Class<? extends IWorkOrder> orderClass) {
        if (nameToClassBiMap.containsKey((Object)name)) {
            throw new IllegalArgumentException("Duplicate type '" + name + "' when adding Work Order class mapping");
        }
        try {
            if (orderClass.getDeclaredConstructor(new Class[0]) != null) {
                nameToClassBiMap.put((Object)name, orderClass);
                nameToClassBiMap.inverse().put(orderClass, (Object)name);
            }
        }
        catch (NoSuchMethodException exception) {
            throw new IllegalArgumentException("Missing constructor for type '" + name + "' when adding Work Order class mapping", exception);
        }
    }

    public static AbstractWorkOrder createFromNBT(@NotNull NBTTagCompound compound, WorkManager manager) {
        AbstractWorkOrder order = null;
        Class oclass = null;
        try {
            oclass = (Class)nameToClassBiMap.get((Object)compound.func_74779_i(TAG_TYPE));
            if (oclass != null) {
                Constructor constructor = oclass.getDeclaredConstructor(new Class[0]);
                order = (AbstractWorkOrder)constructor.newInstance(new Object[0]);
            }
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            Log.getLogger().trace((Object)e);
        }
        if (order == null) {
            Log.getLogger().warn(String.format("Unknown WorkOrder type '%s' or missing constructor of proper format.", compound.func_74779_i(TAG_TYPE)));
            return null;
        }
        try {
            if (compound.func_74764_b(TAG_TH_PRIORITY)) {
                order.setPriority(compound.func_74762_e(TAG_TH_PRIORITY));
            }
            order.readFromNBT(compound, manager);
        }
        catch (RuntimeException ex) {
            Log.getLogger().error(String.format("A WorkOrder %s(%s) has thrown an exception during loading, its state cannot be restored. Report this to the mod author", compound.func_74779_i(TAG_TYPE), oclass.getName()), (Throwable)ex);
            return null;
        }
        return order;
    }

    @Override
    public void readFromNBT(@NotNull NBTTagCompound compound, IWorkManager manager) {
        this.id = compound.func_74762_e(TAG_ID);
        if (compound.func_74764_b(TAG_TH_PRIORITY)) {
            this.priority = compound.func_74762_e(TAG_TH_PRIORITY);
        }
        if (compound.func_74764_b(TAG_CLAIMED_BY)) {
            ICitizenData data;
            int citizenId = compound.func_74762_e(TAG_CLAIMED_BY);
            if (manager.getColony() != null && (data = manager.getColony().getCitizenManager().getCitizen(citizenId)) != null && data.getWorkBuilding() != null) {
                this.claimedBy = data.getWorkBuilding().getPosition();
            }
        } else if (compound.func_74764_b(TAG_CLAIMED_BY_BUILDING)) {
            this.claimedBy = BlockPosUtil.readFromNBT(compound, TAG_CLAIMED_BY_BUILDING);
        }
        this.buildingLocation = BlockPosUtil.readFromNBT(compound, TAG_BUILDING);
    }

    @Nullable
    public static WorkOrderView createWorkOrderView(ByteBuf buf) {
        WorkOrderView workOrderView = new WorkOrderView();
        try {
            workOrderView.deserialize(buf);
        }
        catch (RuntimeException ex) {
            Log.getLogger().error(String.format("A WorkOrder.View for #%d has thrown an exception during loading, its state cannot be restored. Report this to the mod author", workOrderView.getId()), (Throwable)ex);
            workOrderView = null;
        }
        return workOrderView;
    }

    @Override
    public int getPriority() {
        return this.priority;
    }

    @Override
    public void setPriority(int priority) {
        this.priority = priority;
    }

    @Override
    public boolean hasChanged() {
        return this.changed;
    }

    @Override
    public void resetChange() {
        this.changed = false;
    }

    @Override
    public int getID() {
        return this.id;
    }

    @Override
    public void setID(int id) {
        this.id = id;
    }

    @Override
    public boolean isClaimed() {
        return this.claimedBy != null;
    }

    @Override
    public boolean isClaimedBy(@NotNull ICitizenData citizen) {
        if (citizen.getWorkBuilding() != null) {
            return citizen.getWorkBuilding().equals(this.claimedBy);
        }
        return false;
    }

    @Override
    public BlockPos getClaimedBy() {
        return this.claimedBy;
    }

    @Override
    public void setClaimedBy(@Nullable ICitizenData citizen) {
        this.changed = true;
        this.claimedBy = citizen != null && citizen.getWorkBuilding() != null ? citizen.getWorkBuilding().getPosition() : null;
    }

    @Override
    public void setClaimedBy(BlockPos builder) {
        this.claimedBy = builder;
    }

    @Override
    public void clearClaimedBy() {
        this.changed = true;
        this.claimedBy = null;
    }

    @Override
    public void writeToNBT(@NotNull NBTTagCompound compound) {
        String s = (String)nameToClassBiMap.inverse().get(this.getClass());
        if (s == null) {
            throw new IllegalStateException(this.getClass() + " is missing a mapping! This is a bug!");
        }
        compound.func_74768_a(TAG_TH_PRIORITY, this.priority);
        compound.func_74778_a(TAG_TYPE, s);
        compound.func_74768_a(TAG_ID, this.id);
        if (this.claimedBy != null) {
            BlockPosUtil.writeToNBT(compound, TAG_CLAIMED_BY_BUILDING, this.claimedBy);
        }
        BlockPosUtil.writeToNBT(compound, TAG_BUILDING, this.buildingLocation);
    }

    @Override
    public boolean isValid(IColony colony) {
        return true;
    }

    @Override
    public void serializeViewNetworkData(@NotNull ByteBuf buf) {
        buf.writeInt(this.id);
        buf.writeInt(this.priority);
        BlockPosUtil.writeToByteBuf(buf, this.claimedBy == null ? BlockPos.field_177992_a : this.claimedBy);
        buf.writeInt(this.getType().ordinal());
        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.getValue());
        BlockPosUtil.writeToByteBuf(buf, this.buildingLocation == null ? BlockPos.field_177992_a : this.buildingLocation);
    }

    @NotNull
    protected abstract WorkOrderType getType();

    protected abstract String getValue();

    @Override
    public void onAdded(IColony colony, boolean readingFromNbt) {
    }

    @Override
    public void onCompleted(IColony colony) {
    }

    @Override
    public void onRemoved(IColony colony) {
    }

    @Override
    public boolean canBeResolved(IColony colony, int level) {
        return colony.getBuildingManager().getBuildings().values().stream().anyMatch(building -> building instanceof BuildingBuilder && building.getMainCitizen() != null && building.getBuildingLevel() >= level);
    }

    @Override
    public boolean tooFarFromAnyBuilder(IColony colony, int level) {
        return false;
    }

    static {
        AbstractWorkOrder.addMapping("build", WorkOrderBuild.class);
        AbstractWorkOrder.addMapping("decoration", WorkOrderBuildDecoration.class);
        AbstractWorkOrder.addMapping("removal", WorkOrderBuildRemoval.class);
        AbstractWorkOrder.addMapping(TAG_BUILDING, WorkOrderBuildBuilding.class);
        AbstractWorkOrder.addMapping("miner", WorkOrderBuildMiner.class);
    }
}

