/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.colony.requestsystem.resolvers;

import com.google.common.collect.Lists;
import com.google.common.reflect.TypeToken;
import com.minecolonies.api.colony.requestsystem.location.ILocation;
import com.minecolonies.api.colony.requestsystem.manager.IRequestManager;
import com.minecolonies.api.colony.requestsystem.request.IRequest;
import com.minecolonies.api.colony.requestsystem.request.RequestState;
import com.minecolonies.api.colony.requestsystem.requestable.Delivery;
import com.minecolonies.api.colony.requestsystem.requestable.IDeliverable;
import com.minecolonies.api.colony.requestsystem.token.IToken;
import com.minecolonies.api.util.ItemStackUtils;
import com.minecolonies.api.util.constant.TypeConstants;
import com.minecolonies.blockout.Log;
import com.minecolonies.coremod.colony.Colony;
import com.minecolonies.coremod.colony.buildings.workerbuildings.BuildingWareHouse;
import com.minecolonies.coremod.colony.requestsystem.resolvers.core.AbstractRequestResolver;
import com.minecolonies.coremod.tileentities.TileEntityWareHouse;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WarehouseRequestResolver
extends AbstractRequestResolver<IDeliverable> {
    public WarehouseRequestResolver(@NotNull ILocation location, @NotNull IToken<?> token) {
        super(location, token);
    }

    @Override
    public TypeToken<? extends IDeliverable> getRequestType() {
        return TypeConstants.DELIVERABLE;
    }

    @Override
    public boolean canResolveRequest(@NotNull IRequestManager manager, IRequest<? extends IDeliverable> requestToCheck) {
        if (!manager.getColony().getWorld().field_72995_K) {
            if (!this.isRequestChainValid(manager, requestToCheck)) {
                return false;
            }
            Colony colony = (Colony)manager.getColony();
            Set<TileEntityWareHouse> wareHouses = WarehouseRequestResolver.getWareHousesInColony(colony);
            wareHouses.removeIf(Objects::isNull);
            try {
                return wareHouses.stream().anyMatch(wareHouse -> wareHouse.hasMatchingItemStackInWarehouse(itemStack -> ((IDeliverable)requestToCheck.getRequest()).matches((ItemStack)itemStack), ((IDeliverable)requestToCheck.getRequest()).getCount()));
            }
            catch (Exception e) {
                Log.getLogger().error((Object)e);
            }
        }
        return false;
    }

    public boolean isRequestChainValid(@NotNull IRequestManager manager, IRequest<?> requestToCheck) {
        if (requestToCheck.getRequester() instanceof WarehouseRequestResolver) {
            return false;
        }
        if (!requestToCheck.hasParent()) {
            return true;
        }
        IRequest<?> parentRequest = manager.getRequestForToken((IToken<?>)requestToCheck.getParent());
        if (parentRequest == null) {
            return true;
        }
        return this.isRequestChainValid(manager, parentRequest);
    }

    @Override
    @Nullable
    public List<IToken<?>> attemptResolveRequest(@NotNull IRequestManager manager, @NotNull IRequest<? extends IDeliverable> request) {
        if (manager.getColony().getWorld().field_72995_K) {
            return Lists.newArrayList();
        }
        if (!(manager.getColony() instanceof Colony)) {
            return Lists.newArrayList();
        }
        Colony colony = (Colony)manager.getColony();
        Set<TileEntityWareHouse> wareHouses = WarehouseRequestResolver.getWareHousesInColony(colony);
        int totalRequested = request.getRequest().getCount();
        int totalAvailable = wareHouses.stream().map(wareHouse -> wareHouse.getMatchingItemStacksInWarehouse(itemStack -> ((IDeliverable)request.getRequest()).matches((ItemStack)itemStack))).filter(itemStacks -> !itemStacks.isEmpty()).flatMap(Collection::stream).mapToInt(ItemStack::func_190916_E).sum();
        if (totalAvailable >= totalRequested) {
            return Lists.newArrayList();
        }
        int totalRemainingRequired = totalRequested - totalAvailable;
        IDeliverable remainingRequest = request.getRequest().copyWithCount(totalRemainingRequired);
        return Lists.newArrayList((Object[])new IToken[]{manager.createRequest(this, remainingRequest)});
    }

    @Override
    public void resolveRequest(@NotNull IRequestManager manager, @NotNull IRequest<? extends IDeliverable> request) {
        manager.updateRequestState((IToken<?>)request.getId(), RequestState.RESOLVED);
    }

    @Override
    @Nullable
    public List<IRequest<?>> getFollowupRequestForCompletion(@NotNull IRequestManager manager, @NotNull IRequest<? extends IDeliverable> completedRequest) {
        if (manager.getColony().getWorld().field_72995_K) {
            return null;
        }
        Colony colony = (Colony)manager.getColony();
        Set<TileEntityWareHouse> wareHouses = WarehouseRequestResolver.getWareHousesInColony(colony);
        ArrayList deliveries = Lists.newArrayList();
        int remainingCount = completedRequest.getRequest().getCount();
        block0: for (TileEntityWareHouse wareHouse : wareHouses) {
            List<ItemStack> targetStacks = wareHouse.getMatchingItemStacksInWarehouse(itemStack -> ((IDeliverable)completedRequest.getRequest()).matches((ItemStack)itemStack));
            for (ItemStack stack : targetStacks) {
                if (ItemStackUtils.isEmpty(stack).booleanValue()) continue;
                ItemStack matchingStack = stack.func_77946_l();
                matchingStack.func_190920_e(Math.min(remainingCount, matchingStack.func_190916_E()));
                ItemStack deliveryStack = matchingStack.func_77946_l();
                completedRequest.addDelivery(deliveryStack.func_77946_l());
                BlockPos itemStackPos = wareHouse.getPositionOfChestWithItemStack(itemStack -> ItemStack.func_179545_c((ItemStack)itemStack, (ItemStack)deliveryStack));
                ILocation itemStackLocation = manager.getFactoryController().getNewInstance(TypeConstants.ILOCATION, itemStackPos, wareHouse.func_145831_w().field_73011_w.getDimension());
                Delivery delivery = new Delivery(itemStackLocation, completedRequest.getRequester().getLocation(), deliveryStack.func_77946_l());
                IToken<?> requestToken = manager.createRequest(new WarehouseRequestResolver(completedRequest.getRequester().getLocation(), (IToken<?>)completedRequest.getId()), delivery);
                deliveries.add(manager.getRequestForToken(requestToken));
                if ((remainingCount -= ItemStackUtils.getSize(matchingStack)) > 0) continue;
                break block0;
            }
        }
        return deliveries.isEmpty() ? null : deliveries;
    }

    @Override
    @Nullable
    public void onAssignedRequestBeingCancelled(@NotNull IRequestManager manager, @NotNull IRequest<? extends IDeliverable> request) {
    }

    @Override
    public void onAssignedRequestCancelled(@NotNull IRequestManager manager, @NotNull IRequest<? extends IDeliverable> request) {
    }

    private static Set<TileEntityWareHouse> getWareHousesInColony(Colony colony) {
        return colony.getBuildingManager().getBuildings().values().stream().filter(building -> building instanceof BuildingWareHouse).map(building -> (TileEntityWareHouse)building.getTileEntity()).collect(Collectors.toSet());
    }

    @Override
    public void onRequestedRequestComplete(@NotNull IRequestManager manager, @NotNull IRequest<?> request) {
    }

    @Override
    public void onRequestedRequestCancelled(@NotNull IRequestManager manager, @NotNull IRequest<?> request) {
    }

    @Override
    @NotNull
    public ITextComponent getRequesterDisplayName(@NotNull IRequestManager manager, @NotNull IRequest<?> request) {
        return new TextComponentTranslation("com.minecolonies.coremod.buildings.warehouse.name", new Object[0]);
    }

    @Override
    public int getPriority() {
        return 150;
    }
}

