/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.colony.requestsystem.requesters;

import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.IColonyManager;
import com.minecolonies.api.colony.requestsystem.factory.IFactoryController;
import com.minecolonies.api.colony.requestsystem.location.ILocation;
import com.minecolonies.api.colony.requestsystem.manager.IRequestManager;
import com.minecolonies.api.colony.requestsystem.request.IRequest;
import com.minecolonies.api.colony.requestsystem.requester.IRequester;
import com.minecolonies.api.colony.requestsystem.token.IToken;
import com.minecolonies.coremod.MineColonies;
import com.minecolonies.coremod.colony.requestsystem.requesters.IBuildingBasedRequester;
import java.util.Optional;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.World;
import org.jetbrains.annotations.NotNull;

public class BuildingBasedRequester
implements IBuildingBasedRequester {
    private static final String NBT_LOCATION = "Location";
    private static final String NBT_ID = "Id";
    private final ILocation location;
    private final IToken<?> requesterId;
    private IRequester building = null;

    public BuildingBasedRequester(ILocation location, IToken<?> requesterId) {
        this.location = location;
        this.requesterId = requesterId;
    }

    public static BuildingBasedRequester deserialize(IFactoryController controller, NBTTagCompound compound) {
        ILocation location = (ILocation)controller.deserialize(compound.func_74775_l(NBT_LOCATION));
        IToken token = (IToken)controller.deserialize(compound.func_74775_l(NBT_ID));
        return new BuildingBasedRequester(location, token);
    }

    public NBTTagCompound serialize(IFactoryController controller) {
        NBTTagCompound compound = new NBTTagCompound();
        compound.func_74782_a(NBT_LOCATION, (NBTBase)controller.serialize(this.getLocation()));
        compound.func_74782_a(NBT_ID, (NBTBase)controller.serialize(this.getId()));
        return compound;
    }

    @Override
    public IToken<?> getId() {
        return this.requesterId;
    }

    @Override
    @NotNull
    public ILocation getLocation() {
        return this.location;
    }

    @Override
    public void onRequestedRequestComplete(@NotNull IRequestManager manager, @NotNull IRequest<?> request) {
        this.getBuilding(manager, (IToken<?>)request.getId()).ifPresent(requester -> requester.onRequestedRequestComplete(manager, request));
    }

    @Override
    public void onRequestedRequestCancelled(@NotNull IRequestManager manager, @NotNull IRequest<?> request) {
        this.getBuilding(manager, (IToken<?>)request.getId()).ifPresent(requester -> requester.onRequestedRequestCancelled(manager, request));
    }

    @Override
    @NotNull
    public ITextComponent getRequesterDisplayName(@NotNull IRequestManager manager, @NotNull IRequest<?> request) {
        return this.getBuilding(manager, (IToken<?>)request.getId()).map(requester -> requester.getRequesterDisplayName(manager, request)).orElseGet(() -> new TextComponentString("<UNKNOWN>"));
    }

    @Override
    public Optional<IRequester> getBuilding(@NotNull IRequestManager manager, @NotNull IToken<?> token) {
        this.updateBuilding();
        return Optional.ofNullable(this.building);
    }

    private void updateBuilding() {
        if (this.building != null || this.location == null) {
            return;
        }
        World world = MineColonies.proxy.getWorld(this.location.getDimension());
        IColony colony = IColonyManager.getInstance().getClosestIColony(world, this.location.getInDimensionLocation());
        if (colony == null) {
            return;
        }
        this.building = colony.getRequesterBuildingForPosition(this.location.getInDimensionLocation());
    }
}

