/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.colony.managers;

import com.minecolonies.api.colony.ICitizen;
import com.minecolonies.api.colony.ICitizenData;
import com.minecolonies.api.colony.ICitizenDataManager;
import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.buildings.IBuilding;
import com.minecolonies.api.colony.buildings.IBuildingWorker;
import com.minecolonies.api.colony.managers.interfaces.ICitizenManager;
import com.minecolonies.api.configuration.Configurations;
import com.minecolonies.api.entity.citizen.AbstractEntityCitizen;
import com.minecolonies.api.util.EntityUtils;
import com.minecolonies.api.util.LanguageHandler;
import com.minecolonies.api.util.NBTUtils;
import com.minecolonies.coremod.MineColonies;
import com.minecolonies.coremod.colony.CitizenData;
import com.minecolonies.coremod.colony.Colony;
import com.minecolonies.coremod.colony.buildings.AbstractBuildingGuards;
import com.minecolonies.coremod.colony.buildings.workerbuildings.BuildingHome;
import com.minecolonies.coremod.colony.jobs.AbstractJobGuard;
import com.minecolonies.coremod.entity.citizen.EntityCitizen;
import com.minecolonies.coremod.network.messages.ColonyViewCitizenViewMessage;
import com.minecolonies.coremod.network.messages.ColonyViewRemoveCitizenMessage;
import com.minecolonies.coremod.network.messages.HappinessDataMessage;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CitizenManager
implements ICitizenManager {
    @NotNull
    private final Map<Integer, ICitizenData> citizens = new HashMap<Integer, ICitizenData>();
    private boolean isCitizensDirty = false;
    private int topCitizenId = 0;
    private int maxCitizens = 0;
    private int potentialMaxCitizens;
    private final Colony colony;
    private int respawnInterval;

    public CitizenManager(Colony colony) {
        this.respawnInterval = Configurations.gameplay.citizenRespawnInterval * 20;
        this.colony = colony;
    }

    @Override
    public void readFromNBT(@NotNull NBTTagCompound compound) {
        this.citizens.clear();
        this.citizens.putAll(NBTUtils.streamCompound(compound.func_150295_c("citizens", 10)).map(this::deserializeCitizen).collect(Collectors.toMap(ICitizen::getId, Function.identity())));
        this.colony.updateHasChilds();
    }

    private ICitizenData deserializeCitizen(@NotNull NBTTagCompound compound) {
        ICitizenData data = ICitizenDataManager.getInstance().createFromNBT(compound, this.colony);
        this.topCitizenId = Math.max(this.topCitizenId, data.getId());
        return data;
    }

    @Override
    public void writeToNBT(@NotNull NBTTagCompound compound) {
        NBTTagList citizenTagList = this.citizens.values().stream().map(INBTSerializable::serializeNBT).collect(NBTUtils.toNBTTagList());
        compound.func_74782_a("citizens", (NBTBase)citizenTagList);
    }

    @Override
    public void registerCitizen(AbstractEntityCitizen citizen) {
        if (citizen.getCitizenId() == 0 || this.citizens.get(citizen.getCitizenId()) == null) {
            citizen.func_70106_y();
            return;
        }
        ICitizenData data = this.citizens.get(citizen.getCitizenId());
        Optional<AbstractEntityCitizen> existingCitizen = data.getCitizenEntity();
        if (!existingCitizen.isPresent()) {
            data.setCitizenEntity(citizen);
            citizen.setCitizenData(data);
            return;
        }
        if (existingCitizen.get() == citizen) {
            return;
        }
        if (existingCitizen.get().isDead() || !existingCitizen.get().field_70170_p.func_175667_e(existingCitizen.get().func_180425_c())) {
            existingCitizen.get().func_70106_y();
            data.setCitizenEntity(citizen);
            citizen.setCitizenData(data);
            return;
        }
        citizen.func_70106_y();
    }

    @Override
    public void unregisterCitizen(AbstractEntityCitizen citizen) {
        ICitizenData data = this.citizens.get(citizen.getCitizenId());
        if (data != null && data.getCitizenEntity().isPresent() && data.getCitizenEntity().get() == citizen) {
            this.citizens.get(citizen.getCitizenId()).setCitizenEntity(null);
        }
    }

    @Override
    public void sendPackets(@NotNull Set<EntityPlayerMP> closeSubscribers, @NotNull Set<EntityPlayerMP> newSubscribers) {
        if (this.isCitizensDirty || !newSubscribers.isEmpty()) {
            Set<EntityPlayerMP> players = this.isCitizensDirty ? closeSubscribers : newSubscribers;
            for (ICitizenData citizen : this.citizens.values()) {
                if (!citizen.getCitizenEntity().isPresent() || !citizen.isDirty() && newSubscribers.isEmpty()) continue;
                players.forEach(player -> MineColonies.getNetwork().sendTo((IMessage)new ColonyViewCitizenViewMessage(this.colony, citizen), player));
            }
            players.forEach(player -> MineColonies.getNetwork().sendTo((IMessage)new HappinessDataMessage(this.colony, this.colony.getHappinessData()), player));
        }
    }

    @Override
    public ICitizenData spawnOrCreateCitizen(@Nullable ICitizenData data, @Nullable World world, BlockPos spawnPos, boolean force) {
        BlockPos spawnLocation;
        if (!this.colony.getBuildingManager().hasTownHall() || !this.colony.canMoveIn() && !force) {
            return data;
        }
        BlockPos blockPos = spawnLocation = spawnPos != null && !spawnPos.equals((Object)BlockPos.field_177992_a) ? spawnPos : this.colony.getBuildingManager().getTownHall().getPosition();
        if (!world.func_175667_e(spawnLocation)) {
            return data;
        }
        BlockPos spawnPoint = EntityUtils.getSpawnPoint(world, spawnLocation);
        if (spawnPoint != null) {
            return this.spawnCitizenOnPosition(data, world, force, spawnPoint);
        }
        LanguageHandler.sendPlayersMessage(this.colony.getMessageEntityPlayers(), "com.minecolonies.coremod.citizens.nospace", spawnLocation.func_177958_n(), spawnLocation.func_177956_o(), spawnLocation.func_177952_p());
        return data;
    }

    @NotNull
    private ICitizenData spawnCitizenOnPosition(@Nullable ICitizenData data, @NotNull World world, boolean force, BlockPos spawnPoint) {
        ICitizenData citizenData = data;
        if (citizenData == null) {
            citizenData = this.createAndRegisterNewCitizenData();
            if (this.getMaxCitizens() == this.getCitizens().size() && !force) {
                LanguageHandler.sendPlayersMessage(this.colony.getMessageEntityPlayers(), "tile.blockHutTownHall.messageMaxSize", this.colony.getName());
            }
        }
        EntityCitizen entity = new EntityCitizen(world);
        entity.getCitizenColonyHandler().registerWithColony(citizenData.getColony().getID(), citizenData.getId());
        entity.func_70107_b((double)spawnPoint.func_177958_n() + 0.5, (double)spawnPoint.func_177956_o() + 0.1, (double)spawnPoint.func_177952_p() + 0.5);
        world.func_72838_d((Entity)entity);
        this.colony.getProgressManager().progressCitizenSpawn(this.citizens.size(), this.citizens.values().stream().filter(tempDate -> tempDate.getJob() != null).collect(Collectors.toList()).size());
        this.colony.getStatsManager().checkAchievements();
        this.markCitizensDirty();
        return citizenData;
    }

    @Override
    public CitizenData createAndRegisterNewCitizenData() {
        for (int i = 1; i <= this.getCurrentCitizenCount() + 1; ++i) {
            if (this.getCitizen(i) != null) continue;
            this.topCitizenId = i;
            break;
        }
        CitizenData citizenData = new CitizenData(this.topCitizenId, this.colony);
        citizenData.initForNewCitizen();
        this.citizens.put(citizenData.getId(), citizenData);
        return citizenData;
    }

    @Override
    public void removeCitizen(@NotNull ICitizenData citizen) {
        this.citizens.remove(citizen.getId());
        if (citizen.getWorkBuilding() != null) {
            citizen.getWorkBuilding().cancelAllRequestsOfCitizen(citizen);
        }
        if (citizen.getHomeBuilding() != null) {
            citizen.getHomeBuilding().cancelAllRequestsOfCitizen(citizen);
        }
        for (IBuilding building : this.colony.getBuildingManager().getBuildings().values()) {
            building.removeCitizen(citizen);
        }
        this.colony.getWorkManager().clearWorkForCitizen(citizen);
        for (EntityPlayerMP player : this.colony.getPackageManager().getCloseSubscribers()) {
            MineColonies.getNetwork().sendTo((IMessage)new ColonyViewRemoveCitizenMessage(this.colony, citizen.getId()), player);
        }
        this.calculateMaxCitizens();
        this.colony.markDirty();
    }

    @Override
    public ICitizenData getJoblessCitizen() {
        for (ICitizenData citizen : this.citizens.values()) {
            if (citizen.getWorkBuilding() != null || citizen.isChild()) continue;
            return citizen;
        }
        return null;
    }

    @Override
    public void calculateMaxCitizens() {
        int newMaxCitizens = 0;
        int potentialMax = 0;
        for (IBuilding b : this.colony.getBuildingManager().getBuildings().values()) {
            if (b.getBuildingLevel() <= 0) continue;
            if (b instanceof BuildingHome) {
                newMaxCitizens += b.getMaxInhabitants();
                continue;
            }
            if (!(b instanceof AbstractBuildingGuards) || b.getBuildingLevel() <= 0) continue;
            if (b.getAssignedCitizen().size() != 0) {
                newMaxCitizens += b.getAssignedCitizen().size();
                continue;
            }
            ++potentialMax;
        }
        if (this.getMaxCitizens() != newMaxCitizens) {
            this.setMaxCitizens(newMaxCitizens);
            this.setPotentialMaxCitizens(potentialMax + newMaxCitizens);
            this.colony.markDirty();
        }
    }

    @Override
    public void spawnOrCreateCitizen() {
        this.spawnOrCreateCitizen(null, this.colony.getWorld(), null);
    }

    @Override
    @NotNull
    public Map<Integer, ICitizenData> getCitizenMap() {
        return Collections.unmodifiableMap(this.citizens);
    }

    @Override
    public void markCitizensDirty() {
        this.colony.markDirty();
        this.isCitizensDirty = true;
    }

    @Override
    public ICitizenData getCitizen(int citizenId) {
        return this.citizens.get(citizenId);
    }

    @Override
    public void clearDirty() {
        this.isCitizensDirty = false;
        this.citizens.values().forEach(ICitizenData::clearDirty);
    }

    @Override
    public List<ICitizenData> getCitizens() {
        return new ArrayList<ICitizenData>(this.citizens.values());
    }

    @Override
    public int getMaxCitizens() {
        return Math.min(this.maxCitizens, Configurations.gameplay.maxCitizenPerColony);
    }

    @Override
    public int getPotentialMaxCitizens() {
        return Math.min(this.potentialMaxCitizens, Configurations.gameplay.maxCitizenPerColony);
    }

    @Override
    public int getCurrentCitizenCount() {
        return this.citizens.size();
    }

    @Override
    public void setMaxCitizens(int newMaxCitizens) {
        this.maxCitizens = newMaxCitizens;
    }

    @Override
    public void setPotentialMaxCitizens(int newPotentialMax) {
        this.potentialMaxCitizens = newPotentialMax;
    }

    @Override
    public void checkCitizensForHappiness() {
        int guards = 1;
        int housing = 0;
        int workers = 1;
        boolean hasJob = false;
        boolean hasHouse = false;
        double saturation = 0.0;
        for (ICitizenData citizen : this.getCitizens()) {
            IBuilding home;
            hasJob = false;
            hasHouse = false;
            IBuildingWorker buildingWorker = citizen.getWorkBuilding();
            if (buildingWorker != null) {
                hasJob = true;
                if (buildingWorker instanceof AbstractBuildingGuards) {
                    guards += buildingWorker.getBuildingLevel();
                } else {
                    workers += buildingWorker.getBuildingLevel();
                }
            }
            if ((home = citizen.getHomeBuilding()) != null) {
                hasHouse = true;
                housing += home.getBuildingLevel();
            }
            if (citizen.getCitizenEntity().isPresent()) {
                citizen.getCitizenHappinessHandler().processDailyHappiness(hasHouse, hasJob);
            }
            saturation += citizen.getSaturation();
        }
        int averageHousing = housing / Math.max(1, this.getCitizens().size());
        if (averageHousing > 1) {
            this.colony.getHappinessData().setHousing(1);
        } else if (averageHousing < 1) {
            this.colony.getHappinessData().setHousing(-1);
        } else {
            this.colony.getHappinessData().setHousing(0);
        }
        int averageSaturation = (int)(saturation / (double)this.getCitizens().size());
        if (averageSaturation < 5) {
            this.colony.getHappinessData().setSaturation(-1);
        } else if (averageSaturation > 5) {
            this.colony.getHappinessData().setSaturation(1);
        } else {
            this.colony.getHappinessData().setSaturation(0);
        }
        int relation = workers / guards;
        if (relation > 1) {
            this.colony.getHappinessData().setHousingModifier((double)relation * 0.1);
            this.colony.getHappinessData().setGuards(-1);
        } else if (relation < 1) {
            this.colony.getHappinessData().setGuards(1);
        } else {
            this.colony.getHappinessData().setGuards(0);
        }
    }

    @Override
    public void tickCitizenData() {
        this.getCitizens().forEach(ICitizenData::tick);
    }

    @Override
    public void onColonyTick(IColony colony) {
        if (colony.hasTownHall()) {
            this.getCitizens().stream().filter(Objects::nonNull).forEach(ICitizenData::updateCitizenEntityIfNecessary);
        }
        if (this.colony.hasTownHall() && this.getCitizens().size() < Configurations.gameplay.initialCitizenAmount) {
            this.respawnInterval -= 500 + 60 * colony.getBuildingManager().getTownHall().getBuildingLevel();
            if (this.respawnInterval <= 0) {
                this.respawnInterval = Configurations.gameplay.citizenRespawnInterval * 20;
                CitizenData newCitizen = this.createAndRegisterNewCitizenData();
                if (this.citizens.size() % 2 == 0) {
                    newCitizen.setIsFemale(true);
                } else {
                    newCitizen.setIsFemale(false);
                }
                this.spawnOrCreateCitizen(newCitizen, colony.getWorld(), null, true);
            }
        }
    }

    @Override
    public void updateCitizenMourn(boolean mourn) {
        for (ICitizenData citizen : this.getCitizens()) {
            if (!citizen.getCitizenEntity().isPresent() || citizen.getJob() instanceof AbstractJobGuard) continue;
            citizen.getCitizenEntity().get().setMourning(mourn);
        }
    }
}

