/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.colony.buildings.workerbuildings;

import com.minecolonies.api.blocks.ModBlocks;
import com.minecolonies.api.colony.ICitizenData;
import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.IColonyManager;
import com.minecolonies.api.colony.IColonyView;
import com.minecolonies.api.colony.buildings.IBuildingWorker;
import com.minecolonies.api.colony.buildings.ModBuildings;
import com.minecolonies.api.colony.buildings.registry.BuildingEntry;
import com.minecolonies.api.colony.jobs.IJob;
import com.minecolonies.api.colony.requestsystem.StandardFactoryController;
import com.minecolonies.api.colony.requestsystem.token.IToken;
import com.minecolonies.api.crafting.IRecipeStorage;
import com.minecolonies.api.crafting.ItemStorage;
import com.minecolonies.api.util.constant.TypeConstants;
import com.minecolonies.blockout.views.Window;
import com.minecolonies.coremod.MineColonies;
import com.minecolonies.coremod.client.gui.WindowHutCrusher;
import com.minecolonies.coremod.colony.buildings.AbstractBuildingCrafter;
import com.minecolonies.coremod.colony.jobs.JobCrusher;
import com.minecolonies.coremod.network.messages.CrusherSetModeMessage;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.Tuple;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.items.IItemHandler;
import org.jetbrains.annotations.NotNull;

public class BuildingCrusher
extends AbstractBuildingCrafter {
    private static final double BUILDING_LEVEL_MULTIPLIER = 16.0;
    private static final String CRUSHER_DESC = "Crusher";
    private static final int MAX_BUILDING_LEVEL = 5;
    private final Map<ItemStorage, IRecipeStorage> crusherRecipes = new HashMap<ItemStorage, IRecipeStorage>();
    private int dailyQuantity = 0;
    private int currentDailyQuantity = 0;
    private ItemStorage crusherMode = null;

    public BuildingCrusher(IColony c, BlockPos l) {
        super(c, l);
        this.loadCrusherMode();
    }

    private void loadCrusherMode() {
        for (Map.Entry<ItemStorage, ItemStorage> mode : IColonyManager.getInstance().getCompatibilityManager().getCrusherModes().entrySet()) {
            if (this.crusherMode == null) {
                this.crusherMode = mode.getKey();
            }
            ArrayList<ItemStack> input = new ArrayList<ItemStack>();
            input.add(mode.getKey().getItemStack());
            IRecipeStorage recipe = StandardFactoryController.getInstance().getNewInstance(TypeConstants.RECIPE, StandardFactoryController.getInstance().getNewInstance(TypeConstants.ITOKEN), new Object[]{input, 2, mode.getValue().getItemStack(), ModBlocks.blockHutCrusher});
            this.crusherRecipes.put(mode.getKey(), recipe);
        }
    }

    public IRecipeStorage getCurrentRecipe() {
        return this.crusherRecipes.get(this.crusherMode);
    }

    @Override
    @NotNull
    public String getSchematicName() {
        return CRUSHER_DESC;
    }

    @Override
    public int getMaxBuildingLevel() {
        return 5;
    }

    @Override
    @NotNull
    public IJob createJob(ICitizenData citizen) {
        return new JobCrusher(citizen);
    }

    @Override
    @NotNull
    public String getJobName() {
        return CRUSHER_DESC;
    }

    @Override
    public boolean canCraftComplexRecipes() {
        return false;
    }

    @Override
    public boolean canRecipeBeAdded(IToken token) {
        return false;
    }

    public void setCrusherMode(ItemStorage crusherMode, int dailyQuantity) {
        this.crusherMode = crusherMode;
        this.dailyQuantity = dailyQuantity;
    }

    public Tuple<ItemStorage, Integer> getCrusherMode() {
        return new Tuple((Object)this.crusherMode, (Object)this.dailyQuantity);
    }

    public void setCurrentDailyQuantity(int currentDailyQuantity) {
        this.currentDailyQuantity = currentDailyQuantity;
    }

    public int getMaxDailyQuantity() {
        if (this.getBuildingLevel() >= 5) {
            return Integer.MAX_VALUE;
        }
        return (int)(Math.pow(this.getBuildingLevel(), 2.0) * 16.0);
    }

    @Override
    public void onWakeUp() {
        super.onWakeUp();
        this.currentDailyQuantity = 0;
    }

    public int getCurrentDailyQuantity() {
        return this.currentDailyQuantity;
    }

    @Override
    public void deserializeNBT(NBTTagCompound compound) {
        super.deserializeNBT(compound);
        this.dailyQuantity = compound.func_74762_e("daily");
        this.currentDailyQuantity = compound.func_74762_e("currentDaily");
        if (compound.func_74764_b("Crushermode")) {
            this.crusherMode = new ItemStorage(new ItemStack(compound.func_74775_l("Crushermode")));
        }
        if (this.recipes.isEmpty()) {
            for (IRecipeStorage recipe : this.crusherRecipes.values()) {
                IToken token = IColonyManager.getInstance().getRecipeManager().checkOrAddRecipe(recipe);
                this.addRecipe(token);
            }
        }
    }

    @Override
    public NBTTagCompound serializeNBT() {
        NBTTagCompound compound = super.serializeNBT();
        compound.func_74768_a("daily", this.dailyQuantity);
        compound.func_74768_a("currentDaily", this.currentDailyQuantity);
        if (this.crusherMode != null) {
            NBTTagCompound crusherModeNBT = new NBTTagCompound();
            this.crusherMode.getItemStack().func_77955_b(crusherModeNBT);
            compound.func_74782_a("Crushermode", (NBTBase)crusherModeNBT);
        }
        return compound;
    }

    @Override
    public void serializeToView(@NotNull ByteBuf buf) {
        super.serializeToView(buf);
        if (this.crusherRecipes.isEmpty()) {
            this.loadCrusherMode();
        }
        if (this.crusherMode == null) {
            buf.writeBoolean(false);
        } else {
            buf.writeBoolean(true);
            ByteBufUtils.writeItemStack((ByteBuf)buf, (ItemStack)this.crusherMode.getItemStack());
        }
        buf.writeInt(this.dailyQuantity);
        buf.writeInt(this.crusherRecipes.size());
        for (ItemStorage storage : this.crusherRecipes.keySet()) {
            ByteBufUtils.writeItemStack((ByteBuf)buf, (ItemStack)storage.getItemStack());
        }
    }

    @Override
    public IRecipeStorage getFirstRecipe(Predicate<ItemStack> stackPredicate) {
        for (IRecipeStorage storage : this.crusherRecipes.values()) {
            if (storage == null || !stackPredicate.test(storage.getPrimaryOutput())) continue;
            return storage;
        }
        return null;
    }

    @Override
    public IRecipeStorage getFirstFullFillableRecipe(Predicate<ItemStack> stackPredicate, int count) {
        for (IRecipeStorage storage : this.crusherRecipes.values()) {
            List<IItemHandler> handlers;
            if (storage == null || !stackPredicate.test(storage.getPrimaryOutput()) || !storage.canFullFillRecipe(count, (handlers = this.getHandlers()).toArray(new IItemHandler[0]))) continue;
            return storage;
        }
        return null;
    }

    @Override
    public BuildingEntry getBuildingRegistryEntry() {
        return ModBuildings.crusher;
    }

    public static class View
    extends AbstractBuildingCrafter.View {
        private int dailyQuantity = 0;
        private ItemStorage crusherMode;
        private final List<ItemStorage> crusherModes = new ArrayList<ItemStorage>();

        public View(IColonyView c, BlockPos l) {
            super(c, l);
        }

        @Override
        public void deserialize(@NotNull ByteBuf buf) {
            super.deserialize(buf);
            if (buf.readBoolean()) {
                this.crusherMode = new ItemStorage(ByteBufUtils.readItemStack((ByteBuf)buf));
            }
            this.dailyQuantity = buf.readInt();
            this.crusherModes.clear();
            int size = buf.readInt();
            for (int i = 0; i < size; ++i) {
                this.crusherModes.add(new ItemStorage(ByteBufUtils.readItemStack((ByteBuf)buf)));
            }
        }

        public void setCrusherMode(ItemStorage crusherMode, int dailyQuantity) {
            this.crusherMode = crusherMode;
            this.dailyQuantity = dailyQuantity;
            MineColonies.getNetwork().sendToServer((IMessage)new CrusherSetModeMessage(this, crusherMode, dailyQuantity));
        }

        public Tuple<ItemStorage, Integer> getCrusherMode() {
            return new Tuple((Object)this.crusherMode, (Object)this.dailyQuantity);
        }

        public List<ItemStorage> getCrusherModes() {
            return this.crusherModes;
        }

        @Override
        @NotNull
        public Window getWindow() {
            return new WindowHutCrusher(this);
        }

        @Override
        @NotNull
        public IBuildingWorker.Skill getPrimarySkill() {
            return IBuildingWorker.Skill.STRENGTH;
        }

        @Override
        @NotNull
        public IBuildingWorker.Skill getSecondarySkill() {
            return IBuildingWorker.Skill.ENDURANCE;
        }
    }
}

