/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.colony;

import com.google.common.annotations.VisibleForTesting;
import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.util.Log;
import com.minecolonies.coremod.colony.Colony;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ColonyList<T extends IColony>
implements Iterable<T> {
    @VisibleForTesting
    static final int INITIAL_SIZE = 16;
    private final List<Integer> nullIndices = new ArrayList<Integer>();
    private IColony[] list = new IColony[16];
    private int topID = 0;
    private int size = 0;

    @NotNull
    public Colony create(World world, BlockPos position) {
        int colonyID = this.getNextColonyID();
        if (colonyID >= this.list.length) {
            this.expandList();
        }
        if (this.list[colonyID] != null) {
            Log.getLogger().error(String.format("Already a colony registered to id=%d, colony=%s, not creating new colony", colonyID, this.list[colonyID].getName()));
            return (Colony)this.list[colonyID];
        }
        Colony colony = new Colony(colonyID, world, position);
        ++this.size;
        this.list[colony.getID()] = colony;
        return colony;
    }

    private int getNextColonyID() {
        if (this.nullIndices.isEmpty()) {
            return ++this.topID;
        }
        return this.nullIndices.remove(0);
    }

    private void expandList() {
        IColony[] newList = new IColony[this.list.length * 2];
        System.arraycopy(this.list, 0, newList, 0, this.list.length);
        this.list = newList;
    }

    public void add(T colony) {
        T existingColony = this.get(colony.getID());
        if (existingColony != null && existingColony != colony) {
            Log.getLogger().error(String.format("Already a colony registered to id=%d, colony=%s, not changing to colony=%s", colony.getID(), existingColony.getName(), colony.getName()));
            return;
        }
        while (colony.getID() >= this.list.length) {
            this.expandList();
        }
        for (int emptyIds = colony.getID() - 1; emptyIds > 0 && this.list[emptyIds] == null; --emptyIds) {
            this.nullIndices.add(emptyIds);
        }
        ++this.size;
        this.topID = colony.getID();
        this.list[colony.getID()] = colony;
    }

    @Nullable
    public T get(int index) {
        if (index < 1 || index >= this.list.length) {
            return null;
        }
        return (T)this.list[index];
    }

    public void remove(T colony) {
        this.remove(colony.getID());
    }

    public void remove(int id) {
        if (this.list[id] == null) {
            Log.getLogger().warn("Tried to remove colony with id=%d, but it didn't exist.", (Object)id);
        }
        --this.size;
        this.list[id] = null;
        if (!this.nullIndices.contains(id)) {
            this.nullIndices.add(id);
        }
    }

    public void clear() {
        for (int i = 0; i < this.list.length; ++i) {
            this.list[i] = null;
        }
        this.nullIndices.clear();
        this.topID = 0;
        this.size = 0;
    }

    public int getTopID() {
        return this.topID;
    }

    public int getSize() {
        return this.size;
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    @NotNull
    public List<T> getCopyAsList() {
        ArrayList<IColony> copyList = new ArrayList<IColony>();
        for (IColony colony : this) {
            copyList.add(colony);
        }
        return copyList;
    }

    @Override
    public Iterator<T> iterator() {
        return new Iterator<T>(){
            private int nextIndex;
            {
                this.nextIndex = ColonyList.this.getNextIndex(0);
            }

            @Override
            public boolean hasNext() {
                return this.nextIndex < ColonyList.this.list.length;
            }

            @Override
            public T next() {
                int index = this.nextIndex;
                this.nextIndex = ColonyList.this.getNextIndex(this.nextIndex);
                if (index >= ColonyList.this.list.length) {
                    throw new NoSuchElementException();
                }
                return ColonyList.this.get(index);
            }
        };
    }

    private int getNextIndex(int startingIndex) {
        int index;
        for (index = startingIndex + 1; index < this.list.length; ++index) {
            if (this.list[index] == null) continue;
            return index;
        }
        return index;
    }

    public Stream<T> stream() {
        return StreamSupport.stream(this.spliterator(), false);
    }
}

